
**************************************************************************************************************************************************
******************* Code for 'Does monetary policy affect non-mining business investment in Australia? evidence from BLADE' *******************
***********************************************************************************************************************

**************************************************DATE: 27 Nov 2023 ******************************************************************************
**************************************************** AUTHOR: Gulnara Nolan and Jonathan Hambur *******************************************************************
*********************************************************************************************************************************************

*** Code strcuture
* 01 SET UP
*02 Construct variables 
*03 Generate LHS variables for the LPs
*04 RESULTS BY Cumulative
*05 LONG TERM INVESTMENT EXPECTATIONS
*06 SHORT TERM INVESTMENT EXPECTATIONS
*07 capex actual INVESTMENT
*08 nmbi(NON MINING BUSINESS INVESTMENT) with deflator 
*09 only with deflator
*10 OTHER INVESTMENT SECTORS
*11 regs with differences 


*** 01 SET UP
clear
graph drop _all
cap drop all
cd "C:\Users\folder\Documents\investment\Inv reponses\newresults\no contemporanous controls"
/*

import excel using "C:\Users\folder\Documents\investment\aggregate_data_updated.xlsx", sheet(data) firstrow clear 

g edate = mdy(month, day, year)
g qdate = qofd(edate)
format qdate %tq 
gen qr=.
replace qr=1 if month==1 | month==2 | month==3
replace qr=2 if month==4 | month==5 | month==6
replace qr=3 if month==7 | month==8 | month==9
replace qr=4 if month==10 | month==11 | month==12

collapse (mean) mining nonmining , by(year)

tsset year 

save "C:\Users\folder\Documents\investment\aggregate_data_updated.dta", replace
*/

****** IMPORTING DATA FROM NATIONAL ACCOUNTS 
import excel "C:\Users\folder\Documents\investment\Investment mon pol\Inv reponses\aggregate_data.xlsx", sheet("data") firstrow
g edate = mdy(month, day, year)
g qdate = qofd(edate)
format qdate %tq 


***02 Construct variables 
tsset qdate 
local varlist "nmbi minv me nrb eng gdp gne nmbi_n me_n nmi_exp_lt nmi_exp_st nmcapex" 
foreach v of local varlist {
g l`v' = log(`v')
g dl`v' = d.l`v'
}

g t = _n 

g gfc = 1
replace gfc = 0 if year<=2008
replace gfc = 1 if year==2008 & month>=9

save "C:\Users\folder\Documents\investment\Investment mon pol\Inv reponses\inv.dta", replace

**** DATA FOR SHOCKS
clear all

use "C:\Users\folder\Documents\investment\Investment\Macro data for local projections.dta",clear
gen qr=.
replace qr=1 if month==1 | month==2 | month==3
replace qr=2 if month==4 | month==5 | month==6
replace qr=3 if month==7 | month==8 | month==9
replace qr=4 if month==10 | month==11 | month==12

rename gdp gdp2
gen qdate=yq(year,qr)
format qdate %tq


collapse (mean) ur cpi cpi_q gdp2 ret_q_nom ret_q_real cr_targ BT beckers beckers_aug  (sum)level path tp , by(qdate)

** MERGING SHOCKS DATA WITH INVESTMENT DATA
merge m:m  qdate using "C:\Users\folder\Documents\investment\Investment mon pol\Inv reponses\inv.dta"
keep if _m==3
drop _m
tsset qdate

*** BRINGING IN INVESTMENT PRICE DEFLATOR
merge 1:1  qdate using "C:\Users\folder\Documents\investment\Investment mon pol\Inv reponses\deflator.dta"
keep if _m==3
drop _m
tsset qdate

*Choose impulse response horizon 
local hmax = 16

/*03 Generate LHS variables for the LPs */

* levels
forvalues h = 0/16 {
local varlist "nmbi minv me nrb eng gdp gne nmbi_n me_n" 
foreach v of local varlist {
quietly g l`v'_`h' = f`h'.`v'
}
}

* differences
forvalues h = 0/16 {
local varlist "nmbi minv me nrb eng gdp gne nmbi_n me_n" 
foreach v of local varlist {
quietly g dl`v'_`h' = f`h'.l`v'-l.f`h'.l`v'
}
}

* cumulative 
forvalues h = 0/16 {
local varlist "nmbi minv me nrb eng gdp gne nmbi_n me_n nmi_exp_lt nmi_exp_st nmcapex" 
foreach v of local varlist {
quietly g l`v'c`h' = f`h'.l`v'-l.l`v'
}
}




gen trend= year-1994
gen trend_sq=trend^2

*04 RESULTS BY Cumulative

*===Non-mining Investment 
local hmax = 16
cap drop b u d Quarters Zero
gen Quarters = _n-1 if _n<=`hmax'+1
gen Zero =  0    if _n<=`hmax'+1
gen b=0
gen u=0
gen d=0


eststo clear
set level 90 


forv h = 0/16 {

eststo: reg lnmbic`h' l(0/1).beckers_aug L(1/1).dlnmbi l(0/1).gdp2 l(0/1).cpi , vce(cluster qdate)

replace b = _b[beckers]*100                       if _n == `h'+1
replace u = (_b[beckers] + 1.645* _se[beckers])*100  if _n == `h'+1
replace d = (_b[beckers] - 1.645* _se[beckers])*100  if _n == `h'+1

}

twoway ///
(rarea u d  Quarters,  ///
fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
(line b Quarters, lcolor(blue) ///
lpattern(solid) lwidth(thick)) ///
(line Zero Quarters, lcolor(black)), legend(off) ///
title("Cumulative response of non-mining investment*", color(black) size(medsmall)) ///
subtitle("To a 1ppt surprise monetary tightening", color(black) size(medsmall)) ///
ytitle("Percent", size(medsmall)) xtitle("Quarters", size(medsmall)) ///
graphregion(color(white)) plotregion(color(white))	///
note("*Shaded area represents 90 per cent confidence interval")
gr rename fig_cum_mps`i', replace
graph export fig_nmbi_cumul_mpsua.png, replace 

esttab using "C:\Users\folder\Documents\investment\Inv reponses\newresults\no contemporanous controls\cum_nmbi_90.csv", replace nostar ci

eststo clear

set level 90

forv h = 0/16 {

eststo: reg lnmbic`h' l(0/1).beckers_aug L(1/1).lnmbi l(0/1).gdp2 l(0/1).cpi , vce(cluster qdate)

replace b = _b[beckers]*100                       if _n == `h'+1
replace u = (_b[beckers] + 1.96* _se[beckers])*100  if _n == `h'+1
replace d = (_b[beckers] - 1.96* _se[beckers])*100  if _n == `h'+1

}

twoway ///
(rarea u d  Quarters,  ///
fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
(line b Quarters, lcolor(blue) ///
lpattern(solid) lwidth(thick)) ///
(line Zero Quarters, lcolor(black)), legend(off) ///
title("Cumulative response of non-mining investment*", color(black) size(medsmall)) ///
subtitle("To a 1ppt surprise monetary tightening", color(black) size(medsmall)) ///
ytitle("Percent", size(medsmall)) xtitle("Quarters", size(medsmall)) ///
graphregion(color(white)) plotregion(color(white))	///
note("*Shaded area represents 95 per cent confidence interval")
gr rename fig_cum_mps`i'2, replace
graph export fig_nmbi_cumul_mpsua2.png, replace 

esttab using "C:\Users\folder\Documents\investment\Inv reponses\newresults\no contemporanous controls\cum_nmbi2_90.csv", replace nostar ci



g loglnmbi=log(nmbi)
g defnmbi=nmbi/Current

g logdefnmbi=log(defnmbi)

forvalues h = 0/16 {
local varlist "loglnmbi" 
foreach v of local varlist {
quietly g `v'`h' = f`h'.`v'
}
}

forvalues h = 0/16 {
local varlist "logdefnmbi" 
foreach v of local varlist {
quietly g `v'`h' = f`h'.`v'
}
}

g logdef=log(Current)
forvalues h = 0/16 {
local varlist "logdef" 
foreach v of local varlist {
quietly g `v'`h' = f`h'.`v'
}
}

forvalues h = 0/16 {
local varlist "lnmi_exp_lt lnmi_exp_st lnmcapex" 
foreach v of local varlist {
quietly g `v'`h' = f`h'.`v'
}
}




eststo clear
forv h = 0/16 {

eststo: reg loglnmbi`h' l(0/1).beckers_aug L(1/1).lnmbi l(0/1).gdp2 l(0/1).cpi , vce(cluster qdate)

replace b = _b[beckers]*100                       if _n == `h'+1
replace u = (_b[beckers] + 1.96* _se[beckers])*100  if _n == `h'+1
replace d = (_b[beckers] - 1.96* _se[beckers])*100  if _n == `h'+1

}

twoway ///
(rarea u d  Quarters,  ///
fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
(line b Quarters, lcolor(blue) ///
lpattern(solid) lwidth(thick)) ///
(line Zero Quarters, lcolor(black)), legend(off) ///
title("Response of non-mining investment*", color(black) size(medsmall)) ///
subtitle("To a 1ppt surprise monetary tightening", color(black) size(medsmall)) ///
ytitle("Percent", size(medsmall)) xtitle("Quarters", size(medsmall)) ///
graphregion(color(white)) plotregion(color(white))	///
note("*Shaded area represents 95 per cent confidence interval")
gr rename fig_cum_mps`i'3, replace
graph export fig_nmbi_cumul_mpsua3.png, replace 

esttab using "C:\Users\folder\Documents\investment\Inv reponses\newresults\cum_nmbi3.csv", replace nostar ci

******
***05 LONG TERM INVESTMENT EXPECTATIONS

eststo clear
forv h = 0/16 {

eststo: reg lnmi_exp_lt`h' l(0/1).beckers_aug L(1/1).lnmi_exp_lt l(0/1).gdp2 l(0/1).cpi i.qr, vce(cluster qdate)

replace b = _b[beckers]*100                       if _n == `h'+1
replace u = (_b[beckers] + 1.96* _se[beckers])*100  if _n == `h'+1
replace d = (_b[beckers] - 1.96* _se[beckers])*100  if _n == `h'+1

}

twoway ///
(rarea u d  Quarters,  ///
fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
(line b Quarters, lcolor(blue) ///
lpattern(solid) lwidth(thick)) ///
(line Zero Quarters, lcolor(black)), legend(off) ///
title("Response of long-term non-mining investment expectations*", color(black) size(medsmall)) ///
subtitle("To a 1ppt surprise monetary tightening", color(black) size(medsmall)) ///
ytitle("Percent", size(medsmall)) xtitle("Quarters", size(medsmall)) ///
graphregion(color(white)) plotregion(color(white))	///
note("*Shaded area represents 95 per cent confidence interval")
gr rename fig_cum_mps`i'3_longterm, replace
graph export fig_nmbi_cumul_mpsua3_longterm.png, replace 

esttab using "C:\Users\folder\Documents\investment\Inv reponses\newresults\cum_nmbi3_longtermexp.csv", replace nostar ci





****06 SHORT TERM INVESTMENT EXPECTATIONS

eststo clear
forv h = 0/16 {

eststo: reg nmcapex`h' l(0/1).beckers_aug L(1/1).lnmi_exp_st l(0/1).gdp2 l(0/1).cpi i.qr, vce(cluster qdate)

replace b = _b[beckers]*100                       if _n == `h'+1
replace u = (_b[beckers] + 1.96* _se[beckers])*100  if _n == `h'+1
replace d = (_b[beckers] - 1.96* _se[beckers])*100  if _n == `h'+1

}

twoway ///
(rarea u d  Quarters,  ///
fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
(line b Quarters, lcolor(blue) ///
lpattern(solid) lwidth(thick)) ///
(line Zero Quarters, lcolor(black)), legend(off) ///
title("Response of short-term non-mining investment expectations*", color(black) size(medsmall)) ///
subtitle("To a 1ppt surprise monetary tightening", color(black) size(medsmall)) ///
ytitle("Percent", size(medsmall)) xtitle("Quarters", size(medsmall)) ///
graphregion(color(white)) plotregion(color(white))	///
note("*Shaded area represents 95 per cent confidence interval")
gr rename fig_cum_mps`i'3_shortterm, replace
graph export fig_nmbi_cumul_mpsua3_shortterm.png, replace 

esttab using "C:\Users\folder\Documents\investment\Inv reponses\newresults\cum_nmbi3_shorttermexp.csv", replace nostar ci


*****07 capex actual INVESTMENT

eststo clear
forv h = 0/16 {

eststo: reg lnmcapex`h' l(0/1).beckers_aug L(1/1).lnmcapex l(0/1).gdp2 l(0/1).cpi i.qr, vce(cluster qdate)

replace b = _b[beckers]*100                       if _n == `h'+1
replace u = (_b[beckers] + 1.96* _se[beckers])*100  if _n == `h'+1
replace d = (_b[beckers] - 1.96* _se[beckers])*100  if _n == `h'+1

}

twoway ///
(rarea u d  Quarters,  ///
fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
(line b Quarters, lcolor(blue) ///
lpattern(solid) lwidth(thick)) ///
(line Zero Quarters, lcolor(black)), legend(off) ///
title("Response of actual capex*", color(black) size(medsmall)) ///
subtitle("To a 1ppt surprise monetary tightening", color(black) size(medsmall)) ///
ytitle("Percent", size(medsmall)) xtitle("Quarters", size(medsmall)) ///
graphregion(color(white)) plotregion(color(white))	///
note("*Shaded area represents 95 per cent confidence interval")
gr rename fig_cum_mps`i'3_actualcapex, replace
graph export fig_nmbi_cumul_mpsua3_actualcapex.png, replace 

esttab using "C:\Users\folder\Documents\investment\Inv reponses\newresults\cum_nmbi3_actualcapex.csv", replace nostar ci



***************08 nmbi(NON MINING BUSINESS INVESTMENT) with deflator 
eststo clear
forv h = 0/16 {

eststo: reg logdefnmbi`h' l(0/1).beckers_aug L(1/1).logdefnmbi l(0/1).gdp2 l(0/1).cpi , vce(cluster qdate)

replace b = _b[beckers]*100                       if _n == `h'+1
replace u = (_b[beckers] + 1.96* _se[beckers])*100  if _n == `h'+1
replace d = (_b[beckers] - 1.96* _se[beckers])*100  if _n == `h'+1

}

twoway ///
(rarea u d  Quarters,  ///
fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
(line b Quarters, lcolor(blue) ///
lpattern(solid) lwidth(thick)) ///
(line Zero Quarters, lcolor(black)), legend(off) ///
title("Response of deflated non-mining investment*", color(black) size(medsmall)) ///
subtitle("To a 1ppt surprise monetary tightening", color(black) size(medsmall)) ///
ytitle("Percent", size(medsmall)) xtitle("Quarters", size(medsmall)) ///
graphregion(color(white)) plotregion(color(white))	///
note("*Shaded area represents 95 per cent confidence interval")
gr rename fig_cum_mps`i'3def, replace
graph export fig_nmbi_cumul_mpsua3def.png, replace 

esttab using "C:\Users\folder\Documents\investment\Inv reponses\newresults\cum_nmbi3def.csv", replace nostar ci




***************09 only with deflator 
eststo clear
set level 90
forv h = 0/16 {

eststo: reg logdef`h' l(0/1).beckers_aug L(1/1).logdef l(0/1).gdp2 l(0/1).cpi , vce(cluster qdate)

replace b = _b[beckers]*100                       if _n == `h'+1
replace u = (_b[beckers] + 1.96* _se[beckers])*100  if _n == `h'+1
replace d = (_b[beckers] - 1.96* _se[beckers])*100  if _n == `h'+1

}

twoway ///
(rarea u d  Quarters,  ///
fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
(line b Quarters, lcolor(blue) ///
lpattern(solid) lwidth(thick)) ///
(line Zero Quarters, lcolor(black)), legend(off) ///
title("Response of deflator*", color(black) size(medsmall)) ///
subtitle("To a 1ppt surprise monetary tightening", color(black) size(medsmall)) ///
ytitle("Percent", size(medsmall)) xtitle("Quarters", size(medsmall)) ///
graphregion(color(white)) plotregion(color(white))	///
note("*Shaded area represents 95 per cent confidence interval")
gr rename fig_cum_mps`i'3defonly, replace
graph export fig_nmbi_cumul_mpsua3defonly.png, replace 

esttab using "C:\Users\folder\Documents\investment\Inv reponses\newresults\no contemporanous controls\cum_nmbi3defonly_90.csv", replace nostar ci









***10 OTHER INVESTMENT SECTORS
*===Non-residential Building Investment 



eststo clear
forv h = 0/16 {

eststo: reg lnrbc`h' l(0/1).beckers_aug L(1/1).dlnrb l(0/1).gdp2 l(0/1).cpi , vce(cluster qdate)

replace b = _b[beckers]*100                   if _n == `h'+1
replace u = (_b[beckers] + 1.96* _se[beckers])*100  if _n == `h'+1
replace d = (_b[beckers] - 1.96* _se[beckers])*100  if _n == `h'+1

}

twoway ///
(rarea u d  Quarters,  ///
fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
(line b Quarters, lcolor(blue) ///
lpattern(solid) lwidth(thick)) ///
(line Zero Quarters, lcolor(black)), legend(off) ///
title("Cumulative response of non-residential building investment*", color(black) size(medsmall)) ///
subtitle("To a 1ppt surprise monetary tightening", color(black) size(medsmall)) ///
ytitle("Percent", size(medsmall)) xtitle("Quarters", size(medsmall)) ///
graphregion(color(white)) plotregion(color(white))	///
note("*Shaded area represents 95 per cent confidence interval")
gr rename fig_cum_mps_nrb, replace
graph export fig_nrb_cumul_mpsua.png, replace 

esttab using "C:\Users\folder\Documents\investment\Inv reponses\test\cum_nrb.csv", replace nostar ci


eststo clear
forv h = 0/16 {

eststo: reg lnrbc`h' l(0/1).beckers_aug L(1/1).lnrb l(0/1).gdp2 l(0/1).cpi , vce(cluster qdate)

replace b = _b[beckers]*100                   if _n == `h'+1
replace u = (_b[beckers] + 1.96* _se[beckers])*100  if _n == `h'+1
replace d = (_b[beckers] - 1.96* _se[beckers])*100  if _n == `h'+1

}

twoway ///
(rarea u d  Quarters,  ///
fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
(line b Quarters, lcolor(blue) ///
lpattern(solid) lwidth(thick)) ///
(line Zero Quarters, lcolor(black)), legend(off) ///
title("Cumulative response of non-residential building investment*", color(black) size(medsmall)) ///
subtitle("To a 1ppt surprise monetary tightening", color(black) size(medsmall)) ///
ytitle("Percent", size(medsmall)) xtitle("Quarters", size(medsmall)) ///
graphregion(color(white)) plotregion(color(white))	///
note("*Shaded area represents 95 per cent confidence interval")
gr rename fig_cum_mps_nrb2, replace
graph export fig_nrb_cumul_mpsua2.png, replace 

esttab using "C:\Users\folder\Documents\investment\Inv reponses\test\cum_nrb2.csv", replace nostar ci


*===Machinery & Equipment Investment 



eststo clear
forv h = 0/16 {

eststo: reg lmec`h' l(0/1).beckers_aug L(1/1).dlme l(0/1).gdp2 l(0/1).cpi, vce(cluster qdate)

replace b = _b[beckers]*100                   if _n == `h'+1
replace u = (_b[beckers] + 1.96* _se[beckers])*100  if _n == `h'+1
replace d = (_b[beckers] - 1.96* _se[beckers])*100  if _n == `h'+1
}

twoway ///
(rarea u d  Quarters,  ///
fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
(line b Quarters, lcolor(blue) ///
lpattern(solid) lwidth(thick)) ///
(line Zero Quarters, lcolor(black)), legend(off) ///
title("Cumulative response of machinery & equipment investment*", color(black) size(medsmall)) ///
subtitle("To a 1ppt surprise monetary tightening", color(black) size(medsmall)) ///
ytitle("Percent", size(medsmall)) xtitle("Quarters", size(medsmall)) ///
graphregion(color(white)) plotregion(color(white))	///
note("*Shaded area represents 95 per cent confidence interval")
gr rename fig_cum_mps_me, replace
graph export fig_me_cumul_mpsua.png, replace 

esttab using "C:\Users\folder\Documents\investment\Inv reponses\test\cum_me.csv", replace nostar ci


eststo clear
forv h = 0/16 {

eststo: reg lmec`h' l(0/1).beckers_aug L(1/1).lme l(0/1).gdp2 l(0/1).cpi, vce(cluster qdate)

replace b = _b[beckers]*100                   if _n == `h'+1
replace u = (_b[beckers] + 1.96* _se[beckers])*100  if _n == `h'+1
replace d = (_b[beckers] - 1.96* _se[beckers])*100  if _n == `h'+1
}

twoway ///
(rarea u d  Quarters,  ///
fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
(line b Quarters, lcolor(blue) ///
lpattern(solid) lwidth(thick)) ///
(line Zero Quarters, lcolor(black)), legend(off) ///
title("Cumulative response of machinery & equipment investment*", color(black) size(medsmall)) ///
subtitle("To a 1ppt surprise monetary tightening", color(black) size(medsmall)) ///
ytitle("Percent", size(medsmall)) xtitle("Quarters", size(medsmall)) ///
graphregion(color(white)) plotregion(color(white))	///
note("*Shaded area represents 95 per cent confidence interval")
gr rename fig_cum_mps_me2, replace
graph export fig_me_cumul_mpsua2.png, replace 

esttab using "C:\Users\folder\Documents\investment\Inv reponses\test\cum_me2.csv", replace nostar ci


*===Engineering Investment 



eststo clear
forv h = 0/16 {
eststo: reg lengc`h' l(0/1).beckers_aug L(1/1).dleng l(0/1).gdp2 l(0/1).cpi , vce(cluster qdate)

replace b = _b[beckers]*100                   if _n == `h'+1
replace u = (_b[beckers] + 1.96* _se[beckers])*100  if _n == `h'+1
replace d = (_b[beckers] - 1.96* _se[beckers])*100  if _n == `h'+1

} 

twoway ///
(rarea u d  Quarters,  ///
fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
(line b Quarters, lcolor(blue) ///
lpattern(solid) lwidth(thick)) ///
(line Zero Quarters, lcolor(black)), legend(off) ///
title("Cumulative response of engineering investment*", color(black) size(medsmall)) ///
subtitle("To a 1ppt surprise monetary tightening", color(black) size(medsmall)) ///
ytitle("Percent", size(medsmall)) xtitle("Quarters", size(medsmall)) ///
graphregion(color(white)) plotregion(color(white))	///
note("*Shaded area represents 95 per cent confidence interval")
gr rename fig_cum_mps_eng, replace
graph export fig_eng_cumul_mpsua.png, replace 


esttab using "C:\Users\folder\Documents\investment\Inv reponses\test\cum_eng.csv", replace nostar ci

eststo clear
forv h = 0/16 {
eststo: reg lengc`h' l(0/1).beckers_aug L(1/1).leng l(0/1).gdp2 l(0/1).cpi , vce(cluster qdate)

replace b = _b[beckers]*100                   if _n == `h'+1
replace u = (_b[beckers] + 1.96* _se[beckers])*100  if _n == `h'+1
replace d = (_b[beckers] - 1.96* _se[beckers])*100  if _n == `h'+1

} 

twoway ///
(rarea u d  Quarters,  ///
fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
(line b Quarters, lcolor(blue) ///
lpattern(solid) lwidth(thick)) ///
(line Zero Quarters, lcolor(black)), legend(off) ///
title("Cumulative response of engineering investment*", color(black) size(medsmall)) ///
subtitle("To a 1ppt surprise monetary tightening", color(black) size(medsmall)) ///
ytitle("Percent", size(medsmall)) xtitle("Quarters", size(medsmall)) ///
graphregion(color(white)) plotregion(color(white))	///
note("*Shaded area represents 95 per cent confidence interval")
gr rename fig_cum_mps_eng2, replace
graph export fig_eng_cumul_mpsua2.png, replace 


esttab using "C:\Users\folder\Documents\investment\Inv reponses\test\cum_eng2.csv", replace nostar ci


*===Mining Investment 


eststo clear
forv h = 0/16 {

eststo: reg lminvc`h' l(0/1).beckers_aug L(1/1).dlminv l(0/1).gdp2 l(0/1).cpi , vce(cluster qdate)

replace b = _b[beckers]                   	 if _n == `h'+1
replace u = _b[beckers] + 1.96* _se[beckers]  if _n == `h'+1
replace d = _b[beckers] - 1.96* _se[beckers]  if _n == `h'+1

}

twoway ///
(rarea u d  Quarters,  ///
fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
(line b Quarters, lcolor(blue) ///
lpattern(solid) lwidth(thick)) ///
(line Zero Quarters, lcolor(black)), legend(off) ///
title("Cumulative response of mining investment*", color(black) size(medsmall)) ///
subtitle("To a 1ppt surprise monetary tightening", color(black) size(medsmall)) ///
ytitle("Percent", size(medsmall)) xtitle("Quarters", size(medsmall)) ///
graphregion(color(white)) plotregion(color(white))	///
note("*Shaded area represents 95 per cent confidence interval")
gr rename fig_cum_mps_minv, replace
graph export fig_minv_cumul_mpsua.png, replace 

esttab using "C:\Users\folder\Documents\investment\Inv reponses\test\cum_minv.csv", replace nostar ci


eststo clear
forv h = 0/16 {

eststo: reg lminvc`h' l(0/1).beckers_aug L(1/1).lminv l(0/1).gdp2 l(0/1).cpi , vce(cluster qdate)

replace b = _b[beckers]                   	 if _n == `h'+1
replace u = _b[beckers] + 1.96* _se[beckers]  if _n == `h'+1
replace d = _b[beckers] - 1.96* _se[beckers]  if _n == `h'+1

}

twoway ///
(rarea u d  Quarters,  ///
fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
(line b Quarters, lcolor(blue) ///
lpattern(solid) lwidth(thick)) ///
(line Zero Quarters, lcolor(black)), legend(off) ///
title("Cumulative response of mining investment*", color(black) size(medsmall)) ///
subtitle("To a 1ppt surprise monetary tightening", color(black) size(medsmall)) ///
ytitle("Percent", size(medsmall)) xtitle("Quarters", size(medsmall)) ///
graphregion(color(white)) plotregion(color(white))	///
note("*Shaded area represents 95 per cent confidence interval")
gr rename fig_cum_mps_minv2, replace
graph export fig_minv_cumul_mpsua2.png, replace 

esttab using "C:\Users\folder\Documents\investment\Inv reponses\test\cum_minv2.csv", replace nostar ci

/* THE END */


******11 regs with differences 
*** INVESTMENT DEFINED AS DIFFERENCE

*===Non-mining Investment 
local hmax = 16
cap drop b u d Quarters Zero
gen Quarters = _n-1 if _n<=`hmax'+1
gen Zero =  0    if _n<=`hmax'+1
gen b=0
gen u=0
gen d=0


eststo clear
forv h = 0/16 {

eststo: reg dlnmbi_`h' l(0/1).beckers_aug L(1/1).dlnmbi l(0/1).gdp2 l(0/1).cpi , vce(cluster qdate)

replace b = _b[beckers]*100                       if _n == `h'+1
replace u = (_b[beckers] + 1.96* _se[beckers])*100  if _n == `h'+1
replace d = (_b[beckers] - 1.96* _se[beckers])*100  if _n == `h'+1

}



twoway ///
(rarea u d  Quarters,  ///
fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
(line b Quarters, lcolor(blue) ///
lpattern(solid) lwidth(thick)) ///
(line Zero Quarters, lcolor(black)), legend(off) ///
title("Difference response of non-mining investment*", color(black) size(medsmall)) ///
subtitle("To a 1ppt surprise monetary tightening", color(black) size(medsmall)) ///
ytitle("Percent", size(medsmall)) xtitle("Quarters", size(medsmall)) ///
graphregion(color(white)) plotregion(color(white))	///
note("*Shaded area represents 95 per cent confidence interval")
gr rename fig_diff_mps`i', replace
graph export fig_nmbi_diff_mpsua.png, replace 

esttab using "C:\Users\folder\Documents\investment\Inv reponses\test\diff_nmbi.csv", replace nostar ci

*===Non-residential Building Investment 



eststo clear
forv h = 0/16 {

eststo: reg dlnrb_`h' l(0/1).beckers_aug L(1/1).dlnrb l(0/1).gdp2 l(0/1).cpi , vce(cluster qdate)

replace b = _b[beckers]*100                   if _n == `h'+1
replace u = (_b[beckers] + 1.96* _se[beckers])*100  if _n == `h'+1
replace d = (_b[beckers] - 1.96* _se[beckers])*100  if _n == `h'+1

}

twoway ///
(rarea u d  Quarters,  ///
fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
(line b Quarters, lcolor(blue) ///
lpattern(solid) lwidth(thick)) ///
(line Zero Quarters, lcolor(black)), legend(off) ///
title("Difference response of non-residential building investment*", color(black) size(medsmall)) ///
subtitle("To a 1ppt surprise monetary tightening", color(black) size(medsmall)) ///
ytitle("Percent", size(medsmall)) xtitle("Quarters", size(medsmall)) ///
graphregion(color(white)) plotregion(color(white))	///
note("*Shaded area represents 95 per cent confidence interval")
gr rename fig_diff_mps_nrb, replace
graph export fig_nrb_diff_mpsua.png, replace 

esttab using "C:\Users\folder\Documents\investment\Inv reponses\test\diff_nrb.csv", replace nostar ci

*===Machinery & Equipment Investment 



eststo clear
forv h = 0/16 {

eststo: reg dlme_`h' l(0/1).beckers_aug L(1/1).dlme l(0/1).gdp2 l(0/1).cpi , vce(cluster qdate)

replace b = _b[beckers]*100                   if _n == `h'+1
replace u = (_b[beckers] + 1.96* _se[beckers])*100  if _n == `h'+1
replace d = (_b[beckers] - 1.96* _se[beckers])*100  if _n == `h'+1
}

twoway ///
(rarea u d  Quarters,  ///
fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
(line b Quarters, lcolor(blue) ///
lpattern(solid) lwidth(thick)) ///
(line Zero Quarters, lcolor(black)), legend(off) ///
title("Difference response of machinery & equipment investment*", color(black) size(medsmall)) ///
subtitle("To a 1ppt surprise monetary tightening", color(black) size(medsmall)) ///
ytitle("Percent", size(medsmall)) xtitle("Quarters", size(medsmall)) ///
graphregion(color(white)) plotregion(color(white))	///
note("*Shaded area represents 95 per cent confidence interval")
gr rename fig_diff_mps_me, replace
graph export fig_me_diff_mpsua.png, replace 

esttab using "C:\Users\folder\Documents\investment\Inv reponses\test\diff_me.csv", replace nostar ci


*===Engineering Investment 



eststo clear
forv h = 0/16 {
eststo: reg dleng_`h' l(0/1).beckers_aug L(1/1).dleng l(0/1).gdp2 l(0/1).cpi , vce(cluster qdate)

replace b = _b[beckers]*100                   if _n == `h'+1
replace u = (_b[beckers] + 1.96* _se[beckers])*100  if _n == `h'+1
replace d = (_b[beckers] - 1.96* _se[beckers])*100  if _n == `h'+1

}

twoway ///
(rarea u d  Quarters,  ///
fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
(line b Quarters, lcolor(blue) ///
lpattern(solid) lwidth(thick)) ///
(line Zero Quarters, lcolor(black)), legend(off) ///
title("Difference response of engineering investment*", color(black) size(medsmall)) ///
subtitle("To a 1ppt surprise monetary tightening", color(black) size(medsmall)) ///
ytitle("Percent", size(medsmall)) xtitle("Quarters", size(medsmall)) ///
graphregion(color(white)) plotregion(color(white))	///
note("*Shaded area represents 95 per cent confidence interval")
gr rename fig_diff_mps_eng, replace
graph export fig_eng_diff_mpsua.png, replace 


esttab using "C:\Users\folder\Documents\investment\Inv reponses\test\diff_eng.csv", replace nostar ci

*===Mining Investment 


eststo clear
forv h = 0/16 {

eststo: reg dlminv_`h' l(0/1).beckers_aug L(1/1).dlminv l(0/1).gdp2 l(0/1).cpi , vce(cluster qdate)

replace b = _b[beckers]                   	 if _n == `h'+1
replace u = _b[beckers] + 1.96* _se[beckers]  if _n == `h'+1
replace d = _b[beckers] - 1.96* _se[beckers]  if _n == `h'+1

}

twoway ///
(rarea u d  Quarters,  ///
fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
(line b Quarters, lcolor(blue) ///
lpattern(solid) lwidth(thick)) ///
(line Zero Quarters, lcolor(black)), legend(off) ///
title("Difference response of mining investment*", color(black) size(medsmall)) ///
subtitle("To a 1ppt surprise monetary tightening", color(black) size(medsmall)) ///
ytitle("Percent", size(medsmall)) xtitle("Quarters", size(medsmall)) ///
graphregion(color(white)) plotregion(color(white))	///
note("*Shaded area represents 95 per cent confidence interval")
gr rename fig_diff_mps_minv, replace
graph export fig_minv_diff_mpsua.png, replace 

esttab using "C:\Users\folder\Documents\investment\Inv reponses\test\diff_minv.csv", replace nostar ci



/*
clear 

import excel using "C:\Users\folder\Documents\investment\non-mining deflator.xlsx", sheet(data) firstrow clear 
rename A Date

keep Date-Yearendedgrowth

format Date %td
gen month1=month(Date)
gen year1=year(Date)

destring year1 month1, replace
rename year1 year
rename month1 month


gen qr=.
replace qr=1 if month==1 | month==2 | month==3
replace qr=2 if month==4 | month==5 | month==6
replace qr=3 if month==7 | month==8 | month==9
replace qr=4 if month==10 | month==11 | month==12

gen qdate=yq(year,qr)
format qdate %tq


save "C:\Users\folder\Documents\investment\Investment mon pol\Inv reponses\deflator.dta", replace
*/

