% Replication files for Giacomini R, T Kitagawa and M Read (2023),
% 'Identification and Inference Under Narrative Restrictions', RBA Research
% Discussion Paper No 2023-07.

% Running this script generates the results underlying all figures in the
% paper. .eps and .png versions are exported to the 'Figures' folder.

clear variables
close all
clc

% Figure 1 - illustration of likelihood and posterior for impulse response 
% under shock-sign restriction.
ShockSignIllustration; 

% Figure 2 - illustration of likelihood under historical-decomposition
% restriction.
HistoricalDecompositionIllustration;

% Figure 3 - first panel - illustration of Hellinger distance under
% shock-sign restriction.
ShockSignHellinger;

% Figure 3 - second panel - illustration of Hellinger distance under
% historical-decomposition restriction.
HistoricalDecompositionHellinger;

% Figures 4 and 5 - impulse responses to monetary policy shock under
% different sets of restrictions.
MP_mainfile;
MP_Figures;

% Export graph data to Excel for plotting - optional!
exportGraphData;
