# -*- coding: utf-8 -*-
def update_progress(progress, total, size=100):
    bsize = size - 10
    percent =  100 * progress / total
    bar = '|' + round(percent * bsize / 100) * '█' + round((100 - percent) * bsize / 100) * '-' + '|'
    bar += ' ' * (len('100') - len(str(int(percent))))
    print(f'{bar} {percent:.2f}%', end='\r')

def print_centre_hashed(string,size=100):
    strMaxSize = size - 8 # -> ### text ###
    for i in range(len(string) // strMaxSize + 1):
        endIndex = strMaxSize
        lastSpace = -1
        if len(string) > strMaxSize:
            lastSpace = string[:strMaxSize].rindex(' ')
            if lastSpace == -1:
                endIndex = len(string)
            else:
                endIndex = lastSpace + 1
        curr = ' ' + string[0: endIndex] + (' ' if lastSpace == -1 else '')
        print(curr.center(size, '#'))
        if endIndex != len(string):
            string = string[endIndex:]
