function print_output_xls(fname,sname,Bsave,Qsave,Lsave)
%print%
N=size(Qsave,2);
names_V{1}='PC1(-1)';
names_V{2}='PC2(-1)';
names_V{3}='PC3(-1)';
names_V{4}='PC4(-1)';
names_V{5}='Constant';
names_H{1}='PC1';
names_H{2}='PC2';
names_H{3}='PC3';
names_H{4}='PC4';
xlswrite(fname,{'P-Dynamics'},sname,'D1');
xlswrite(fname,names_V,sname,'D3');
xlswrite(fname,names_H',sname,'C4');

xlswrite(fname,{'Q-Dynamics'},sname,'D8');
xlswrite(fname,names_V,sname,'D10');
xlswrite(fname,names_H',sname,'C11');

if ~isempty(Lsave)
xlswrite(fname,{'Risk-Prices'},sname,'D15');
xlswrite(fname,names_V,sname,'D17');
xlswrite(fname,names_H',sname,'C18');
end

xlswrite(fname,{'Max Eig for P'},sname,'D22');
xlswrite(fname,{'Max Eig for Q'},sname,'D23');

%write numbers
%[1] VAR Coef
tmp1=get_output_s(Bsave);
xlswrite(fname,tmp1,sname,'D4');
tmp1=squeeze(median(Bsave));
ee=max(abs(eig(tmp1(:,1:N))));
%[2] Q-dyn
for j=1:size(Qsave,1)
    tmp=squeeze(Qsave(j,:,:));
    tmp=[tmp(:,1:N)+eye(N) tmp(:,end)];
    Qsave(j,:,:)=tmp;
end
tmp1=get_output_s(Qsave);
xlswrite(fname,tmp1,sname,'D11');
tmp1=squeeze(median(Qsave));
ee1=max(abs(eig(tmp1(:,1:N))));
if ~isempty(Lsave)
 tmp1=get_output_s(Lsave);
xlswrite(fname,tmp1,sname,'D18');
end

xlswrite(fname,ee,sname,'E22');
xlswrite(fname,ee1,sname,'E23');