function [Ysave,Mb]=getbootsamples_wild(bols,Y,X,M,L,data,REPS)
%VAR estimates with bootstrap bias correction

N=cols(Y);
T=rows(Y);
rr = 1-2*(rand(T,1)>0.5);
resid=Y-X*bols;
resb = (resid.*(rr*ones(1,N)));
Mb = (M.*(rr*ones(1,1)));
%starting values
start=data(1:L,:);
%bootstrap sample
Ysave=zeros(T+L,N,REPS);
for r=1:REPS
    
 
    
    Yb=zeros(T+L,N);
    Yb(1:L,:)=start;
    for t=L+1:T+L
    Xb=ones(1,N*L+1);
    jj=1;
    for j=1:L
        Xb(:,jj:jj+N-1)=Yb(t-j,:);
        jj=jj+N;
    end
    Yb(t,:)=Xb*bols+resb(t-L,:);
    end
    
    
    Ysave(:,:,r)=Yb;
end
