function [para] = convert_ind3v(lamQ,rQ,sig_P)
% [para] = convert_ind2v(lamQ,rQ,sig_P) converts JSZ's inidividual parameters
% into a vector.
%
% INPUT:    lamQ: diagonal mean reversion matrix
%           rQ: scalar, expectation of long term short rate under Q
%           sig_P: cholesky decomposition of covariance matrix
% Last updated 6/15/2010
tmp=[lamQ(1)-1;lamQ(2)-lamQ(1);lamQ(3)-lamQ(2)];
para = [tmp;rQ;ltvec(sig_P)];