function [H1,H2]=graph_decomp_1(z,initial_date,ZZ)
%function []=graph_decomp(z,varlist,initial_period,freq)

% Copyright (C) 2010-2011 Dynare Team
%
% This file is part of Dynare.
%
% Dynare is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% Dynare is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with Dynare.  If not, see <http://www.gnu.org/licenses/>.

% number of components equals number of shocks + 1 (initial conditions)
comp_nbr = size(z,2);

gend = size(z,1);
freq = initial_date.freq;
initial_period = initial_date.period + initial_date.subperiod/freq;
x = initial_period-1/freq:(1/freq):initial_period+(gend-1)/freq;
    z1 = z;

    xmin = x(1);
    xmax = x(end);
    ix = z1 > 0;
    ymax = max(sum(z1.*ix));
    ix = z1 < 0;
    ymin = min(sum(z1.*ix));
   
%     ax=axes('Position',[0.1 0.1 0.8 0.8]);
%     axis(ax,[xmin xmax ymin ymax]);
   H2= plot(x(2:end),ZZ,'r','LineWidth',0.5);
hold on
    for i=1:gend
        yp = 0;
        ym = 0;
        for k = 1:comp_nbr 
            zz = z1(i,k);
            if zz > 0
                H1=fill([x(i) x(i) x(i+1) x(i+1)],[yp yp+zz yp+zz yp],k);
                yp = yp+zz;
            else
                H1=fill([x(i) x(i) x(i+1) x(i+1)],[ym ym+zz ym+zz ym],k);
                ym = ym+zz;
            end
            hold on;
        end
    end
    
    hold off;
    axis tight

%     axes('Position',[0.75 0.1 0.2 0.8]);
%     axis([0 1 0 1]);
%     axis off;
%     hold on;
%     y1 = 0;
%     height = 1/comp_nbr;
%     labels = [shock_names;{'Initial values'}];
%     
% %     for j=1:comp_nbr
% %         fill([0 0 0.2 0.2],[y1 y1+0.7*height y1+0.7*height y1],j);
% %         hold on
% %         text(0.3,y1+0.3*height,labels(j,:),'Interpreter','none');
% %         hold on
% %         y1 = y1 + height;
% %     end
%     hold off
%hold on