(* ::Package:: *)

%% Code to run IV SVAR for baseline events
% Hambur and Haque (2023)
clear
close all
addpath(genpath('Code/IV_SVAR'))                       % set path (needs to be modified)
outputs = "/Outputs/VAR outputs/VAR_baseline";    % set path and file name for output (needs to be modified)
month_data _start _instr = "2002-09-30";            % exclude missing yearr
month_data _start = "1994-01-31";                  % exclude missing yearr
month_data _end = "2019-12-31";                    % End at end of shockc


modelSpec.nLags                 =12;              % VAR lags
modelSpec.nHorizons             =48;              % max horizon for IRFs
modelSpec.cLevel                =[68 90];         % size of error bands
modelSpec.bootSize              =1000;            % size of bootstrap sample for error bands


output_vars _m = {'unemployment', 'mortgage_spread', 'cash_rate', 'aus_hp', 'dwelling_approvals', 'retail_sales', 'pc21', 'pc22', 'm_ 120', 'twi' };

shocks = {'exp_pc1', 'exp_pc2', 'tp_dir _pc1'};
% VAR data
opts = detectImportOptions('/Input data/VAR data/var_data_m.csv');             % path for the VAR data (needs to be modified)

var_data = readtable('/Input data/VAR data/var_data_m.csv',opts);              % path for the VAR data (needs to be modified)
var_data= var_data(:,2:size(var_data,2));
var_table = table2timetable(var_data);

% Data for PC
opts = detectImportOptions('/Input data/VAR data/Full_hist_month.csv');        % path for yield curve data (needs to be modified)
opts = setvaropts(opts,{'Date'},'InputFormat','dd/MM/uuuu'); 
pc_data = readtable('/Input data/VAR data/Full_hist_month.csv',opts);          % path for yield curve data (needs to be modified)
pc_input = standardise(table2array(pc_data(:,2:end)));
[pc2,W2]=extract(pc_input,2);
pc2(:,2)=-pc2(:,2);
W2(2,:)=-W2(2,:);
pc_table = [pc_data(:,1), pc_data(:,42),array2table(pc2) ];
pc_table= table2timetable(pc_table);

% Shock data
opts = detectImportOptions('/Input data/VAR data/pc_yield_baseline.csv');     % path for the shocks (needs to be modified)
opts = setvaropts(opts,{'dates'},'InputFormat','dd/MM/uuuu'); 
shock_data = readtable('/Input data/VAR data/pc_yield_baseline.csv',opts);    % path for the shocks (needs to be modified)
shock_table = table2timetable(shock_data);

shock_table.dates= eomdate(shock_table.dates);

data_table = synchronize(var_table, pc_table, shock_table);
% Bring together
data_table _m = data_table(:, ismember(data_table.Properties.VariableNames, [output_vars _m shocks]));
data_table _m = data_table _m(timerange(month_data _start,month_data _end),:);
data_table _m{:,:}(isnan(data_table _m{:,:}))=0;


%%-2-PSVAR --------------------------------------------------------------%
% SEt up data structure for program
var_table _m=data_table _m(:,ismember(data_table _m.Properties.VariableNames, output_vars _m ));
shock_table _m=data_table _m(timerange(month_data _start _instr,month_data _end),ismember(data_table _m.Properties.VariableNames, shocks ));
dataStructure.data        = data_table _m.Variables;
dataStructure.dates       = data_table _m.date;
dataStructure.varname     = data_table _m.Properties.VariableNames;
dataStructure.varLongName = data_table _m.Properties.VariableNames;

IV.data        = shock_table _m.Variables;
IV.dates       = shock_table _m.date;
IV.labels     = shock_table _m.Properties.VariableNames;
IV.description = shock_table _m.Properties.VariableNames;
% Choice of VAR. Proxy is PSVAR
modelSpec.identification        ='PSVAR';
% VAR varaibles
psvarSet                        ={'unemployment'; 'twi'; 'aus_hp'; 'retail_sales'; 'dwelling_approvals'; 'mortgage_spread'; 'pc21'; 'pc22'};
[~,dataSelection]               =ismember(psvarSet,dataStructure.varname);

% Something to store F Stata
fstats = zeros(3,2);
robfstats = zeros(3,2);
Ls =zeros(3,2);

%% Run Var
% Looping over the different shocks and PC as to which they are instrumenting for
for i = 11:13
    modelSpec.selectedInstrument=dataStructure.varname(i);
    for q = 9:10
         modelSpec.dataSelection         =dataSelection;

        shockVar                        =dataStructure.varname(q);

% declare shock variable and shock size
        modelSpec.shockVar              =ismember(psvarSet,shockVar);
        modelSpec.shockSize             =1*double(ismember(psvarSet,shockVar));

% compute responses
        irfSVARIV_ 1                     = computeIRFs_boot _cr _ 10(dataStructure,modelSpec, IV,W2);
        
          % SAVE basic OUTPUT
        runid =outputs + 'IRFs_' +string(modelSpec.selectedInstrument) +'_' + q ; 
        save(runid,...
    'modelSpec', 'irfSVARIV_ 1', 'dataStructure', 'W2')


        % SAVE charting OUTPUT
         runid =outputs + 'IRFsg_' +string(modelSpec.selectedInstrument) +'_' + q + '.png' ; 

         irfSVARIV_ 1.irfs = [irfSVARIV_ 1.irfs; ([irfSVARIV_ 1.irfs(end-1,:); irfSVARIV_ 1.irfs(end,:)]'*W2(:,end))'];
         irfSVARIV_ 1.irfs = [irfSVARIV_ 1.irfs; ([irfSVARIV_ 1.irfs(end-2,:); irfSVARIV_ 1.irfs(end-1,:)]'*W2(:,2))'];
         
         irfs_temp = zeros(size(irfSVARIV_ 1.irfs_u,1)+2,size(irfSVARIV_ 1.irfs_u,2), size(irfSVARIV_ 1.irfs_u,3));
         irfs_temp(1:size(irfSVARIV_ 1.irfs_u,1), :, :) = irfSVARIV_ 1.irfs_u;
          irfs_temp(size(irfSVARIV_ 1.irfs_u,1)+1,: , 1) = ([irfSVARIV_ 1.irfs_u(end-1,:,1); irfSVARIV_ 1.irfs_u(end,:,1)]'*W2(:,end))';        
          irfs_temp(size(irfSVARIV_ 1.irfs_u,1)+2, :, 1) = ([irfSVARIV_ 1.irfs_u(end-1,:,1); irfSVARIV_ 1.irfs_u(end,:,1)]'*W2(:,2))';        
          irfs_temp(size(irfSVARIV_ 1.irfs_u,1)+1,:, 2) = ([irfSVARIV_ 1.irfs_u(end-1,:,2); irfSVARIV_ 1.irfs_u(end,:,2)]'*W2(:,end))';        
          irfs_temp(size(irfSVARIV_ 1.irfs_u,1)+2, :, 2) = ([irfSVARIV_ 1.irfs_u(end-1,:,2); irfSVARIV_ 1.irfs_u(end,:,2)]'*W2(:,2))';        
          irfSVARIV_ 1.irfs_u=irfs_temp;
                   
          
         irfs_temp = zeros(size(irfSVARIV_ 1.irfs_l,1)+2,size(irfSVARIV_ 1.irfs_l,2), size(irfSVARIV_ 1.irfs_l,3));
         irfs_temp(1:size(irfSVARIV_ 1.irfs_l,1), :, :) = irfSVARIV_ 1.irfs_l;
          irfs_temp(size(irfSVARIV_ 1.irfs_l,1)+1,: , 1) = ([irfSVARIV_ 1.irfs_l(end-1,:,1); irfSVARIV_ 1.irfs_l(end,:,1)]'*W2(:,end))';        
          irfs_temp(size(irfSVARIV_ 1.irfs_l,1)+2, :, 1) = ([irfSVARIV_ 1.irfs_l(end-1,:,1); irfSVARIV_ 1.irfs_l(end,:,1)]'*W2(:,2))';        
          irfs_temp(size(irfSVARIV_ 1.irfs_l,1)+1,:, 2) = ([irfSVARIV_ 1.irfs_l(end-1,:,2); irfSVARIV_ 1.irfs_l(end,:,2)]'*W2(:,end))';        
          irfs_temp(size(irfSVARIV_ 1.irfs_l,1)+2, :, 2) = ([irfSVARIV_ 1.irfs_l(end-1,:,2); irfSVARIV_ 1.irfs_l(end,:,2)]'*W2(:,2))';        
          irfSVARIV_ 1.irfs_l=irfs_temp;
                   

        
        %-plot irfs---------------------------------------------------------------%
        Ccolor  =[ 1 .6 .2]; 
        GKcolor =[.0 .0 .4]; 
        Scolor  =[ 1 .0 .0];    bandFillColor1 =[.85 .85 .85];  bandFillColor2 =[.7 .7 .7]; 

        % plot labels
        varname                 =dataStructure.varLongName; 


        figure; 
        plotColumns =3; pln=1; 
        nHorizon    =modelSpec.nHorizons; 
        n           =length(psvarSet)+2;                               % added for 10 year year rate and cash rate
        modelSpec.dataSelection=[modelSpec.dataSelection; 8; 3];       % added for 10 year year rate and cash rate

        for j=1:n

            subplot(ceil(n/plotColumns),plotColumns,pln)

            hold on

            % bands 90
            fill([0:1:nHorizon, fliplr(0:1:nHorizon)],...
                [squeeze(irfSVARIV_ 1.irfs_u(j,:,2)) fliplr(squeeze(irfSVARIV_ 1.irfs_l(j,:,2)))],...
                bandFillColor1,'EdgeColor','none');

            % bands 68
            fill([0:1:nHorizon, fliplr(0:1:nHorizon)],...
                [squeeze(irfSVARIV_ 1.irfs_u(j,:,1)) fliplr(squeeze(irfSVARIV_ 1.irfs_l(j,:,1)))],...
                bandFillColor2,'EdgeColor','none');


            % zero line
            plot(0:nHorizon,zeros(size(0:nHorizon)),'k')    
            hold on

            % irfs 
            plot(0:nHorizon,irfSVARIV_ 1.irfs(j,:),'-.','LineWidth',1.5,'color',GKcolor)

            hold off; axis tight

            grid on; xlim([0 nHorizon]);
            set(gca,'XTick',0:6:nHorizon,'XTickLabel',cellstr(num2str((0:6:nHorizon)')),'layer','top')
            title(varname{modelSpec.dataSelection(j)},'FontSize',9,'FontWeight','normal')

            if j==1

                ylabel('% points','FontSize',9)
            end


            pln=pln+1;
                    dataid = outputs + 'IRFs_' +string(modelSpec.selectedInstrument) +'_' + q + '.xls' ; 

        output_irf = [irfSVARIV_ 1.irfs(j,:); squeeze(irfSVARIV_ 1.irfs_l(j,:,2)); squeeze(irfSVARIV_ 1.irfs_u(j,:,2)); squeeze(irfSVARIV_ 1.irfs_l(j,:,1)); squeeze(irfSVARIV_ 1.irfs_u(j,:,1))];
        output_irf = array2table(output_irf');
        row_labels = {'irfs', 'lower_ 90', 'upper_ 90', 'lower_ 68','upper_ 68'};
        output_irf.Properties.VariableNames=row_labels;
        if j<n-1
            writetable(output_irf,dataid,'Sheet',char(varname{modelSpec.dataSelection(j)})); 
        end
         if j==n
            writetable(output_irf,dataid,'Sheet','Short rate');  
         end
         if j==n-1
            writetable(output_irf,dataid,'Sheet','10 year yield');  
        end
        
        end

        saveas(gcf, runid)


fstats(i-10, q-8) = irfSVARIV_ 1.fstat;
robfstats(i-10, q-8) = irfSVARIV_ 1.robfstat;
Ls(i-10, q-8) = irfSVARIV_ 1.L;
    end
end
fstats_tab= array2table(fstats);
robfstats_tab= array2table(robfstats);
        runid =outputs + 'IRFs_fstats.xls' ; 

 writetable(fstats_tab,runid,'Sheet','F_stat'); 
 writetable(robfstats_tab,runid,'Sheet','robust_F _stat')
