
*https://www.stata.com/support/faqs/programming/system-of-nonlinear-equations/

*Estimates regressions and the UC model to figure out paramteric approach to the marginal buyer method

clear all 


set scheme FZ
use data/intermediate/FZdata_drop1.dta
*use data/intermediate/RhoPhiVersion.dta




preserve
	gen scatterbeta =beta_Q12 if beta_Q12<1&beta_Q12>.5&phi_Q12>-0.5&phi_Q12<1
	gen scatteromega =phi_Q12 if beta_Q12<1&beta_Q12>.5&phi_Q12>-0.5&phi_Q12<1

	sort scatterbeta
	export excel   scatteromega scatterbeta   using "Graphs/raw/Scatter_points.xlsx" ,  replace  firstrow(variables)
restore

qui do code/main_programs.do
qui do code/prepare_reg.do

*histogram beta_Q1  , title("Subjective discount factor inferred from WTP with DP 20%") xtitle("Subjective discount factor, {&beta} ") frac name(beta_uni_hist)
*graph export output/fig_beta_uni_hist.pdf, as(pdf) replace name(beta_uni_hist)


local bvar="ln_wtp1_ar"
local tvar="ln_wtp2_ar"
local trim=5

local fullX="startRateLow $charact1 $pref $belief $balsheet0 "
local medX="owner IVS_relcalc_eq     IVS_relinc age   "
local smallX="IVS_relcalc_eq     IVS_relinc  age "

*local medX="startRateLow  renter age i.ls_cat i.eq_cat  "
*local smallX="startRateLow  renter age i.ls_cat i.eq_cat   IVS_relcalc_eq  "
*local smallX="IVS_relcalc_eq owner "
*local smallX="owner c.IVS_relcalc_eq#i.owner"



trim_level `bvar' `tvar' `trim'
remove_zeros_multi `bvar'_T`trim' `tvar'_T`trim'

forvalues t = 1(1)5{
di `t'
preserve
	trimmean ln_wtp1_ar, p(`t') gen(trimm`t'_wtp1)
	trimmean ln_wtp2_ar, p(`t') gen(trimm`t'_wtp2)
	trimmean hypo_q2_q1_logchg, p(`t') gen(trimm`t'_chwtp)
	keep if trimm`t'_wtp1==1 &trimm`t'_wtp2==1 &trimm`t'_chwtp==1
	
	
	
	count
	qui margchangeBS ln_wtp1_ar ln_wtp2_ar
	return list
	restore
}



* The trimmean function seems to select randomly among ties so I add
* noise to break ties and make it reproducible 
set seed 3344
gen tiebreaker = runiform(0, 0.000001)
replace ln_wtp1_ar=ln_wtp1_ar+tiebreaker
replace ln_wtp2_ar=ln_wtp2_ar+tiebreaker
replace  hypo_q2_q1_logchg=hypo_q2_q1_logchg+tiebreaker

trimmean ln_wtp1_ar, p(4) gen(trim1_wtp1)
trimmean ln_wtp2_ar, p(4) gen(trim1_wtp2)

trimmean hypo_q2_q1_logchg, p(4) gen(trim1_chwtp)

replace ln_wtp1_ar=ln_wtp1_ar-tiebreaker
replace ln_wtp2_ar=ln_wtp2_ar-tiebreaker
replace  hypo_q2_q1_logchg=hypo_q2_q1_logchg-tiebreaker


count

keep if trim1_wtp1==1 &trim1_wtp2==1 &trim1_chwtp==1

count

*drop if missing(`bvar'_T`trim')
*drop if missing(`bvar'_T`trim'_Ex0and)

set graphics on

generate housingdebtstatus =0 if house_debt<= liquid_savings & owner==1
replace  housingdebtstatus = 1 if house_debt> liquid_savings & owner==1
replace housingdebtstatus=2 if renter==1


* FZ style regressions and fitted values

gen calc_equity=equity_value*1000+liquid_savings
gen bind=0
replace bind=1 if calc_equity<0.2*homevalue

gen lcalc_equity=log(calc_equity)

gen relcalc_eq=calc_equity/homevalue
gen ln_relcalc_eq=log(relcalc_eq)
gen IVS_relcalc_eq=asinh(100*relcalc_eq)
*x100 to get things nonlinar aka loggy
gen IVS_calc_eq=asinh(calc_eq)

gen pos_eq=0
replace pos_eq=1 if calc_equity>0
	
gen IVS_inc=asinh(inc_cont)
gen relinc=(inc_cont/homevalue)
gen IVS_relinc=asinh(100*inc_cont/homevalue)
*x100 to get things nonlinar aka loggy


 label variable ln_wtp1_ar "WTP 1"
 label variable ln_wtp2_ar "WTP 2"
 label variable hypo_q2_q1_logchg "$\Delta $ WTP"
 
 replace age=age/10 
 
count


local fullX="startRateLow $charact1 $pref $belief $balsheet0 "
local medX="owner IVS_relcalc_eq     IVS_relinc age   "
local smallX="IVS_relcalc_eq     IVS_relinc  age "


qui reg ln_wtp1_ar `medX'
estimates store WTP1medX

qui reg ln_wtp2_ar `medX'
estimates store WTP2medX

qui reg hypo_q2_q1_logchg `medX'
estimates store WTPchmedX


qui reg ln_wtp1_ar `smallX'
estimates store WTP1smallX

qui reg ln_wtp2_ar `smallX'
estimates store WTP2smallX

qui reg hypo_q2_q1_logchg `smallX'
estimates store WTPchsmallX

esttab  WTPchmedX WTPchsmallX, stats( r2 r2_a)


esttab WTP1medX WTP1smallX WTP2medX WTP2smallX WTPchmedX WTPchsmallX, label coeflabels(age "Age (x100)" IVS_relinc "Income^*" owner "Owns home" IVS_relcalc_eq "Available equity^*")  scalars("rmse RMSE" "ar2 Adj R2")  r2  b(2)   se star(* 0.10 ** 0.05 *** 0.01)  

esttab  WTP1medX WTP1smallX WTP2medX WTP2smallX WTPchmedX WTPchsmallX using  output/Table4_Parameters.tex , label coeflabels(age "Age (x100)" IVS_relinc "Income" owner "Owns home" IVS_relcalc_eq "Available equity")    scalars("r2_a Adjusted $ R^2 $" "rmse RMSE" )    b(2)   se star(* 0.10 ** 0.05 *** 0.01)  style(tex) booktabs substitute(\_ _) replace nonumbers addnotes("Available equity and income are relative to home values, and transformed with inverse hyperbolic sine" "Age coefficient is multiplied by 10, i.e. the effect of an extra 10 years")

*reg3 (ln_wtp1_ar `medX') (ln_wtp2_ar `medX'), sure
*estimates store sys_wOwner  
*matrix covwOwner=e(Sigma)

replace age=age*10
	





capture program drop runregs

program  runregs
	args end LHS1 LHS2 RHS
	
	qui reg `LHS1' `RHS'
	predict l_`end'_fit
	eststo l_`end'
	qui 	press `LHS1' `RHS' ,name(l`end')
	scalar PRESS_l`end'=r(press)
	
	estimates restore l_`end'
	scalar TSS= e(rss) + e(mss) 
	scalar PR2lvl =(TSS-PRESS_l`end')/TSS
	scalar R2lvl =e(r2)
	*estadd scalar Prmse =(PRESS_l`end'/e(N))^0.5
	
	
	 reg `LHS2' `RHS'
	predict dl_`end'_fit
	eststo dl_`end'
	qui	press `LHS2' `RHS' ,name(dl`end')
	scalar PRESS_dl`end'=r(press)
	
	estimates restore dl_`end'
	scalar TSS= e(rss) + e(mss) 
	estadd scalar PR2 =(TSS-PRESS_dl`end')/TSS
	estadd scalar Prmse =(PRESS_dl`end'/e(N))^0.5
	
	estadd scalar lvlR2 =R2lvl
	estadd scalar lvlPR2 =PR2lvl
	

	estadd local modeltype="OLS",replace

		generate wtp2_`end'=LWOpred_l`end'+ LWOpred_dl`end'
		 CDFgraph LWOpred_l`end' wtp2_`end' 2 -2 g`end'
	
	margchangeBS LWOpred_l`end' wtp2_`end' 0
	
	scalar Tempavglessmarg =r(FZlessMarg)
	
	estimates restore dl_`end'
	estadd scalar avglessmarg=Tempavglessmarg
	
end

program  runParamregs
	args end LHS1 LHS2 RHS
	
	qui reg `LHS1' `RHS'
	predict phi_fit_`end'
	estimates store phi_reg`end'
	
	qui	press `LHS1' `RHS' ,name(phi_`end')
	replace  LWOpred_phi_`end' = phi_fit_`end' if missing(LWOpred_phi_`end')
		
	qui reg `LHS2' `RHS'
	predict beta_fit_`end'
	estimates store beta_reg`end'
	
	qui	press `LHS2' `RHS' ,name(beta_`end')
	
	generate LWOpred_rho_`end'=(1/LWOpred_beta_`end'-1)
	generate rho_fit_`end'=(1/beta_fit_`end'-1)
	
	genWTP LWOpred_rho_`end' LWOpred_phi_`end' 2 LWOP`end'
	genWTP LWOpred_rho_`end' LWOpred_phi_`end'  1 LWOP`end'
	gen dl_LWOFP_`end'=ln_WTP2_fit_LWOP`end'-ln_WTP1_fit_LWOP`end'
	
	genWTP rho_fit_`end' phi_fit_`end' 2 all`end'
	genWTP rho_fit_`end' phi_fit_`end'  1 all`end'
	gen dl_all_`end'=ln_WTP2_fit_all`end'-ln_WTP1_fit_all`end'
	
	qui margchangeBS ln_WTP1_fit_LWOP`end' ln_WTP2_fit_LWOP`end' 0
	return list

	qui margchangeBS ln_WTP1_fit_all`end' ln_WTP2_fit_all`end' 0
	return list
	
	CDFgraph ln_WTP1_fit_LWOP`end' ln_WTP2_fit_LWOP`end' 8 -7 `end'
	
	
	
	reg  ln_wtp1_ar ln_WTP1_fit_LWOP`end'
	predict proj_WTP1_LWOP_`end'
	scalar tempR2=e(r2)
	eststo FP_`end'
	
	estadd scalar lvlPR2 =tempR2
	
	reg hypo_q2_q1_logchg dl_LWOFP_`end'
	predict proj_dl_LWOFP_`end'
	scalar tempR2=e(r2)
	estimates restore FP_`end'
	estadd scalar PR2 =tempR2
		
	gen WTP2_LOFP_proj_`end'=proj_WTP1_LWOP_`end'+ proj_dl_LWOFP_`end'
	
	reg  ln_wtp1_ar ln_WTP1_fit_all`end'
	predict proj_WTP1_all_`end'
	scalar tempR2=e(r2)
	estimates restore FP_`end'
	estadd scalar lvlR2 =tempR2
		
	reg hypo_q2_q1_logchg dl_all_`end'
	predict proj_dl_all_`end'
	scalar tempR2=e(r2)
	estimates restore FP_`end'
	estadd scalar r2 =tempR2,replace
	estadd local modeltype="UC",replace
	
	gen WTP2_all_proj_`end'=proj_WTP1_all_`end'+ proj_dl_all_`end'
	
	qui margchangeBS proj_WTP1_LWOP_`end' WTP2_LOFP_proj_`end' 0
	return list
	scalar Tempavglessmarg =r(FZlessMarg)
	
	estimates restore FP_`end'
	estadd scalar avglessmarg=Tempavglessmarg

	qui margchangeBS proj_WTP1_all_`end'  WTP2_all_proj_`end' 0
	return list
	
	CDFgraph proj_WTP1_LWOP_`end' WTP2_LOFP_proj_`end' 8 -7 `end'proj
	
end


gen phi_Q12_raw=phi_Q12 
replace phi_Q12=. if phi_Q12>5
do code/set_scalar_params.do
qui runParamregs "FPXs" "phi_Q12" "beta_Q12" "`fullX'"
qui runParamregs "FPXr" "phi_Q12" "beta_Q12" "`medX'"
qui runParamregs "FPXrB" "phi_Q12" "beta_Q12" "`smallX'"



*runregs "FZcons" "ln_wtp1_ar" "hypo_q2_q1_logchg" ""
qui runregs "FZXs" "ln_wtp1_ar" "hypo_q2_q1_logchg" "`fullX'"
*runregs "FZXAp" "ln_wtp1_ar" "hypo_q2_q1_logchg" "startRateLow ln_wtp1_ar $charact1 $pref $belief $balsheet0 "
*runregs "FZAp" "ln_wtp1_ar" "hypo_q2_q1_logchg" "startRateLow ln_wtp1_ar  "
qui runregs "FZXr" "ln_wtp1_ar" "hypo_q2_q1_logchg" "`medX'"
qui runregs "FZXrB" "ln_wtp1_ar" "hypo_q2_q1_logchg" "`smallX'"

estimates restore dl_FZXs
estadd local preddata =" $ X^{Full} $"

estimates restore dl_FZXr
estadd local preddata =" $ X^{Small} $"
estimates restore dl_FZXrB
estadd local preddata =" $ X^{Less} $"

estimates restore FP_FPXrB
estadd local preddata =" $ X^{Less} $"

estimates restore FP_FPXs
estadd local preddata =" $ X^{Full} $"

estimates restore FP_FPXr
estadd local preddata =" $ X^{Small} $"

* margchangeBS ln_wtp1_ar ln_wtp2_ar
 margchangeBS ln_wtp1_arEx0 ln_wtp2_arEx0
scalar Tempavglessmarg =r(FZlessMarg)
local str_data_AlM=string(r(FZlessMarg),"%9.2f")

di `str_data_AlM'

local rowinsert= "avglessmarg \hline  \parbox[c][1.6cm]{4.5cm}{\raggedright Predicted mean $ \Delta(WTP)$ less change in marginal  ("+"`str_data_AlM'"+ " in  data) }"

di "`rowinsert'"
di "`str_data_AlM'"

*esttab   dl_FZXs  dl_FZXr  dl_FZXrB  ///
*esttab   dl_FZXs FP_FPXs dl_FZXr FP_FPXr dl_FZXrB FP_FPXrB   using  output/Table3_FitComparison.tex, drop(*)  scalars("modeltype Model Type" "preddata \parbox[c]{4.5cm}{\raggedright Data used for prediction}" "df_m Number of parameters" "r2   \hline $ \Delta(WTP) : R^{2}_{in\text{-}sample} $" "PR2   $ \Delta(WTP) : R^{2}_{leave \text{-} one\text{-}out\text{-}pred} $ "  "lvlR2  \hline $ WTP_{20\%} : R^2_{in\text{-}sample} $" "lvlPR2  $ WTP_{20\%} : R^2_{leave \text{-} one\text{-}out\text{-}pred}  $" "`rowinsert'" ) sfmt(%03.2f)  booktabs replace nomtitles  substitute(\_ _)  gaps nostar  not title(Prediction regressions \label{tabPredict}) addnotes("Data are the intersection of a 4 percent trim of each dependent variable"  "$ X^{Full}$ is the full set of explanatory variables used in Fuster and Zafar (2021)" "$ X^{Small}$ includes relative income, relative equity, age and tenure status" "$ X^{Less}$ includes relative income, relative equity and age" ) noobs

esttab   dl_FZXs  dl_FZXr  dl_FZXrB  ///
  using  output/Table3_FitComparison.tex, drop(*)  scalars("modeltype Model Type" "preddata \parbox[c]{4.5cm}{\raggedright Data used for prediction}" "df_m Number of parameters" "r2   \hline $ \Delta(WTP) : R^{2}_{in\text{-}sample} $" "PR2   $ \Delta(WTP) : R^{2}_{leave \text{-} one\text{-}out\text{-}pred} $ "  "lvlR2  \hline $ WTP_{20\%} : R^2_{in\text{-}sample} $" "lvlPR2  $ WTP_{20\%} : R^2_{leave \text{-} one\text{-}out\text{-}pred}  $" "avglessmarg \hline  \parbox[c][1.6cm]{4.5cm}{\raggedright Predicted mean $ \Delta(WTP)$ less change in marginal  (`Tempavglessmarg' in  data) }" ) sfmt(%03.2f)  booktabs replace nomtitles  substitute(\_ _)  gaps nostar  not title(Prediction regressions \label{tabPredict}) addnotes("Data are the intersection of a 4 percent trim of each dependent variable"  "$ X^{Full}$ is the full set of explanatory variables used in Fuster and Zafar (2021)" "$ X^{Small}$ includes relative income, relative equity, age and tenure status" "$ X^{Less}$ includes relative income, relative equity and age" ) 

esttab   dl_FZXs FP_FPXs dl_FZXr FP_FPXr dl_FZXrB FP_FPXrB ///
  using  output/Table3_FitComparisonBig.tex, drop(*)  scalars("modeltype Model Type" "preddata \parbox[c]{4.5cm}{\raggedright Data used for prediction}" "df_m Number of parameters" "r2   \hline $ \Delta(WTP) : R^{2}_{in\text{-}sample} $" "PR2   $ \Delta(WTP) : R^{2}_{leave \text{-} one\text{-}out\text{-}pred} $ "  "lvlR2  \hline $ WTP_{20\%} : R^2_{in\text{-}sample} $" "lvlPR2  $ WTP_{20\%} : R^2_{leave \text{-} one\text{-}out\text{-}pred}  $" "avglessmarg \hline  \parbox[c][1.6cm]{4.5cm}{\raggedright Predicted mean $ \Delta(WTP)$ less change in marginal  (`Tempavglessmarg' in  data) }" ) sfmt(%03.2f)  booktabs replace nomtitles  substitute(\_ _)  gaps nostar  not title(Prediction regressions \label{tabPredict}) addnotes("Data are the intersection of a 4 percent trim of each dependent variable"  "$ X^{Full}$ is the full set of explanatory variables used in Fuster and Zafar (2021)" "$ X^{Small}$ includes relative income, relative equity, age and tenure status" "$ X^{Less}$ includes relative income, relative equity and age" ) noobs

di `str_data_AlM'

esttab   dl_FZXs beta_regFPXs l_FZXs  phi_regFPXs    using  output/Appendix_table.tex, varlabels($var_lab) replace title(Prediction regressions \label{tabPredF}) style(tex)   drop(q38 99* 0.* *missing* *regiongrp *homet 2.risk_av* 3500.ls* 750.nh* 1.credi* 35000.i_cat) addnotes("Region and home type dummies omitted from table") booktabs not star(* 0.10 ** 0.05 *** 0.01)   scalars( "rmse RMSE")  r2  b(2)   
*cells("b(fmt(2) ) ")

*esttab   dl_FZXrB beta_regFPXrB l_FZXrB  phi_regFPXrB    using  output/AppPredComp1.tex, varlabels($var_lab) replace title(Prediction regressions \label{tabPredA}) style(tex)     booktabs not star(* 0.10 ** 0.05 *** 0.01)   scalars( "rmse RMSE")  r2  b(2)    mtitles("$ \Delta $ log (WTP)" "$\beta$" "log(WTP)" "$\phi$") substitute(\_ _) coeflabels(_cons "Constant" IVS_relcalc_eq "Relative equity")

*esttab   dl_FZXr beta_regFPXr l_FZXr  phi_regFPXr    using  output/ResPredComp1.tex, varlabels($var_lab) replace title(Prediction regressions \label{tabPredR}) style(tex)    booktabs not star(* 0.10 ** 0.05 *** 0.01)   scalars( "rmse RMSE")  r2  b(2)  
* drop( 99* 0.* )

*"b(fmt(3) nostar) se(fmt(2) par(( )))")
esttab   ,label varlabels($var_lab)

*esttab   dl_FZXr beta_regFPXr l_FZXr  phi_regFPXr    using  output/FullPredComp.tex,label varlabels($var_lab)

*restore

	genWTP rho_Q1 phi_Q1 2 Q1
	genWTP rho_Q1 phi_Q1 1 Q1
	
	gen dlogfit21_Q1=ln_WTP2_fit_Q1-ln_WTP1_fit_Q1
*twoway(scatter hypo_q2_q1_logchg Q1relApp ,msize(small) ) (connected dlogfit21_`suffix' Q1relApp,msymbol(none) sort ) if Q1relApp<2 & startRateLow==0, title("Predicted from Q1 rho vs actual dlog(WTP)") name(dlWTP_`suffix')  

twoway(scatter hypo_q2_q1_logchg Q1relApp ,msize(small) ) (connected dlogfit21_`suffix' Q1relApp if startRateLow==1 ,msymbol(none) sort ) if Q1relApp<8 &  !missing(ln_wtp1_ar_T5_Ex0and) , title("Predicted from Q1 rho vs actual dlog(WTP)") name(dlWTP_`suffix')  




addplot dlWTP_:, ytitle("Change in log(WTP)") title("Predicted and actual change in WTP against level of WTP" ) xtitle("WTP with 20% down payment relative to home value") legend(off)
graph export output/fig_dlWTP_.pdf, as(pdf) replace name(dlWTP_)

addplot dlWTP_:,text( 1.2 0.8 "Predictions from user cost model", color(`.__SCHEME.color.p2'))
gen censoredlnWTP1=min(0,ln_wtp1_ar) 

reg hypo_q2_q1_logchg censoredlnWTP1
estimates store uni_censor
reg hypo_q2_q1_logchg dlogfit21_Q1 if !missing(ln_wtp1_ar_T5_Ex0and)
estimates store uni_UC
reg hypo_q2_q1_logchg ln_wtp1_ar if !missing(ln_wtp1_ar_T5_Ex0and) 
estimates store uni_OLS


*esttab uni_UC uni_OLS using  output/uni_regs.tex, r2  se replace booktabs sfmt(%03.2f) title(User cost vs OLS in-sample \label{tabUni}) addnotes("Data are trimmed at 5 percent" "WTPs equal to appraisal in both down payment scenarios are excluded") mtitles("User cost" "OLS")   coeflabels(_cons "Constant" dlogfit21_Q1 "Modelled log(ch(WTP))" ln_wtp1_ar "log(WTPDP20/Appraisal)") scalars( "rmse RMSE") 

 
*keep if trim1_wtp1==1 &trim1_wtp2==1 &trim1_chwtp==1

*Contour plots
	
	qui do code/contour_plots.do
	
	twoway (contour WTP1_fit_contour   beta_contour phi_contour , levels(15) zlabel(#5) xtitle("") ztitle("WTP/Appraisal at DP20"))	, name(level)
	addplot level:(scatter beta_Q12 phi_Q12 if beta_Q12<1&beta_Q12>.5&phi_Q12>-0.5&phi_Q12<1,msize(tiny)  xtitle("{&omega}")  ytitle("{&beta}") legend(off) title("WTP at DP20 as function of {&beta} and {&omega} ") subtitle("Scatter plot is inferred {&beta} and {&omega} in the data ") ) 
	

		
	*restore
	*twoway__contour_gen ln_wtp1_ar_T5_MidW   age  age, cuts(-2 -1 0 1)
	
	*gen WTP1near1=WTP1_fit_contour if WTP1_fit_contour<1.05 & WTP1_fit_contour>.95
	gen WTP1near1=WTP1_fit_contour if WTP1_fit_contour<1.015 & WTP1_fit_contour>.985
	gen WTP2near2=WTP2_fit_contour if WTP2_fit_contour<1.015 & WTP2_fit_contour>.985
	
	*addplot level:(scatter beta_Q12 phi_Q12 if  !missing(WTP1near1) &beta_Q12<1&beta_Q12>.5&phi_Q12>-0.5&phi_Q12<1)
	*addplot level:(connected beta_contour phi_contour if  !missing(WTP1near1),sort msymbol(none) )
generate WTP1_fit_contour_goabove=WTP1_fit_contour if WTP1_fit_contour<1 & WTP2_fit_contour>=1
	
	*addplot level:(scatter beta_Q12 phi_Q12 if !missing(WTP1_fit_contour_goabove) & beta_Q12<1&beta_Q12>.5&phi_Q12>-0.5&phi_Q12<1,msize(small))
	
twoway	(scatter beta_contour phi_contour if !missing(WTP1_fit_contour_goabove) & beta_Q12<1&beta_Q12>.5&phi_Q12>-0.5&phi_Q12<1,msize(small))
	
		twoway (contour WTP2_fit_contour   beta_contour phi_contour , levels(15) zlabel(#5) xtitle("") ztitle("WTP at DP5/Appraisal"))	, name(level2)
	addplot level2:(scatter beta_Q12 phi_Q12 if beta_Q12<1&beta_Q12>.5&phi_Q12>-0.5&phi_Q12<1,msize(tiny)  xtitle("{&phi}")  ytitle("{&beta}") legend(off) title("Modelled   WTP at DP5 as function of {&beta} and {&phi} ") subtitle("Scatter plot is inferred {&beta} and {&phi} in the data ") ) 

		addplot level2:(connected beta_contour phi_contour if  !missing(WTP1near1),sort msymbol(none) )
		
	
	
	
	
	
generate	dlog_go_above= 1 if ln_wtp1_appr_ratio<0 & ln_wtp2_appr_ratio >=0
twoway (scatter beta_Q12 phi_Q12 if !missing(dlog_go_above) & beta_Q12<1&beta_Q12>.5&phi_Q12>-0.5&phi_Q12<1,msize(small))
*addplot level:(scatter beta_Q12 phi_Q12 if !missing(dlog_go_above) & beta_Q12<1&beta_Q12>.5&phi_Q12>-0.5&phi_Q12<1,msize(small))
	
	
	generate dl_fit_contour=log(WTP2_fit_contour)-log(WTP1_fit_contour)
	
	twoway (contour dl_fit_contour   beta_contour phi_contour , levels(15) zlabel(#5) xtitle("") ztitle("Modelled {&Delta}Ln(WTP) for loosening"))
	
	
	twoway (connected beta_contour phi_contour if  !missing(WTP2near2),sort msymbol(none) )
	
	
	twoway (connected   beta_contour dlogfit21_contour,sort msymbol(none)) ,  title("Modelled {&Delta}  log(WTP) as function of {&beta}")  ytitle({&beta}) xtitle(Modelled  {&Delta} log(WTP))	name(connbeta)
	
	
	graph combine  connbeta level,cols(2) name(countour2plot) ysize(5.5)  xsize(7.5)


twoway (connected   beta_contour dlogfit21_contour,sort msymbol(none))
	
	
	histogram phi_Q12 if   phi_Q12<2.1 &phi_Q12>-2.1 , normal kdensity name(phi_hist) title("{&omega} inferred from WTP1 & WTP2") xtitle("")
		histogram LWOpred_phi_FPXs, normal kdensity name(phi_fit_histD)  title("{&omega} inferred from WTP1 & WTP2 projected on X") xtitle("")

	
	histogram beta_Q12  , normal kdensity title("{&beta} inferred from WTP1 & WTP2") xtitle("") name(beta_hist)
	histogram LWOpred_beta_FPXs, normal kdensity title("{&beta} inferred from WTP1 & WTP2 projected on X") xtitle("") name(beta_fit_histD)

	graph combine phi_hist phi_fit_histD, col(1) xcommon name(phi_hist_com) 	title(Distribution of rental penalty factor ({&omega}) estimates) 
	graph combine beta_hist beta_fit_histD, col(1) xcommon  title(Distribution of discount factor ({&beta}) estimates)  name(beta_hist_all) 
	
		foreach g in   {
	
	addplot `g':, title( "Demand curves from leave-one-out predictions" ) text( -0.8 0.5 "20% down payment", color(`.__SCHEME.color.p2')) text( -0.2 0.8 "5% down payment", color(`.__SCHEME.color.p1')) legend(off)
	
	addplot `g'diff:, title("Change in predicted demand curves" ) legend(off)
	*graph display `g'
	
	
}
	
	
	
	twoway__histogram_gen phi_Q12 if   phi_Q12<2.1 &phi_Q12>-2.1  ,generate(density_phi_Q12 bin_LWOpred_phi_FPXs2, replace )
	twoway__histogram_gen LWOpred_beta_FPXs    ,generate(density_LWOpred_phi_FPXs bin_LWOpred_phi_FPXs, replace )
	
	twoway__histogram_gen beta_Q12 if   phi_Q12<2.1 &phi_Q12>-2.1  ,generate(density_beta_Q12 bin_LWOpred_beta_FPXs2, replace )
	twoway__histogram_gen LWOpred_beta_FPXs    , generate(density_LWOpred_beta_FPXs bin_LWOpred_beta_FPXs, replace )
	
	
	export excel  density* bin_* using "Graphs/raw/histograms.xlsx" ,  replace  firstrow(variables)
	

	
	graph combine FPXrproj FPXrprojdiff, xcommon cols(1) ysize(7.87) xsize(5.9) title(Market Model: Parsimonious User Cost  ) name(FPXrproj_demand)
	graph combine FPXsproj FPXsprojdiff, xcommon cols(1) ysize(7.87) xsize(5.9) title(Market Model: Full Data User Cost  ) name(FPXsproj_demand)
	graph combine gFZXs gFZXsdiff, xcommon cols(1) ysize(7.87) xsize(5.9) title(Market Model: Full Data OLS  ) name(gFZXs_demand)
	graph combine gFZXr gFZXrdiff, xcommon cols(1) ysize(7.87) xsize(5.9) title(Market Model: Parsimonious Data OLS  ) name(gFZXr_demand)
	
	graph combine gFZXrB gFZXrBdiff, xcommon cols(1) ysize(7.87) xsize(5.9) title(Market Model: Relative assets OLS  ) name(gFZXrB_demand)
	graph combine FPXrBproj FPXrBprojdiff, xcommon cols(1) ysize(7.87) xsize(5.9) title(Market Model: Relative assets User Cost  ) name(gFZXrBproj_demand)

	
	
	set graphics on
foreach g in dlWTP_  countour2plot phi_hist_com  beta_hist_all FPXrproj_demand FPXsproj_demand gFZXs_demand gFZXr_demand gFZXrB_demand gFZXrBproj_demand level {
    
	graph display `g'
	
	graph export output/fig_`g'.pdf, as(pdf) replace name(`g')
}


graph export output/fig_countour2plot.pdf, as(pdf) replace name(countour2plot)

 graph drop _all
 