
*https://www.stata.com/support/faqs/programming/system-of-nonlinear-equations/

*Estimates regressions and the UC model to figure out paramteric approach to the marginal buyer method

clear all 
cd "I:\HES\TomC\FZ_project\"

set scheme FZ
use data/intermediate/FZdata_drop1.dta,clear


qui do code/programsFZ.do
qui do code/prepare_reg.do






local bvar="ln_wtp1_ar"
local tvar="ln_wtp2_ar"
local trim=5

global fullX="startRateLow $charact1 $pref $belief $balsheet0 "
global medX="c.IVS_relcalc_eq  age   IVS_relinc owner  "
global smallX="c.IVS_relcalc_eq  age   IVS_relinc "


global smallXint=" owner c.IVS_relcalc_eq  age   IVS_relinc "


trim_level `bvar' `tvar' `trim'

drop if missing(`bvar'_T`trim')

set graphics on

generate housingdebtstatus =0 if house_debt<= liquid_savings & owner==1
replace  housingdebtstatus = 1 if house_debt> liquid_savings & owner==1
replace housingdebtstatus=2 if renter==1


* FZ style regressions and fitted values
gen age2=age^2
gen age3=age^3



gen calc_equity=equity_value*1000+liquid_savings
gen calc_equity_net=equity_value*1000+liquid_savings-non_house_debt

gen relcalc_eq=calc_equity/homevalue
gen relcalc_eq_net=calc_equity_net/homevalue

gen IVS_relcalc_eq=asinh(relcalc_eq)
gen IVS_relcalc_eq_net=asinh(relcalc_eq_net)


gen IVS_calc_eq=asinh(calc_equity)
gen IVS_inc=asinh(inc_cont)
gen relinc=(inc_cont/homevalue)
gen IVS_relinc=asinh(inc_cont/homevalue)


gen pos_eq=0
replace pos_eq=1 if calc_equity>0

