*Additional regressions to test out the model and port to other areas

clear all
graph drop _all

cd ""
set scheme FZ
*qui do code/programsFZ.do
qui do code/main_programs.do

use data/intermediate/SCE13.dta,clear

trimmean ln_wtp2_ar, p(4) gen(trim1_wtp1)
trimmean ln_wtp2_ar, p(4) gen(trim1_wtp2)
trimmean hypo_q2_q1_logchg, p(4) gen(trim1_ch)


keep if trim1_wtp1==1 &trim1_wtp2==1&trim1_ch==1


*1.  Open the FZ data that has been transformed to have the correct RHS variables:
* IVS_relcalc_eq IVS_relcalc_eq_net  age age2 age3   IVS_relinc owner  

*2. Setup the RHS variables for the regs
global wOwner="c.IVS_relcalc_eq  age   IVS_relinc owner  "
global noOwner="c.IVS_relcalc_eq  age   IVS_relinc   "

gen IVS_relcalc_eq2=IVS_relcalc_eq^2
gen IVS_relinc2=IVS_relinc^2
*global noOwner="c.IVS_relcalc_eq  age   IVS_relinc "


*3. Run the FZ regs and save the results 
reg ln_wtp1_ar $wOwner
estimates store  fit_1_wOwner
reg ln_wtp1_ar $noOwner
estimates store   fit_1_noOwner

reg ln_wtp2_ar $wOwner
estimates store  fit_2_wOwner
reg ln_wtp2_ar $noOwner
estimates store   fit_2_noOwner

reg 	hypo_q2_q1_logchg $wOwner
estimates store  fit_ch_wOwner
reg hypo_q2_q1_logchg $noOwner
estimates store   fit_ch_noOwner


reg3 (ln_wtp1_ar $wOwner) (ln_wtp2_ar $wOwner), sure
estimates store sys_wOwner
matrix covwOwner=e(Sigma)


reg3 (ln_wtp1_ar $noOwner) (ln_wtp2_ar $noOwner), sure
estimates store sys_noOwner
matrix covnoOwner=e(Sigma)

esttab fit_1_wOwner fit_1_noOwner fit_2_wOwner fit_2_noOwner, ar2 scalars(rmse)


*4. For each file:




local counter=0


	*CDFgraph ln_wtp1_ar ln_wtp2_ar 2 -2  XXX
	
	





	
	estimates restore  fit_1_wOwner
predict resid_WTP_1_wOwner,residuals

	estimates restore  fit_2_wOwner
predict resid_WTP_2_wOwner,residuals	

	estimates restore  fit_ch_wOwner
predict resid_WTP_ch_wOwner,residuals	



capture program drop monte_carlo
program monte_carlo, rclass
                args WTP1 WTP2 cov_matrix
           
               * preserve 
                keep  if !missing(`WTP1')| !missing(`WTP2')
                
				capture drop genWTP1 genWTP2 e1 e2
				drawnorm e1 e2, cov(`cov_matrix')
				
				generate genWTP1=`WTP1'+e1
				generate genWTP2=`WTP2'+e2
				
				margchangeBS genWTP1 genWTP2
				return scalar proj_FZchange=r(FZchange)
				return scalar proj_marg_change=r(marg_change)
				return scalar proj_FZlessMarg=r(FZlessMarg)
				
				                
            *    restore

end

matrix zeroCov=(0, 0 \ 0, 0)

 * bootstrap r(proj_marg_change) r(proj_FZchange) r(proj_FZlessMarg), dots(10) nowarn reps(500): monte_carlo ln_wtp1_ar ln_wtp2_ar  covwOwner
 * bootstrap r(proj_marg_change) r(proj_FZchange) r(proj_FZlessMarg), dots(10) nowarn reps(500): monte_carlo ln_wtp1_ar ln_wtp2_ar  zeroCov

  cd data\intermediate\
  
  
  
  *local data_list = "SCE13"
   local data_list = "SWI12 ESP14 AUSW2019 AUSW2017 AUSW2015 AUSW2013 AUSW2011 AUSW2009 AUSW2005 AUSW2003 SCF19 SCF13 SCF04 SCE13"
  
  *local data_list = "SWI12 ESP14  AUS17  AUS13    AUS03 SCF19 SCF13 SCF04 SCE13"
  
foreach file in `data_list'  {

 
  	*foreach file in AUS03 AUS13 AUS17 SCE13 SCF13 SCF19 ESP14 {
	*foreach file in AUS13 AUS17  {
               use "`file'.dta",clear 
  count
  
local counter=`counter'+1

* a. fit values for WTP1 an WTP2 for each set of variables

qui estimates restore  fit_1_wOwner
qui predict WTP_1_wOwner


qui estimates restore   fit_1_noOwner
qui predict WTP_1_noOwner

qui estimates restore  fit_2_wOwner
qui predict WTP_2_wOwner

qui estimates restore   fit_2_noOwner
qui predict WTP_2_noOwner
				
	* b. save market analysis graphs
	
	CDFgraph WTP_1_wOwner WTP_2_wOwner 2 -2  wOwner`file'

*	CDFgraph WTP_1_noOwner WTP_2_noOwner 2 -2  noOwner`file'
	
	*margchangeBS WTP_1_wOwner WTP_2_wOwner 0
	
	 * r(FZchange)
	  *r(FZlessMarg)
	   *r(marg_change)
	   
	   di "`file'"
	*   margchangeBS WTP_1_wOwner WTP_2_wOwner
	 range_bstrap WTP_1_wOwner WTP_2_wOwner 100
	   
	 
	 local reps=cond("`file'"=="SCE13",10000,3000)
	   
	*  local reps=cond("`file'"=="SCE13",5,5)
	   
	  bootstrap r(proj_marg_change) r(proj_FZchange) r(proj_FZlessMarg), dots(10) nowarn reps(`reps'): monte_carlo WTP_1_wOwner WTP_2_wOwner  covwOwner
	* Not THIS ONE    bootstrap r(proj_marg_change) r(proj_FZchange) r(proj_FZlessMarg), dots(10) nowarn reps(100): monte_carlo WTP_1_noOwner WTP_2_noOwner  covnoOwner
	   
	   count 
	   CDFgraph genWTP1 genWTP2 2 -2  RwOwner`file'
	   	   
	   
qui 	   matrix meanmat`file'=e(b)
	qui    matrix cimat`file'=e(ci_normal)
	
	 bootstrap r(proj_marg_change) r(proj_FZchange) r(proj_FZlessMarg), dots(10) nowarn reps(`reps'): monte_carlo WTP_1_noOwner WTP_2_noOwner  covnoOwner
	 
	 qui 	   matrix meanmat`file'noO=e(b)
	qui    matrix cimat`file'noO=e(ci_normal)
	
	* c. save mean and marginal numbers; and confidence intervals
	
	
		  * save "`file'.dta",clear 

        }
		
		
		
*5. Graph/table of the results to compare across space and time




*esttab fit_1_wOwner fit_1_noOwner fit_2_wOwner fit_2_noOwner
 
* CDFgraph WTP_1_noOwner WTP_2_noOwner 2 -2  noOwnertest



*esttab	 smallX_1 smallXint_1  smallX_2 smallXint_2 smallX_D smallXint_D, r2 ar2 se

keep age 
*local data_list = "SWI12 ESP14 AUS2019 AUS2017 AUS2015 AUS2013 AUS2011 AUS2009 AUS2005 AUS2003 SCF19 SCF13 SCF04 SCE13"
*  local data_list = "SWI12 ESP14  AUS17  AUS13    AUS03 SCF19 SCF13 SCF04 SCE13"
*graph drop _all
gen_variables 3

gen rownumber=_n
gen rownames="initialise" if _n==1
local rowcounter=0

*local data_list = "AUS03 AUS13 AUS17   SCF19 ESP14"
*local data_list = "ESP14 AUS17 AUS13 AUS03 SCF19 SCF13 SCF04 SCE13 "

* foreach file in AUS13 AUS17 SCE13 SCF13 SCF19 ESP14  {
foreach file in `data_list'  {

local rowcounter=`rowcounter'+1
	
qui	bstrap2variables "meanmat`file'" "cimat`file'"  rownumber `rowcounter'
		replace rownames="`file'" if rownumber==`rowcounter'
	}
	
	encode rownames, gen(nrownames1)
	gen test1=nrownames1+.1
	
	sencode rownames, gen(nrownames2) gsort(mean2)
	gen test2=nrownames2+.1
	
	sencode rownames, gen(nrownames3) gsort(rownames)
	gen test3=nrownames3+.1

	sencode rownames, gen(nrownames) gsort(rownumber)
*	gen test4=nrownames4+.1
	
*gen	nrownames=nrownames4





			twoway (rcap ll2 ul2 nrownames,horizontal color(gs4) ) (rcap ll1 ul1 nrownames,horizontal color(gs4) )  (scatter nrownames mean1 ,msymbol(d)) (scatter nrownames mean2 ,msymbol(circle)), ///
		ylabel(1/9,valuelabel angle(h)) name(COmp_wOwner)  ylabel(,nogrid) legend(off) ytitle("") xtitle("Log change in WTP") ///
		 text( 6.5 .04 "Change in marginal buyer", color(`.__SCHEME.color.p3')) text( 6.5 .149 "Average change", color(`.__SCHEME.color.p4')) ///
		   text( 3.4 .06  "95% confidence intervals", color(gs4)) ///
		   title("Effects of Looser Credit Constraints: Marginal vs Average ") subtitle("Simulated using estimated model with other survey data") 
		   
		   			twoway (rcap ll2 ul2 nrownames,horizontal color(gs4) ) (rcap ll1 ul1 nrownames,horizontal color(gs4) )  (scatter nrownames mean1 ,msymbol(d)) (scatter nrownames mean2 ,msymbol(circle)), ///
		ylabel(1/9,valuelabel angle(h)) name(pan1tenure)  ylabel(,nogrid) legend(off) ytitle("") xtitle("Log change in WTP") ///
		 text( 6.5 .04 "Change in marginal buyer", color(`.__SCHEME.color.p3'))  ///
		   text( 3.4 .06  "95% confidence intervals", color(gs4)) ///
		   title("Including tenure") fxsize(106)
		   
		   
		twoway (rcap ll3 ul3 nrownames,horizontal) (scatter nrownames mean3 ,msymbol(d)),ylabel(1/9,valuelabel angle(h))		name(COmp_wOwnerDi)	fxsize(45) xline(0,lcolor(gs10)) ylabel(,nogrid) legend(off) xscale(range(0 ))
		
	*	graph combine COmp_wOwner COmp_wOwnerDi
		cd "I:\HES\TomC\FZ_project\output"
graph export COmp_wOwner.pdf, as(pdf) replace name(COmp_wOwner)


addplot RwOwnerSCE13:,title("Simulated stochastic demand curves") legend(off) 
graph combine  RwOwnerSCE13  RwOwnerSCE13diff ,  xcommon cols(1) ysize(8) xsize(6.5)  title( "US Survey of Consumer Expectations in 2013") name(SCE2013_stoch)

addplot wOwnerSCE13:,title("Simulated mean demand curves") legend(off) 
graph combine  wOwnerSCE13  wOwnerSCE13diff ,  xcommon cols(1) ysize(8) xsize(6.5)  title( "US Survey of Consumer Expectations in 2013") name(SCE2013_mean)


addplot wOwnerSCF13:,title("Simulated mean demand curves") legend(off) 
graph combine  wOwnerSCF13  wOwnerSCF13diff ,  xcommon cols(1) ysize(8) xsize(6.5)  title( "US Survey of Consumer Finances in 2013") name(SCF2013_mean)

addplot RwOwnerSCF13:,title("Simulated stochastic demand curves") legend(off) 
graph combine  RwOwnerSCF13  RwOwnerSCF13diff ,  xcommon cols(1) ysize(8) xsize(6.5)  title( "US Survey of Consumer Finances in 2013") name(SCF2013_stoch)


foreach suffix in "SCE2013_stoch" "SCF2013_stoch" "SCF2013_mean"  "SCE2013_mean"  {
	graph export fig_`suffix'.pdf, as(pdf) replace name(`suffix')

}

  save bootresultsAUSTenure.dta, replace
		  
		  
sort rownames

drop if missing(rownames)

outsheet nrownames mean1	ll1	ul1	mean2	ll2	ul2  using "I:\HES\TomC\FZ_project\output\TenureGraphDataW.csv" , comma replace



keep age 
 
gen_variables 3

gen rownumber=_n
gen rownames="initialise" if _n==1
local rowcounter=0

*local data_list = "AUS03 AUS13 AUS17   SCF19 ESP14"
*local data_list = "ESP14 AUS17 AUS13 AUS03 SCF19 SCF13 SCF04 SCE13 "

* foreach file in AUS13 AUS17 SCE13 SCF13 SCF19 ESP14  {
foreach file in `data_list'  {

local rowcounter=`rowcounter'+1
	
qui	bstrap2variables "meanmat`file'noO" "cimat`file'noO"  rownumber `rowcounter'
		replace rownames="`file'" if rownumber==`rowcounter'
	}
	
	encode rownames, gen(nrownames1)
	gen test1=nrownames1
	
	sencode rownames, gen(nrownames2) gsort(mean2)
	gen test2=nrownames2+.1
	
	sencode rownames, gen(nrownames3) gsort(rownames)
	gen test3=nrownames3+.1

	sencode rownames, gen(nrownames) gsort(rownumber)
*	gen test4=nrownames4+.1
	
*gen	nrownames=nrownames4





			twoway (rcap ll2 ul2 nrownames,horizontal color(gs4) ) (rcap ll1 ul1 nrownames,horizontal color(gs4) )  (scatter nrownames mean1 ,msymbol(d)) (scatter nrownames mean2 ,msymbol(circle)), ///AUS
		ylabel(1/9,valuelabel angle(h)) name(COmp_noOwner)  ylabel(,nogrid) legend(off) ytitle("") xtitle("Log change in WTP") ///
		 text( 6.5 .04 "Change in marginal buyer", color(`.__SCHEME.color.p3')) text( 6.5 .149 "Average change", color(`.__SCHEME.color.p4')) ///
		   text( 3.4 .06  "95% confidence intervals", color(gs4)) ///
		   title("Effects of Looser Credit Constraints: Marginal vs Average ") subtitle("Simulated using estimated model with other survey data, no tenure") 
		   
		   
		twoway (rcap ll3 ul3 nrownames,horizontal) (scatter nrownames mean3 ,msymbol(d)),ylabel(1/9,valuelabel angle(h))		name(COmp_noOwnerDi)	fxsize(45) xline(0,lcolor(gs10)) ylabel(,nogrid) legend(off) xscale(range(0 ))
		
	*	graph combine COmp_wOwner COmp_wOwnerDi
		cd ""
graph export COmp_noOwner.pdf, as(pdf) replace name(COmp_noOwner)





		   
		   			twoway (rcap ll2 ul2 nrownames,horizontal color(gs4) ) (rcap ll1 ul1 nrownames,horizontal color(gs4) )  (scatter nrownames mean1 ,msymbol(d)) (scatter nrownames mean2 ,msymbol(circle)), ///
		ylabel(none) name(pan2noowner)  ylabel(,nogrid) legend(off) ytitle("") xtitle("Log change in WTP") ///
		text( 6.5 .149 "Average change", color(`.__SCHEME.color.p4')) ///
		   title("Not including tenure ") fxsize(94)
		   
		    graph combine pan1tenure pan2noowner, title("Effects of Looser Credit Constraints: Marginal vs Average ") subtitle("Simulated using estimated model with other survey data") xsize(16) ysize(10) xcommon name(bothGraphs)
		  graph export fig_bothGraphs.pdf, as(pdf) replace name(bothGraphs) 

		  
		  save bootresultsAUSnoOO.dta, replace
		  
		  
sort rownames

drop if missing(rownames)

outsheet nrownames mean1	ll1	ul1	mean2	ll2	ul2  using "\output\noOOGraphDataW.csv" , comma replace


