*Generates results for market subsegments

drop _all 
use data/intermediate/FZdata_drop1.dta
*drops variables but keeps graphs
graph drop _all

qui do code/main_programs.do

local bvar="ln_wtp1_ar"
local tvar="ln_wtp2_ar"
 

*local bvar="ln_WTPhighR_ar"
*local tvar="ln_WTPlowR_ar"

gen_variables 3
local trim=5
*local dropsuffix = "_Ex0"
local dropsuffix = ""
*local dropsuffix = "_Ex0and"

	*trim_level `bvar' `tvar' 5
	trim_level `bvar' `tvar' `trim'

	*remove_zeros_self `bvar'_T5 `tvar'_T5
	
	remove_zeros_multi `bvar'_T`trim' `tvar'_T`trim'
	drop if missing(`bvar'_T`trim'_Ex0and)
	
gen rownumber=_n
gen rownames= "initialise" if _n==1

 xtile quintile_def = homevalue, nq(5)
 xtile quintile_alt = homevalue, nq(5) altdef
xtile quintile = homevalue, nq(5) 

gen S=1 if region=="South"
gen W=1 if region=="West"
gen MidW=1 if region=="Midwest"
gen NE=1 if region=="Northeast"
gen NY=1 if state=="NY"
gen CA=1 if state=="CA"
gen TX=1 if state=="TX"
generate ndet =1  if house_debt<= liquid_savings & owner==1
gen debt = 1 if house_debt> liquid_savings & owner==1
gen mApp=1  if homevalue==150000
gen rent=renter
gen own=owner
gen lInc=1 if incover75==0
gen hInc=1 if incover75==1

gen hApp=1 if homevalue>=160000&homevalue<=200000
gen lApp=1 if homevalue>=100000&homevalue<=140000
*gen owner =1 if renter!=1

gen yng=1 if age <=35
gen mid=1 if age>35 & age <=55
gen old=1 if age>55

gen calc_equity=equity_value*1000+liquid_savings
gen bind=1 if calc_equity<0.2*homevalue
gen nbnd=1 if calc_equity>=0.2*homevalue
gen constrained = 1 if bind==1
replace constrained = 0 if nbnd==1

gen quin1= 1 if  quintile==1
gen quin2= 1 if  quintile==2
gen quin3= 1 if  quintile==3
gen quin4= 1 if  quintile==4
gen quin5= 1 if  quintile==5


gen N1=.
gen N2=.

set graphics off

/*
local rowlocal=0
foreach suffix in "rent" "S" "W" "MidW" "NE" "own" "NY" "CA" "TX" "ndet" "debt" "mApp" "lApp" "hApp" "old" "yng" "mid" "bind" "nbnd"{
	local rowlocal=`rowlocal'+1
	replace rownames= "`suffix'" if _n==`rowlocal'
di 	"`suffix' " `rowlocal'
	replace N1=r(N) if   _n==`rowlocal'
}
*/

local rowlocal=0
foreach suffix in "rent" "own" "yng" "mid" "old"  "NE"  "MidW" "S" "W"  "NY"  "TX" "CA"   "lApp" "mA"  "hApp" "debt" "ndet"  "bind" "nbnd" "lInc" "hInc" "quin1" "quin2" "quin3" "quin4" "quin5" {
	local rowlocal=`rowlocal'+1
	replace rownames= "`suffix'" if _n==`rowlocal'
di 	"`suffix' " `rowlocal'
di rownames[`rowlocal']
di "pause 1 iteration"" `rowlocal'
pause 	
 segment `bvar'_T`trim' `tvar'_T`trim' `suffix' `suffix'

 *TEMPORARY: FIGURE OUT WHY INSIDE THE LOOP and which dropsuffuix : remove_zeros_multi `bvar'_T`trim'_`suffix' `tvar'_T`trim'_`suffix'

	  margchangeBS `bvar'_T`trim'_`suffix'`dropsuffix' `tvar'_T`trim'_`suffix'`dropsuffix' 0

	  return list
	di "pause 2 iteration" `rowlocal'
	pause 
		   range_bstrap `bvar'_T`trim'_`suffix'`dropsuffix' `tvar'_T`trim'_`suffix'`dropsuffix' 2500 0
		
		matrix meanmat=e(b)
		matrix cimat=e(ci_normal)
			di "pause 3 iteration" `rowlocal'
	pause 
		 bstrap2variables meanmat cimat rownumber `rowlocal'
	 	CDFgraph  `bvar'_T`trim'_`suffix'`dropsuffix' `tvar'_T`trim'_`suffix'`dropsuffix' 4  -10 g`suffix'

	sum `bvar'_T`trim'_`suffix'`dropsuffix'
	replace N1=r(N) if   _n==`rowlocal'
	
			*	addplot g`var':, legend(off)
*graph combine  g`var'  g`var'diff,  xcommon cols(1) ysize(7.87) xsize(5.9)  title( "Age < 35") name(CombAge)
	
	
}	
set graphics on

generate segmentname=rownames

* "NY" "CA" "TX" "ndet" "debt" "mApp" "lApp" "hApp"

tostring N1, gen(N1string)
gen N1equal=" (N=" +	N1string + ")"
    replace rownames = "Renter" + N1equal if  segmentname== "rent"
		 replace rownames = "South region" + N1equal if  segmentname== "S"
	 replace rownames = "West region" + N1equal if  segmentname== "W"
	 replace rownames = "Mid-west region" + N1equal if  segmentname== "MidW"
	 replace rownames = "Northeast region" + N1equal if  segmentname== "NE"
	 replace rownames = "Owner-occupier" + N1equal if  segmentname== "own"
	 replace rownames = "New York" + N1equal if  segmentname== "NY"
	 replace rownames = "California" + N1equal if  segmentname== "CA"
	 replace rownames = "Texas" + N1equal if  segmentname== "TX"
	 replace rownames = "Owner w/out debt" + N1equal if  segmentname== "ndet"
	 replace rownames = "Owner with debt" + N1equal if  segmentname== "debt"
	 replace rownames = "Appraisal=150K" + N1equal if  segmentname== "mA"
	 replace rownames = "Appraisal 101-150K" + N1equal if  segmentname== "lApp"
	  replace rownames = "Appraisal 151K-200K" + N1equal if  segmentname== "hApp"
	  replace rownames = "Age {&le} 35" + N1equal if  segmentname== "yng"
	  replace rownames = "Age 35-55" + N1equal if  segmentname== "mid"
	  replace rownames = "Age > 55" + N1equal if  segmentname== "old"
	  replace rownames = "20% DP binding*" + N1equal if  segmentname== "bind"
	   replace rownames = "20% DP not binding*" + N1equal if  segmentname== "nbnd"
	   	   replace rownames = "Income > 75K" + N1equal if  segmentname== "hInc"
		   replace rownames = "Income < 75K" + N1equal if  segmentname== "lInc"
		replace rownames = "Quintile 1" + N1equal if  segmentname== "quin1"
		replace rownames = "Quintile 2" + N1equal if  segmentname== "quin2"
		replace rownames = "Quintile 3" + N1equal if  segmentname== "quin3"
		replace rownames = "Quintile 4" + N1equal if  segmentname== "quin4"
		replace rownames = "Quintile 5" + N1equal if  segmentname== "quin5"
		
	generate supersegment="placeholder" if _n==1
	
	replace supersegment = "Location"  if segmentname=="CA"|segmentname=="TX"|segmentname=="NY"|segmentname=="NE"|segmentname=="W"|segmentname=="MidW"|segmentname=="S"
	replace supersegment = "Demographic"  if segmentname=="yng"|segmentname=="mid"|segmentname=="old"|segmentname=="own"|segmentname=="rent"
	replace supersegment = "Financial"  if segmentname=="ndet"|segmentname=="debt"|segmentname=="bind"|segmentname=="nbnd"|segmentname=="lInc"|segmentname=="hInc" 
	*|segmentname=="mA"|segmentname=="lApp"|segmentname=="hApp"
	replace supersegment = "Quintiles"  if segmentname=="quin1"|segmentname=="quin2"|segmentname=="quin3"|segmentname=="quin4"|segmentname=="quin5"
*sort supersegment

*sencode rownames, gen(nrownames) gsort(mean2)
*gen nrownames2=nrownames+.1

*(rcap ll1 ul1  nrownames,  sort(mean1) color(gs12%80) horizontal) 
gen negrownumber=-rownumber
foreach var in "Location" "Demographic" "Financial" "Quintiles"{
	preserve
	drop if supersegment!= "`var'"
	
	capture drop nrownames
capture drop nrownames2
*encode rownames, gen(nrownames)
sencode rownames, gen(nrownames) gsort(negrownumber)
count
local  num=r(N)
	
	twoway (rcap ll2 ul2  nrownames, color(gs4) horizontal msize(large) ) (rcap ll1 ul1  nrownames, color(gs4) horizontal msize(small) )  (scatter  nrownames mean1, msymbol(d))  (scatter nrownames mean2 , msymbol(d))  if supersegment=="`var'",  ytitle("") name(gcomp`var') legend(off) ylabel(,nogrid) xlabel(,nogrid)   xline(0,lcolor(gs10) )   	ylabel(1/`num', valuelabel angle(h))  title("Change estimates")  fxsize(90) text( 4.3 .18 "Change in marginal buyer", color(`.__SCHEME.color.p3')) text( 3.3 .21 "Average change (FZ)", color(`.__SCHEME.color.p4')) nodraw
	
	
	
	 
		twoway  (rcap ll3 ul3  nrownames,horizontal color(gs4))  (scatter nrownames mean3 , msymbol(d))      if supersegment=="`var'", ylabel(none) ytitle("")  legend(off) xline(0,lcolor(gs10) ) xlabel(,nogrid)  fxsize(45) 		name(gdiff`var')  nodraw title("Difference (avg less marginal)") 	text( 3.7 .11  "95% confidence intervals", color(gs4)) 

		 graph combine gcomp`var' gdiff`var', ycommon   title(Market Segments: `var' variables) name(segment_`var')  note("										Log change in WTP")
		 
		 	graph export output/fig_segment_`var'.pdf, as(pdf) replace name(segment_`var')
			
outsheet  nrownames	mean1	ll1	ul1	mean2	ll2	ul2	mean3	ll3	ul3   using "Graphs/outputTenure`var'.csv" , comma replace 
		restore
}

*addplot segment_Financial:,note("*Down payment constraint defined as binding if liquid savings + home equity < 20% of appraisal value")

addplot gyng: , legend(off)
graph combine  gyng  gyngdiff,  xcommon cols(1) ysize(7.87) xsize(5.9)  title( "Age < 35 (N=184)") name(CombYoung)

addplot gnbnd:, legend(off)
graph combine  gnbnd  gnbnddiff,  xcommon cols(1) ysize(7.87) xsize(5.9)  title( "Non-Bindng DP Constraint (N=516)") name(CombNonBind)

addplot gbind:, legend(off)
graph combine  gbind  gbinddiff,  xcommon cols(1) ysize(7.87) xsize(5.9)  title( "Bindng DP Constraint (N=246)") name(CombBind)

addplot grent:, legend(off)
graph combine  grent grentdiff,  xcommon cols(1) ysize(7.87) xsize(5.9)  title( "Renter") name(CombRent)

addplot gown:, legend(off)
graph combine  gown gowndiff,  xcommon cols(1) ysize(7.87) xsize(5.9)  title( "OO") name(CombOO)

addplot gmA:, legend(off)
graph combine  gmA gmAdiff,  xcommon cols(1) ysize(7.87) xsize(5.9)  title( "Appraisal=150K") name(Comb150)

addplot glApp:, legend(off)
graph combine  glApp glAppdiff,  xcommon cols(1) ysize(7.87) xsize(5.9)  title( "Appraisal 101-150K (N=125)") name(ComblApp)

addplot ghApp:, legend(off)
graph combine  ghApp ghAppdiff,  xcommon cols(1) ysize(7.87) xsize(5.9)  title( "Appraisal 151K-200K ") name(CombhApp)

addplot ghInc:, legend(off)
graph combine  ghInc ghIncdiff,  xcommon cols(1) ysize(7.87) xsize(5.9)  title( "Income>75K ") name(CombhInc)

addplot glInc:, legend(off)
graph combine  glInc glIncdiff,  xcommon cols(1) ysize(7.87) xsize(5.9)  title( "Income<75K ") name(ComblInc)

addplot gndet: , legend(off) 
graph combine  gndet gndetdiff,  xcommon cols(1) ysize(7.87) xsize(5.9)  title( "Owner-occupier with no debt ") name(Combndet)

addplot gyng: , legend(off) yscale(range(-2 2)) ylabel(#5) text( 0.75 0.6 "5% down payment", size(medlarge) color(`.__SCHEME.color.p1'))  text( -0.7 0.5 "20% down payment", size(medlarge) color(`.__SCHEME.color.p2')) 
addplot gndet: , legend(off) yscale(range(-2 2)) ylabel(#5) text( 0.75 0.6 "5% down payment", size(medlarge) color(`.__SCHEME.color.p1'))  text( -0.5 0.5 "20% down payment", size(medlarge) color(`.__SCHEME.color.p2')) 
addplot gyngdiff: , legend(off) yscale(range(0 1.2)) ylabel(#3)
addplot gndetdiff: , legend(off) yscale(range(0 1.2)) ylabel(#3)

graph combine  gyng  gyngdiff,  xcommon cols(1) ysize(7.87) xsize(5.9)  title( " Young households (age < 35)") name(CombYoungComp)
graph combine  gndet gndetdiff,  xcommon cols(1) ysize(7.87) xsize(5.9)  title( "Owner-occupier with no debt ") name(CombndetComp)

*graph combine gyng gndet gyngdiff  gndetdiff     ,  xcommon cols(2) ysize(30cm) xsize(50cm)  



foreach suffix in "lApp" "NonBind" "Young" "Bind" "ndetComp" "YoungComp" {
	graph export output/fig_`suffix'.pdf, as(pdf) replace name(Comb`suffix')
	
	
}

qui do code/Quintiles.do