/* 
Generates additional variables do be used in the analysis 
*/

*Does the varibale construction for both versions of the data set (dropped and not)
forval j = 1/1 {
	clear all
	use data/intermediate/FZdata_drop`j'.dta
	
	
	 *this is for the big one: 
	  do code/rho_phi_calculator.do
	
	

	* Construct rate up variables for to account for different order of rates
	
	generate WTPlowR= hypo_q2 if startRateLow==1
	replace WTPlowR= hypo_q3 if startRateLow==0
	
	generate WTPhighR= hypo_q2 if startRateLow==0
	replace WTPhighR= hypo_q3 if startRateLow==1
	
	foreach var in WTPlowR WTPhighR{
			generate ln_`var'=log(`var')
			generate ln_`var'_ar=log(`var'/homevalue)
	
	}
	
	generate ln_ch_HighLow=ln_WTPhighR-ln_WTPlowR
	
	
	*Label exisiting variables
	label variable hypo_q2_q1_logchg "d(log(WTP)) with DP from 20% to 5%"
	
	
	*shorten name of heavily used relative to app data
	
	forval w = 1/4 {
gen ln_wtp`w'_ar = ln_wtp`w'_appr_ratio 
}
	
	
	*Create marked renter and owner ownly series
	
	foreach var of varlist hypo_q2_q1_logchg  hypo_logchange_rateup  hypo_logchange_inher ln_wtp1_ar ln_wtp2_ar {
		generate `var'_O=`var' if renter==0
		generate `var'_R=`var' if renter==1
}
	
	
	*Generate  series with dropped WTP=appraisal
	
	
forval w = 1/4 {
	gen  ln_wtp`w'_arEx0= ln_wtp`w'_ar
	replace ln_wtp`w'_arEx0=. if ln_wtp`w'_ar==0

}
gen ln_wtp1_arEx0_R=ln_wtp1_ar_R
gen ln_wtp2_arEx0_R=ln_wtp2_ar_R

replace  ln_wtp1_arEx0_R=. if ln_wtp1_ar_R==0
replace  ln_wtp2_arEx0_R =. if ln_wtp2_ar_R==0

gen ln_wtp1_arEx0_O=ln_wtp1_ar_O
gen ln_wtp2_arEx0_O=ln_wtp2_ar_O

replace  ln_wtp1_arEx0_O=. if ln_wtp1_ar_O==0
replace  ln_wtp2_arEx0_O =. if ln_wtp2_ar_O==0


gen ln_wtp1_arEx012=ln_wtp1_ar
gen ln_wtp2_arEx012=ln_wtp2_ar

replace  ln_wtp1_arEx012=. if ln_wtp1_ar==0&ln_wtp2_ar==0
replace  ln_wtp2_arEx012 =. if ln_wtp1_ar==0&ln_wtp2_ar==0

gen ln_wtp1_arExOr=ln_wtp1_ar
replace  ln_wtp1_arExOr =. if ln_wtp1_ar==0|ln_wtp2_ar==0
gen ln_wtp2_arExOr=ln_wtp2_ar
replace  ln_wtp2_arExOr =. if ln_wtp1_ar==0|ln_wtp2_ar==0

*replace  ln_wtp1_arEx012=. if ln_wtp1_ar==0&ln_wtp2_ar==0&ln_wtp3_ar==0&ln_wtp4_ar==0
*replace  ln_wtp2_arEx012 =. if ln_wtp1_ar==0&ln_wtp2_ar==0&ln_wtp3_ar==0&ln_wtp4_ar==0

* generate changes for these variables

gen chln_wtp_arEx0=ln_wtp2_arEx0-ln_wtp1_arEx0
gen chln_wtp_arEx0_R=ln_wtp2_arEx0_R-ln_wtp1_arEx0_R
gen chln_wtp_arEx0_O=ln_wtp2_arEx0_O-ln_wtp1_arEx0_O



* Generate trimmed variables
	foreach var of varlist hypo_q2_q1_logchg  hypo_logchange_rateup  hypo_logchange_inher hypo_q2_q1_logchg_O  hypo_logchange_rateup_O  hypo_logchange_inher_O hypo_q2_q1_logchg_R  hypo_logchange_rateup_R  hypo_logchange_inher_R chln_wtp_arEx0 chln_wtp_arEx0_R chln_wtp_arEx0_O ln_wtp1_arEx0_R ln_wtp2_arEx0_R ln_wtp1_arEx0_O ln_wtp2_arEx0_O ln_wtp1_arEx0 ln_wtp2_arEx0 {
		qui trimmean  `var' , percent(5) generate(t5_`var')
		qui generate `var'_T5=`var' if t5_`var'==1
}

	foreach var of varlist hypo_q2_q1_logchg  hypo_logchange_rateup  hypo_logchange_inher hypo_q2_q1_logchg_O  hypo_logchange_rateup_O  hypo_logchange_inher_O hypo_q2_q1_logchg_R  hypo_logchange_rateup_R  hypo_logchange_inher_R chln_wtp_arEx0 chln_wtp_arEx0_R chln_wtp_arEx0_O ln_wtp1_arEx0_R ln_wtp2_arEx0_R ln_wtp1_arEx0_O ln_wtp2_arEx0_O ln_wtp1_arEx0 ln_wtp2_arEx0 {
		qui trimmean  `var' , percent(15) generate(t15_`var')
		qui generate `var'_T15=`var' if t15_`var'==1
}

*Generate levels variables trimmed by changes. Ie the levels that FZ are counting in their trimmed mean

trimmean hypo_q2_q1_logchg ,percent(5) generate(tc5_hypo_q2_q1_logchg)
generate ln_wtp1_arEx0_TC5=ln_wtp1_arEx0 if tc5_hypo_q2_q1_logchg==1
generate ln_wtp2_arEx0_TC5=ln_wtp2_arEx0 if tc5_hypo_q2_q1_logchg==1

	*save
	save data/intermediate/FZdata_drop`j'.dta, replace 
	
}
*clear all