*Compares different ways of dealing with WTP=appraisal vals


drop _all 
use data/intermediate/FZdata_drop1.dta
*drops variables but keeps graphs
graph drop _all

qui do code/main_programs.do


local pair1= "ln_wtp1_ar ln_wtp2_ar"

local pair2= "ln_WTPhighR_ar ln_WTPlowR_ar"

local pair3= "ln_wtp3_ar ln_wtp4_ar"

local pair4= "ln_wtp2_ar ln_wtp1_ar"

local trim=5

local dropsuffix ="_Ex0or"

capture program drop MainGraphProg
program MainGraphProg
	args bvar tvar trim gname dropsuffix
	
	qui trim_level `bvar' `tvar' `trim'
	
	qui remove_zeros_multi `bvar'_T`trim' `tvar'_T`trim'
	
	 CDFgraph  `bvar'_T`trim'`dropsuffix' `tvar'_T`trim'`dropsuffix' 5  -10 `gname'

end

set graphics on
set graphics off
MainGraphProg `pair1' `trim' "DP_CDF" `dropsuffix'
MainGraphProg `pair2' `trim' "Rates_CDF" `dropsuffix'
MainGraphProg `pair3' `trim' "Inher_CDF" `dropsuffix'
MainGraphProg `pair4' `trim' "DP_CDFRev" `dropsuffix'
 
 *CDFgraph  ln_wtp1_ar_T`trim'`dropsuffix' ln_wtp2_ar_T`trim'`dropsuffix' .2  -.1 DP_CDF_Zoom
*  CDFgraph   ln_wtp2_ar_T`trim'`dropsuffix' ln_wtp1_ar_T`trim'`dropsuffix' .2  -.2 DP_CDF_ZoomRev


addplot DP_CDF:, title("Constructed demand curves") legend(off)  text( 0.75 0.6 "5% down payment", size(medlarge) color(`.__SCHEME.color.p1'))  text( -0.5 0.5 "20% down payment", size(medlarge) color(`.__SCHEME.color.p2')) 

*addplot DP_CDFRev:, title("Tightening down payment by 15ppt") subtitle("Constructed demand curves") legend(pos(5) ring(0)  order(1 "Down payment 20%" 2 "Down payment 5%" ))
*addplot DP_CDF_ZoomRev:, title("Tightening down payment by 15ppt") subtitle("Zoomed in demand curves") legend(pos(5) ring(0)  order(1 "Down payment 20%" 2 "Down payment 5%" ))

addplot Rates_CDF:, title("Constructed demand curves") text( 0.75 0.6 "Mortgage rate 4.5%",size(medlarge) color(`.__SCHEME.color.p1'))  text( -0.7 0.55 "Mortgage rate 6.5%", size(medlarge) color(`.__SCHEME.color.p2')) legend(off)

addplot Inher_CDF:,  title("Constructed demand curves") text( 0.75 0.6 "Inheritance received",size(medlarge) color(`.__SCHEME.color.p1'))  text( -0.55 0.55 "No inheritance",size(medlarge) color(`.__SCHEME.color.p2')) legend(off)




set graphics on

*graph combine  DP_CDF DP_CDFdiff,  xcommon cols(1) ysize(20cm) xsize(15cm)  title( "Loosening down payment by 15ppt") name(DP_combined)
graph combine  DP_CDF DP_CDFdiff,  xcommon cols(1) ysize(8) xsize(6)  title( "Loosening down payment by 15ppt") name(DP_combined2)
graph combine  Rates_CDF Rates_CDFdiff,  xcommon cols(1) ysize(8) xsize(6)  title( "Mortgage rate cut by 200bps") name(Rates_combined)
graph combine  Inher_CDF Inher_CDFdiff,  xcommon cols(1) ysize(8) xsize(6)  title( "Inheriting $100,000") name(Inher_combined)

foreach suffix in "DP_combined2" "Rates_combined" "Inher_combined"  {
	graph export output/fig_`suffix'.pdf, as(pdf) replace name(`suffix')
	
	
}



*foreach in pair1 pair2 pair3
