*Compares different ways of dealing with WTP=appraisal vals


drop _all 
use data/intermediate/FZdata_drop1.dta
*drops variables but keeps graphs
graph drop _all

qui do code/main_programs.do


local pair1= "ln_wtp1_ar ln_wtp2_ar"

local pair2= "ln_WTPhighR_ar ln_WTPlowR_ar"

local pair3= "ln_wtp3_ar ln_wtp4_ar"

local pair4= "ln_wtp2_ar ln_wtp1_ar"

local trim=5

local dropsuffix =""

capture program drop MainGraphProg
program MainGraphProg
	args bvar tvar trim gname dropsuffix
	
	qui trim_level `bvar' `tvar' `trim'
	
	qui remove_zeros_multi `bvar'_T`trim' `tvar'_T`trim'
	
	 CDFgraph  `bvar'_T`trim'`dropsuffix' `tvar'_T`trim'`dropsuffix' 1  -1 `gname'

end

set graphics on
set graphics off
MainGraphProg `pair1' `trim' "FDP_CDF" `dropsuffix'
MainGraphProg `pair2' `trim' "FRates_CDF" `dropsuffix'
MainGraphProg `pair3' `trim' "FInher_CDF" `dropsuffix'
MainGraphProg `pair4' `trim' "FDP_CDFRev" `dropsuffix'
 
 *CDFgraph  ln_wtp1_ar_T`trim'`dropsuffix' ln_wtp2_ar_T`trim'`dropsuffix' .2  -.1 DP_CDF_Zoom
*  CDFgraph   ln_wtp2_ar_T`trim'`dropsuffix' ln_wtp1_ar_T`trim'`dropsuffix' .2  -.2 DP_CDF_ZoomRev


addplot FDP_CDF:, title("Demand Curves with Flat Areas") subtitle("Loosening down payment restrictions") legend(off)  text( 0.25 0.6 "5% down payment", color(`.__SCHEME.color.p1'))  text( -0.3 0.5 "20% down payment", color(`.__SCHEME.color.p2')) 

addplot FRates_CDF:, title("Demand Curves with Flat Areas") subtitle("Cutting mortgage rate") text( 0.25 0.6 "Mortgage rate 4.5%", color(`.__SCHEME.color.p1'))  text( -0.3 0.5 "Mortgage rate 6.5%", color(`.__SCHEME.color.p2')) legend(off)

addplot FInher_CDF:,  title("Constructed demand curves") text( 0.75 0.6 "Inheritance received", color(`.__SCHEME.color.p1'))  text( -0.5 0.5 "No inheritance", color(`.__SCHEME.color.p2')) legend(off)

set graphics on

graph di FDP_CDF
graph di FRates_CDF

graph export output/fig_FDP_CDF_Flat.pdf, as(pdf) replace name(FDP_CDF)
graph export output/fig_FRates_CDF_Flat.pdf, as(pdf) replace name(FRates_CDF)


*foreach in pair1 pair2 pair3
