# Summary statistics ####

stargazer(as.data.frame(business_lending[c("credit_growth_cum", "borrower_type")]), type = "text", title = "Descriptive statistics")

df_bank_characteristics_businesslendingbanks <- df_bank_characteristics %>%
  filter(business_lending_bank == 1) %>%
  arrange(desc(total_tier1_capital_ratio))

stargazer(as.data.frame(df_bank_characteristics_businesslendingbanks[c("total_assets_billions", "liquidity_ratio",
                                                                       "net_interest_income_ratio", "funding_costs_ratio", 
                                                                       "provisions_ratio", "common_equity_tier1_capital_ratio", 
                                                                       "total_tier1_capital_ratio", "leverage_totaltier1")]), 
          digits = 1, type = "html", title = "Descriptive statistics", 
          out = paste0(regression_output, "descriptive_statistics_businesslendingbanks_final.html"))


df_bank_characteristics_nonADIs <- df_bank_characteristics %>%
  filter(institution_type == "non-ADI")

## All non-banks
stargazer(as.data.frame(df_bank_characteristics_nonADIs[c("total_assets_billions", "liquidity_ratio",
                                                          "net_interest_income_ratio", "funding_costs_ratio", 
                                                          "common_equity_tier1_capital_ratio", "total_tier1_capital_ratio", 
                                                          "leverage_core", "leverage_totaltier1")]), 
          digits = 1, type = "html", title = "Descriptive statistics", 
          out = paste0(regression_output, "descriptive_statistics_nonADIs.html"))


##all Banks

df_bank_characteristics_ADIs <- df_bank_characteristics %>%
  filter(institution_type == "ADI")


stargazer(as.data.frame(df_bank_characteristics_ADIs[c("total_assets_billions", "liquidity_ratio",
                                                       "net_interest_income_ratio", "funding_costs_ratio", 
                                                       "provisions_ratio", "common_equity_tier1_capital_ratio", 
                                                       "total_tier1_capital_ratio", "leverage_totaltier1")]), 
          digits = 1, type = "html", title = "Descriptive statistics", 
          out = paste0(regression_output, "descriptive_statistics_ADIs.html"))

## Sample sizes

business_lending_full %>%
  filter(!is.na(totalbus_credit_growth_cum)) %>%
  distinct(institution_code)

business_lending %>%
  filter(!is.na(SME_credit_growth_cum)) %>%
  distinct(institution_code)

df_720_1_balanced %>%
  filter(!is.na(totalbus_credit_growth_cum)) %>%
  filter(institution_type == "non-ADI") %>%
  distinct(institution_code)
