# SME v Large business lending ####

## Generate pre-trends data ####

parallel_trends_assumption <- business_lending

parallel_trends_assumption$SME_credit_growth_cum_3mma [is.infinite(parallel_trends_assumption$SME_credit_growth_cum_3mma)] <- NA
parallel_trends_assumption$SME_credit_growth_cum [is.infinite(parallel_trends_assumption$SME_credit_growth_cum)] <- NA

parallel_trends_assumption <- parallel_trends_assumption %>%
  group_by(period) %>%
  summarise( 
    SME_credit_growth_cum_3mma = mean(SME_credit_growth_cum_3mma, na.rm = TRUE), 
    largebus_credit_growth_cum_3mma = mean(largebus_credit_growth_cum_3mma, na.rm = TRUE),
    SME_credit_growth_cum = mean(SME_credit_growth_cum, na.rm = TRUE), 
    largebus_credit_growth_cum = mean(largebus_credit_growth_cum, na.rm = TRUE))

write_csv(parallel_trends_assumption, file = paste0(output_path, "pre_trends_baseline.csv"), na = "")

rm(parallel_trends_assumption)

## Base regression - SME v large business lending ####

cm_tablea1 <- c("SME_borrower" = "SME borrower", "(Intercept)" = "Constant")

sme_base <- feols(credit_growth_cum ~ SME_borrower, data = business_lending, split = "period", 
                  cluster = "institution_name", se = "cluster") 

modelsummary(sme_base, output = paste0(regression_output, "/Table_C1.html"), coef_map = cm_tablea1, 
             stars = TRUE, title = "Bank credit growth to SMEs relative to large businesses", statistic = c("t = {statistic}",
                                                                                                            "se = {std.error}",
                                                                                                            "conf.int"))

rm(sme_base)


## Base regression - SME v large business lending - only fixed-term loans ####

fixed_term_sme <- feols(credit_growth_cum_fixed ~ SME_borrower, data = bank_fixed_lending, split = "period", cluster = "institution_name", se = "cluster")

modelsummary(fixed_term_sme, output = paste0(regression_output, "/Table_C2.html"), coef_map = cm_tablea1, stars = TRUE, 
             title = "Bank fixed-term credit growth to SMEs relative to large businesses", statistic = c("t = {statistic}",
                                                                                                         "se = {std.error}",
                                                                                                         "conf.int"))

rm(fixed_term_sme)

## Industry-level regressions ####

# Regressions

# Bank-industry fixed effects
sector_banksectorfe <- feols(credit_growth_cum ~ SME_borrower | institution_code^sector, data = sector_bank, split = "period", 
                             cluster = "institution_code", se = "cluster")

modelsummary(sector_banksectorfe, output = paste0(regression_output, "Table_C4.html"), stars = TRUE, 
             title = "Bank credit growth to SMEs relative to large businesses - industry-level model - interaction between industry and bank fixed effects",
             statistic = c("t = {statistic}",
                           "se = {std.error}",
                           "conf.int"))

rm(sector_banksectorfe)

# Bank fixed effects

sector_bankfe <- feols(credit_growth_cum ~ SME_borrower | institution_code, data = sector_bank, split = "period", 
                      cluster = "institution_code", se = "cluster")

modelsummary(sector_bankfe, output = paste0(regression_output, "Table_C5.html"), stars = TRUE, 
             title = "Bank credit growth to SMEs relative to lagre businesses - industry-level model - bank fixed effects",
             statistic = c("t = {statistic}",
                           "se = {std.error}",
                           "conf.int"))

rm(sector_bankfe)

# Industry fixed effects

sector_sectorfe <- feols(credit_growth_cum ~ SME_borrower | sector, data = sector_bank, split = "period", 
                        cluster = "institution_code", se = "cluster")

modelsummary(sector_sectorfe, output = paste0(regression_output, "Table_C6.html"), stars = TRUE, 
             title = "Bank credit growth to SMEs relative to lagre businesses - industry-level model - industry fixed effects",
             statistic = c("t = {statistic}",
                           "se = {std.error}",
                           "conf.int"))

rm(sector_sectorfe)

## Bank characteristics ####

# Representative time period: April 2021

business_lending_apr21 <- business_lending %>%
  filter(period == "2021-04-30")

business_lending_apr21$credit_growth_cum[is.infinite(business_lending_apr21$credit_growth_cum)] <- 0

# Run regressions - linear model with multiple group fixed effects

felmregassets <- felm(credit_growth_cum ~ SME_borrower + log_total_assets +  SME_borrower:log_total_assets | 0 | 0 |
                        institution_name, data = business_lending_apr21)

felmregloanstodep <- felm(credit_growth_cum ~ SME_borrower + loans_to_dep + SME_borrower:loans_to_dep | 0 | 0 | 
                            institution_name, data = business_lending_apr21)

felmregprovisions <- felm(credit_growth_cum ~ SME_borrower + provisions_ratio + SME_borrower:provisions_ratio | 0 | 0 | 
                            institution_name, data = business_lending_apr21)

felmregliquidity <- felm(credit_growth_cum ~ SME_borrower + liquidity_ratio + SME_borrower:liquidity_ratio | 0 | 0 | 
                           institution_name, data = business_lending_apr21)

felmreginterestincome <- felm(credit_growth_cum ~ SME_borrower + net_interest_income_ratio  + 
                                SME_borrower:net_interest_income_ratio  | 0 | 0 | institution_name, data = business_lending_apr21)

felmregfundingcosts <- felm(credit_growth_cum ~ SME_borrower + funding_costs_ratio + SME_borrower:funding_costs_ratio | 0 | 0 |
                              institution_name, data = business_lending_apr21)

felmregcommonequitytier1capital <- felm(credit_growth_cum ~ SME_borrower + common_equity_tier1_capital_ratio  + 
                                          SME_borrower:common_equity_tier1_capital_ratio | 0 | 0 | 
                                          institution_name, data = business_lending_apr21)

felmregtotaltier1capital <- felm(credit_growth_cum ~ SME_borrower + total_tier1_capital_ratio + 
                                   SME_borrower:total_tier1_capital_ratio | 0 | 0 | institution_name, data = business_lending_apr21)

felmregleveragecore <- felm(credit_growth_cum ~ SME_borrower + leverage_core + SME_borrower:leverage_core | 0 | 0 | 
                              institution_name, data = business_lending_apr21)

felmregleveragetotaltier1 <- felm(credit_growth_cum ~ SME_borrower + leverage_totaltier1  + SME_borrower:leverage_totaltier1  | 
                                    0 | 0 | institution_name, data = business_lending_apr21)

# Combine regression output and export

stargazer(felmregassets,
          felmregloanstodep,
          felmregprovisions,
          felmregliquidity,
          felmreginterestincome, 
          felmregfundingcosts,
          felmregcommonequitytier1capital,  
          felmregtotaltier1capital, 
          felmregleveragecore, 
          felmregleveragetotaltier1, 
          type = "html", out = paste0(regression_output, "Table_C10.html"))


rm(felmregassets,
   felmregloanstodep,
   felmregprovisions,
   felmregliquidity,
   felmreginterestincome, 
   felmregfundingcosts,
   felmregcommonequitytier1capital,  
   felmregtotaltier1capital, 
   felmregleveragecore, 
   felmregleveragetotaltier1,
   business_lending_apr21)

## Triple difference estimation ####

# Pre-trends data ##

# Triple Difference data - using 742 data used for fixed-term lending regressions 

TD_data <- fixed_lending %>% 
  select(period, institution_code, institution_name, credit_growth_cum, SME_borrower, institution_type_dummy) %>% 
  rename(institution_name = institution_name) %>% 
  filter(institution_code != "Outlier 1") %>%
  filter(institution_code != "Outlier 2") %>% 
  filter(institution_code != "Outlier 3") 

TD_data$credit_growth_cum [is.na(TD_data$credit_growth_cum)] <- NA
TD_data$credit_growth_cum [is.nan(TD_data$credit_growth_cum)] <- NA
TD_data$credit_growth_cum [is.infinite(TD_data$credit_growth_cum)] <- NA

# Pre-trends data export

TD_pre_trends <- fixed_lending %>% 
  select(period, institution_code, institution_name, SME_credit_growth_cum, largebus_credit_growth_cum, 
         SME_credit, largebus_credit, institution_type) %>% 
  filter(institution_code != "Outlier 1") %>%
  filter(institution_code != "Outlier 2") %>% 
  filter(institution_code != "Outlier 3") %>% 
  unique()

TD_pre_trends$SME_credit_growth_cum [is.na(TD_pre_trends$SME_credit_growth_cum)] <- NA
TD_pre_trends$SME_credit_growth_cum [is.nan(TD_pre_trends$SME_credit_growth_cum)] <- NA
TD_pre_trends$SME_credit_growth_cum [is.infinite(TD_pre_trends$SME_credit_growth_cum)] <- NA
TD_pre_trends$largebus_credit_growth_cum [is.na(TD_pre_trends$largebus_credit_growth_cum)] <- NA
TD_pre_trends$largebus_credit_growth_cum [is.nan(TD_pre_trends$largebus_credit_growth_cum)] <- NA
TD_pre_trends$largebus_credit_growth_cum [is.infinite(TD_pre_trends$largebus_credit_growth_cum)] <- NA


TD_pre_trends <- TD_pre_trends %>%
  group_by(period, institution_type) %>%
  summarise(SME_credit_growth_cum = mean(SME_credit_growth_cum, na.rm = TRUE), 
            largebus_credit_growth_cum = mean(largebus_credit_growth_cum, na.rm = TRUE))

write_csv(TD_pre_trends, file = paste0(output_path, "TD_pre_trends.csv"), na = "")

rm(TD_pre_trends)

# Triple Difference regression ##

triple_difference <- feols(credit_growth_cum ~ SME_borrower + institution_type_dummy + SME_borrower:institution_type_dummy, 
                           data = TD_data, split = "period", cluster = "institution_name", se = "cluster")

modelsummary(triple_difference, output = paste0(regression_output, "/Table_C12.html"),  stars = TRUE, 
             title = "Credit growth to SMEs relative to large businesses and for banks relative to non-banks", 
             statistic = c("t = {statistic}",
                           "se = {std.error}",
                           "conf.int"))

rm(triple_difference, TD_data)


## Weighted regressions ####
# Using full sample, including outliers

business_lending_weightedreg <- business_lending_full %>%
  filter(!is.na(credit_growth_cum)) %>%
  filter(period >= first_month & period <= last_month)

# Run regression - SME versus large business lending

baselineSME_weighted <- feols(credit_growth_cum ~ SME_borrower, data = business_lending_weightedreg, 
                              weights = business_lending_weightedreg$business_credit_base, split = "period", 
                              cluster = "institution_name", se = "cluster")

modelsummary(baselineSME_weighted, output = paste0(regression_output, "Table_C7.html"), coef_map = cm_tablea1, 
             stars = TRUE, title = "Weighted regression - bank credit growth to SMEs relative to large businesses", 
             statistic = c("t = {statistic}",
                           "se = {std.error}",
                           "conf.int"))

rm(business_lending_weightedreg, baselineSME_weighted)

# Run regression - SME versus large business lending - Fixed-term lending

fixed_SME_weighted <- feols(credit_growth_cum_fixed ~ SME_borrower, data = bank_fixed_lending, 
                            weights = bank_fixed_lending$business_credit_fixed_base, split = "period", 
                            cluster = "institution_name", se = "cluster")

modelsummary(fixed_SME_weighted, output = paste0(regression_output, "/Table_C9.html"), stars = TRUE, 
             title = "Weighted regression - fixed-term bank credit growth to SMEs relative to large businesses", 
             statistic = c("t = {statistic}",
                           "se = {std.error}",
                           "conf.int"))

rm(fixed_SME_weighted)

# Run regression - Industry model

sector_bank_full <- sector_bank_full %>%
  filter(period >= first_month & period <= last_month)

sector_sectorbankfe <- feols(credit_growth_cum ~ SME_borrower | sector^institution_code, 
                            data = sector_bank_full, split = "period", weights = sector_bank_full$credit_base,
                            cluster = "institution_code", se = "cluster")

modelsummary(sector_sectorbankfe, output = paste0(regression_output, "Table_C8.html"), stars = TRUE, 
             title = "Weighted regression - bank credit growth to SMEs relative to large businesses - industry model", 
             statistic = c("t = {statistic}",
                           "se = {std.error}",
                           "conf.int"))

rm(sector_sectorbankfe)

## Placebo test ####

cm_placebo <- c("small_bus_dummy" = "small business borrower", "(Intercept)" = "Constant")

placebo_reg <- feols(credit_growth_cum ~ small_bus_dummy, data = business_lending_placebo, 
                     split = "period", cluster = "institution_code", se = "cluster")

modelsummary(placebo_reg, output = paste0(regression_output, "Table_C3.html"), coef_map = cm_placebo, stars = TRUE, 
             title = "Placebo test - bank credit growth to small businesses relative to medium businesses", 
             statistic = c("t = {statistic}",
                           "se = {std.error}",
                           "conf.int"))

rm(placebo_reg)

## Run regression - Basic Diff-in-Diff ####

basic_did <- business_lending %>% 
  select(institution_code, period, business_credit, credit_growth_cum, SME_borrower, time_dummy) %>% 
  mutate(value = log(business_credit),
         treated = SME_borrower == 1 &
           period >= "2020-04-01") %>% 
  mutate(bus_credit_log = log(business_credit))


tablea1 <- feols(bus_credit_log ~ SME_borrower + time_dummy + SME_borrower:time_dummy | institution_code + period, data = basic_did)

msummary(tablea1, output = paste0(regression_output, "Table_C11.html"), stars = TRUE)

rm(basic_did, tablea1)
