# Banks who accessed the TFF ####

## Generate pre-trends data ####

# Using self-secs

parallel_trends_assumption <- business_lending_usage_ADIs 

parallel_trends_assumption$totalbus_credit_growth_cum[is.infinite(parallel_trends_assumption$totalbus_credit_growth_cum)] <- NA

parallel_trends_assumption <- parallel_trends_assumption %>%
  mutate(self_secs = ifelse(!is.na(self_sec_collateral_value), "Has self-secs", "No self-secs")) %>%
  group_by(period, self_secs) %>%
  summarise(totalbus_credit_growth_cum = mean(totalbus_credit_growth_cum, na.rm = TRUE)) %>%
  pivot_wider(names_from = self_secs, values_from = totalbus_credit_growth_cum)

write_csv(parallel_trends_assumption, file = paste0(output_path, "pre_trends_IV_selfsecs.csv"), na = "")

rm(parallel_trends_assumption)

# Using accessed TFF

parallel_trends_assumption <- business_lending_usage_ADIs 

parallel_trends_assumption$totalbus_credit_growth_cum[is.infinite(parallel_trends_assumption$totalbus_credit_growth_cum)] <- NA

parallel_trends_assumption <- parallel_trends_assumption %>%
  mutate(accessed_tff = if_else(accessed_tff == 1, "Accessed the TFF", "Did not access the TFF")) %>% 
  group_by(period, accessed_tff) %>%
  summarise(totalbus_credit_growth_cum = mean(totalbus_credit_growth_cum, na.rm = TRUE)) %>%
  pivot_wider(names_from = accessed_tff, values_from = totalbus_credit_growth_cum)

write_csv(parallel_trends_assumption, file = paste0(output_path, "pre_trends_IV_access.csv"), na = "")

rm(parallel_trends_assumption)

## Run regression - OLS - access v did not access ####

feols_accessed <- feols(totalbus_credit_growth_cum ~ accessed_tff, data = business_lending_usage_ADIs, split = "period", 
                       cluster = "institution_name", se = "cluster")

modelsummary(feols_accessed, output = paste0(regression_output, "Table_C19.html"), stars = TRUE, 
             title = "Business credit growth for banks that accessed the TFF compared to banks that did not",
             statistic = c("t = {statistic}",
                           "se = {std.error}",
                           "conf.int"))

rm(feols_accessed)

## Run regression - Self-securitisation as IV  - access v did not access ####

cm_IV_1 <- c("self_sec_dummy" = "self-sec availability", "(Intercept)" = "Constant")
cm_IV_1_ssadequacy <- c("self_sec_adequacy" = "self-sec adequacy", "(Intercept)" = "Constant")
cm_IV_2 <- c("fit_accessed_tff" = "accessed TFF (fitted)", "(Intercept)" = "Constant")

# Using binary IV

iv_selfsecs_binary <- feols(totalbus_credit_growth_cum ~ 1 | accessed_tff ~ self_sec_dummy, data = business_lending_usage_ADIs, 
                          split = "period", cluster = "institution_name", se = "cluster")

summary(iv_selfsecs_binary, stage = 1) # t-statistic for first stage

modelsummary(iv_selfsecs_binary, stage = 1, output = paste0(regression_output, "Table_C20.html"), coef_map = cm_IV_1, stars = TRUE, 
             title = "Business credit growth for banks that accessed the TFF compared to banks that did not - IV specification - self-sec binary IV - first stage",
             statistic = c("t = {statistic}",
                             "se = {std.error}",
                             "conf.int"))

modelsummary(iv_selfsecs_binary, output = paste0(regression_output, "Table_C21.html"), coef_map = cm_IV_2, stars = TRUE, 
             title = "Business credit growth for banks that accessed the TFF compared to banks that did not - IV specification - self-sec binary IV - second stage",
             statistic = c("t = {statistic}",
                           "se = {std.error}",
                           "conf.int"))

rm(iv_selfsecs_binary)

# Using adequacy IV

iv_selfsec_adequacy <- feols(totalbus_credit_growth_cum ~ 1 | accessed_tff ~ self_sec_adequacy, data = business_lending_usage_ADIs, 
                            split = "period", cluster = "institution_name", se = "cluster")

summary(iv_selfsec_adequacy, stage = 1) # t-statistics for first stage

modelsummary(iv_selfsec_adequacy, stage = 1, output = paste0(regression_output, "Table_C22.html"), 
             coef_map = cm_IV_1_ssadequacy, stars = TRUE, 
             title = "Business credit growth for banks that accessed the TFF compared to banks that did not - IV specification - self-sec adequacy IV - first stage",
             statistic = c("t = {statistic}",
                           "se = {std.error}",
                           "conf.int"))

modelsummary(iv_selfsec_adequacy, output = paste0(regression_output, "Table_C23.html"), coef_map = cm_IV_2, stars = TRUE, 
             title = "Business credit growth for banks that accessed the TFF compared to banks that did not - IV specification - self-sec adequacy IV - second stage",
             statistic = c("t = {statistic}",
                           "se = {std.error}",
                           "conf.int"))

rm(iv_selfsec_adequacy)

## Run regression - Self-securitisation as IV  - access v did not access - just fixed-term ####

access_tff_fixed <- fixed_lending %>% 
  left_join(self_secs) %>% 
  filter(eligible_bank == 1) %>%
  filter(period >= first_month & period <= last_month)

access_tff_fixed$self_sec_adequacy[is.na(access_tff_fixed$self_sec_adequacy)] <- 0
access_tff_fixed$self_sec_dummy[is.na(access_tff_fixed$self_sec_dummy)] <- 0

access_tff_fixed <- access_tff_fixed %>% 
  select(period, institution_name, institution_name, totalbus_credit_growth_cum, totalbus_fixed_growth_cum, 
         accessed_tff, self_sec_dummy, self_sec_adequacy) %>% 
  unique()

# Using binary IV

feols_iv_selfsecs_FT <- feols(totalbus_fixed_growth_cum ~ 1 | accessed_tff ~ self_sec_dummy, data = access_tff_fixed, 
                              split = "period", cluster = "institution_name", se = "cluster")

modelsummary(feols_iv_selfsecs_FT, stage = 1, output = paste0(regression_output, "Table_C24.html"), stars = TRUE, 
             title = "Fixed-term business credit growth for banks that accessed the TFF compared to banks that did not - IV specification - self-sec binary IV - first stage",
             statistic = c("t = {statistic}",
                           "se = {std.error}",
                           "conf.int"))

modelsummary(feols_iv_selfsecs_FT, output = paste0(regression_output, "Table_C25.html"), stars = TRUE, 
             title = "Fixed-term business credit growth for banks that accessed the TFF compared to banks that did not - IV specification - self-sec binary IV - second stage",
             statistic = c("t = {statistic}",
                           "se = {std.error}",
                           "conf.int"))

summary(feols_iv_selfsecs_FT, stage = 1) 

rm(feols_iv_selfsecs_FT)

# Using adequacy IV

feols_iv_selfsec_adequacy_FT <- feols(totalbus_fixed_growth_cum ~ 1 | accessed_tff ~ self_sec_adequacy, 
                                     data = access_tff_fixed, split = "period", cluster = "institution_name", se = "cluster")

modelsummary(feols_iv_selfsec_adequacy_FT, stage = 1, output = paste0(regression_output, "Table_C26.html"), stars = TRUE, 
             title = "Fixed-term business credit growth for banks that accessed the TFF compared to banks that did not - IV specification - self-sec adequacy IV - first stage",
             statistic = c("t = {statistic}",
                           "se = {std.error}",
                           "conf.int"))

modelsummary(feols_iv_selfsec_adequacy_FT, output = paste0(regression_output, "Table_C27.html"), stars = TRUE, 
             title = "Fixed-term business credit growth for banks that accessed the TFF compared to banks that did not - IV specification - self-sec adequacy IV - second stage",
             statistic = c("t = {statistic}",
                           "se = {std.error}",
                           "conf.int"))

summary(feols_iv_selfsec_adequacy_FT, stage = 1)

rm(feols_iv_selfsec_adequacy_FT, access_tff_fixed)

## Run regression - Self-securitisation as IV  - TFF drawdowns (footnote) ####

# Binary IV

feols_iv_drawdowns <- feols(totalbus_credit_growth_cum ~ 1 | drawdown_final_millions ~ self_sec_dummy, 
                           data = business_lending_usage_ADIs, split = "period", cluster = "institution_name", se = "cluster")

summary(feols_iv_drawdowns, stage = 1) 

modelsummary(feols_iv_drawdowns, stage = 1, output = paste0(regression_output, "Table_iv_binary_stage1_drawdowns.html"), stars = TRUE, 
             title = "Business credit growth for banks that drew down on the TFF compared to banks that did not - IV specification - self-sec binary IV - first stage",
             statistic = c("t = {statistic}",
                           "se = {std.error}",
                           "conf.int"))


modelsummary(feols_iv_drawdowns, output = paste0(regression_output, "Table_iv_binary_stage2_drawdowns.html"), stars = TRUE, 
             title = "Business credit growth for banks that drew down on the TFF compared to banks that did not - IV specification - self-sec binary IV - second stage",
             statistic = c("t = {statistic}",
                           "se = {std.error}",
                           "conf.int"))

rm(feols_iv_drawdowns)

# Adequacy IV

feols_iv_selfsec_ad_drawdowns <- feols(totalbus_credit_growth_cum ~ 1 | drawdown_final_millions ~ self_sec_adequacy, 
                                       data = business_lending_usage_ADIs, split = "period", cluster = "institution_name", 
                                       se = "cluster")

summary(feols_iv_selfsec_ad_drawdowns, stage = 1) 

modelsummary(feols_iv_selfsec_ad_drawdowns, stage = 1, output = paste0(regression_output, "Table_iv_adq_stage1_drawdowns.html"), stars = TRUE, 
             title = "Business credit growth for banks that drew down on the TFF compared to banks that did not - IV specification - self-sec adequacy IV - first stage",
             statistic = c("t = {statistic}",
                           "se = {std.error}",
                           "conf.int"))
modelsummary(feols_iv_selfsec_ad_drawdowns, output = paste0(regression_output, "Table_iv_adq_stage2_drawdowns.html"), stars = TRUE, 
             title = "Business credit growth for banks that drew down on the TFF compared to banks that did not - IV specification - self-sec adequacy IV - second stage",
             statistic = c("t = {statistic}",
                           "se = {std.error}",
                           "conf.int"))

rm(feols_iv_selfsec_ad_drawdowns)


## Run regression - Eligibility as IV  - access v did not access ####


eligibility_IV_data <- df_720_1_balanced %>%  
  select(period, institution_code, institution_name, totalbus_credit_growth_cum, institution_type_dummy) %>% 
  left_join(accessed_tff) 

eligibility_IV_data$accessed_tff[is.na(eligibility_IV_data$accessed_tff)] <- 0

feols_iv_eligibility <- feols(totalbus_credit_growth_cum ~ 1 | accessed_tff ~ institution_type_dummy, 
                             data = eligibility_IV_data, split = "period",
                             cluster = "institution_code", se = "cluster")

summary(feols_iv_eligibility, stage = 1) 

modelsummary(feols_iv_eligibility, stage = 1, output = paste0(regression_output, "Table_C28.html"), stars = TRUE, 
             title = "Business credit growth for institutions that accessed the TFF - first stage",
             statistic = c("t = {statistic}",
                           "se = {std.error}",
                           "conf.int"))

modelsummary(feols_iv_eligibility, output = paste0(regression_output, "Table_C29.html"), stars = TRUE, 
             title = "Business credit growth for institutions that accessed the TFF - first stage",
             statistic = c("t = {statistic}",
                           "se = {std.error}",
                           "conf.int"))

rm(feols_iv_eligibility, eligibility_IV_data)

## IV Analysis - Anderson-Rubin Confidence Intervals ####

dir.create(file.path(regression_output, "AR coefficients"), showWarnings = FALSE)
dir.create(file.path(regression_output, "AR coefficients/binary_self_sec"), showWarnings = FALSE)
dir.create(file.path(regression_output, "AR coefficients/adequacy_self_sec"), showWarnings = FALSE)
dir.create(file.path(regression_output, "AR coefficients/eligible_institutions"), showWarnings = FALSE)


# AR intervals function

dates <- c("2019-10-31",
           "2019-11-30",
           "2019-12-31",
           "2020-01-31",
           "2020-02-29",
           "2020-03-31",
           "2020-04-30",
           "2020-05-31",
           "2020-06-30",
           "2020-07-31",
           "2020-08-31",
           "2020-09-30",
           "2020-10-31",
           "2020-11-30",
           "2020-12-31",
           "2021-01-31",
           "2021-02-28",
           "2021-03-31",
           "2021-04-30",
           "2021-05-31",
           "2021-06-30",
           "2021-07-31",
           "2021-08-31",
           "2021-09-30",
           "2021-10-31")

## Binary Self-sec IV

run_AR_coeff_binary <- function(specified_date) {
  
  business_lending_usage_ADIs_red <- business_lending_usage_ADIs %>% 
    filter(period == specified_date,
           !is.na(totalbus_credit_growth_cum))
  
  Y = business_lending_usage_ADIs_red[["totalbus_credit_growth_cum"]]
  D = business_lending_usage_ADIs_red[["accessed_tff"]]
  Z = business_lending_usage_ADIs_red[["self_sec_dummy"]]
  
  ivmodel(Y = Y, D = D, Z = Z)
  
  reg <- ivmodel(Y = Y, D = D, Z = Z)
  
  confint.ivmodel(reg)
  
  sink(paste0(regression_output,"AR coefficients/binary_self_sec/", specified_date, "_output.csv"))
  
  print(reg)
  
  sink()
  
}

for (i in dates) {
  run_AR_coeff_binary(specified_date = i)
}



## Adequacy Self-sec IV

run_AR_coeff_adequacy <- function(specified_date) {
  
  business_lending_usage_ADIs_red <- business_lending_usage_ADIs %>% 
    filter(period == specified_date,
           !is.na(totalbus_credit_growth_cum))
  
  Y = business_lending_usage_ADIs_red[["totalbus_credit_growth_cum"]]
  D = business_lending_usage_ADIs_red[["accessed_tff"]]
  Z = business_lending_usage_ADIs_red[["self_sec_adequacy"]]
  
  ivmodel(Y = Y, D = D, Z = Z)
  
  reg <- ivmodel(Y = Y, D = D, Z = Z)
  
  confint.ivmodel(reg)
  
  sink(paste0(regression_output,"AR coefficients/adequacy_self_sec/", specified_date, "_output.csv"))
  
  print(reg)
  
  sink()
  
}

for (i in dates) {
  run_AR_coeff_adequacy(specified_date = i)
}

## Eligible institutions IV model

run_AR_coeff_institutions <- function(specified_date) {
  
  business_lending_usage_ADIs_red <- business_lending_usage_ADIs %>% 
    filter(period == specified_date,
           !is.na(totalbus_credit_growth_cum))
  
  Y = business_lending_usage_ADIs_red[["totalbus_credit_growth_cum"]]
  D = business_lending_usage_ADIs_red[["accessed_tff"]]
  Z = business_lending_usage_ADIs_red[["institution_type_dummy"]]
  
  ivmodel(Y = Y, D = D, Z = Z)
  
  reg <- ivmodel(Y = Y, D = D, Z = Z)
  
  confint.ivmodel(reg)
  
  sink(paste0(regression_output,"AR coefficients/eligible_institutions/", specified_date, "_output.csv"))
  
  print(reg)
  
  sink()
  
}

for (i in dates) {
  run_AR_coeff_institutions(specified_date = i)
}

