# Load and clean sector level lending data ####

industry <- read_csv(file = paste0(input_path, "industry_raw.csv"))

# Group into broader sector buckets

sector <- industry %>%
  rename(industry = "Industry Name", value = "Value", borrower_type_orig = "Business Type Name") %>%
  mutate(borrower_type = ifelse(borrower_type_orig == "Large", "large", "SME")) %>%
  filter(industry != "Financial and insurance - Registered financial corporations" & 
           industry != "Financial and insurance - Central borrowing authorities" & 
           industry != "Financial and insurance - ADIs" & industry != "Financial and insurance - RBA" & 
           industry != "Public administration and safety") %>%
  mutate(sector = ifelse(industry == "Agriculture, forestry and fishing" | industry == "Mining"  |
                           industry == "Manufacturing" | industry == "Electricity, gas, water and waste services" | 
                           industry == "Residential building construction" | industry == "Non-residential building construction" | 
                           industry == "Other construction", "goods_production", 
                         ifelse(industry == "Wholesale trade" | industry == "Retail trade"  | 
                                  industry == "Transport, postal and warehousing", "goods_distribution",
                                ifelse(industry == "Information media and telecommunications" | 
                                         industry == "Financial and insurance - Other"  | 
                                         industry == "Rental, hiring and real estate services" | 
                                         industry == "Professional, scientific and technical services" | 
                                         industry == "Administrative and support services", "business_services",
                                       ifelse(industry == "Accommodation and food services" | 
                                                industry == "Education and training"  | 
                                                industry == "Health care and social assistance" | 
                                                industry == "Arts and recreation services" |
                                                industry == "Other services", "household_services","other"))))) %>%
  mutate(SME_borrower = ifelse(borrower_type == "SME", 1, 0)) %>%
  group_by(period, institution_code, sector, borrower_type, SME_borrower) %>%
  summarise(credit = sum(value)) %>%
  ungroup() %>%
  arrange(sector, institution_code, borrower_type, period) %>%
  group_by(sector, institution_code, borrower_type) %>%
  mutate(credit_3mma = rollmean(credit, 3, fill = NA, align = "right")) %>%
  ungroup()

# Calculate growth using base period

sector_base <- sector %>%
  filter(period == "2020-01-31") %>%
  rename(credit_jan20 = credit, credit_base = credit_3mma) %>%
  dplyr::select(-period)

sector_bank_full <- left_join(sector, sector_base, by = c("institution_code", "sector", "borrower_type", "SME_borrower"))

sector_bank_full <- sector_bank_full %>%
  arrange(sector, institution_code, borrower_type, period) %>%
  mutate(credit_growth_cum_3mma = credit_3mma / credit_base * 100 - 100) %>%
  mutate(credit_growth_cum = credit / credit_base * 100 - 100) %>%
  mutate(time_dummy = ifelse(period >= "2020-03-31", 1, 0)) %>%
  mutate(time_SME_borrower = SME_borrower * time_dummy)

# Exclude outliers

sector_bank <- sector_bank_full %>%
  filter(institution_code != "Outlier 1") %>%
  filter(institution_code != "Outlier 2") %>%
  filter(period >= first_month & period <= last_month)

