% This version of mainfile applies when restrictions are only on first
% column of Q (q_1) and there are no narrative restrictions.

%% Construct data for estimating VAR for y_t.
YY = data(opt.p+1:end,:); % y_t 
XX = lags(data,1:opt.p); % Matrix of regressors in VAR for y_t
XX = XX(opt.p+1:end,:); % Drop initial missing observations
if opt.const == 1 % Add constant to matrix of regressors
    XX = [XX ones(size(XX,1),1)];
end
% Add exogenous variables to matrix of regressors.
XX = [XX exog(opt.p+1:end,:)]; 

n = size(YY,2); % Number of endogenous variables
m = size(XX,2); % Number of parameters in each equation for y_t
opt.nExog = opt.const+size(exog,2); % Number coefficients on exogenous variables
T = length(YY); % Number of observations used in estimating VAR

%% Conduct posterior inference on impulse responses under Jeffreys prior.
% Posterior is normal-inverse-Wishart.
phiHat.B = (XX'*XX)\XX'*YY; % MLE of slope coefficients
phiHat.S = (YY - XX*phiHat.B)'*(YY-XX*phiHat.B);
phiHat.Sigma = (1/T)*phiHat.S; % MLE of VAR innovation covariance matrix
phiHat.P = (XX'*XX)\eye(m);
phiHat.cholP = chol(phiHat.P,'lower');

% Storage arrays.
B = zeros(n*m,opt.nonEmpty);
Sigmatr = zeros(n,n,opt.nonEmpty);
etaDraws = zeros(opt.nonEmpty,opt.H+1,length(opt.ivar));
etaUnitDraws = etaDraws;
etalb = etaDraws;
etaub = etaDraws;
etaUnitlb = etaDraws;
etaUnitub = etaDraws;
unbounded = zeros(opt.nonEmpty,1);
phiDraw = 0; % Counter for no. of draws from posterior of phi
draw = 0; % Counter for no. of draws with nonempty identified set

tic

while draw < opt.nonEmpty

    % Sample from normal-inverse-Wishart posterior.
    phiDraw = phiDraw + 1;
    phi.Sigma = iwishrnd(phiHat.S,T-m);
    phi.Sigmatr = chol(phi.Sigma,'lower');
    phi.Sigmatrinv = phi.Sigmatr\eye(n);
    phi.B = phiHat.B(:) + kron(phi.Sigmatr,phiHat.cholP)*randn(m*n,1);
     
    % Generate coefficients in orthogonal reduced-form VMA representation.
    [phi.vma,~] = genVMA(phi,opt);
    
    % Check if identified set is nonempty.
    [empty,restr.F,restr.S,Sbar,r,K,c0] = checkEmptyIS_Read(restr,phi);
    
    if empty == 0
    
        draw = draw + 1;
        
        % Store parameters.
        B(:,draw) = phi.B;
        Sigmatr(:,:,draw) = phi.Sigmatr;
        
        % Draw q from uniform distribution over space of unit-length
        % vectors satisfying identifying restrictions.
        q0 = drawqGibbs(Sbar,r,K,c0,1,3,1);
        
        % Use draw to compute impulse responses; this represents a draw of
        % the impulse responses given a conditionally uniform prior.
        
        for hh = 1:opt.H+1 % For each horizon
    
            etaDraws(draw,hh,:) = phi.vma(opt.ivar,:,hh)*q0;    
           
        end
        
        % Normalise draws under single prior so that they are with respect 
        % to a unit shock to the first variable.
        etaUnitDraws(draw,:,:) = etaDraws(draw,:,:)./etaDraws(draw,1,1);
        
        % Check whether identified set for normalising impulse response
        % includes zero (in which case impulse responses to unit shock may
        % be unbounded).
        unbounded(draw) = checkBoundedIS_Read(restr.F,restr.S);
        
        % Approximate bounds of identified set for impulse responses to a
        % unit shock using simulation.
        [etalb(draw,:,:),etaub(draw,:,:),etaUnitlb(draw,:,:),etaUnitub(draw,:,:)] = ...
            approximateBounds(phi,Sbar,r,K,c0,opt.Qdraws,0,1,opt);
       
      if mod(opt.nonEmpty-draw,opt.dispIter) == 0
              
       fprintf('\n%d draws with non-empty identified set remaining...',...
       opt.nonEmpty-draw);
               
      end
             
    end

end

runTime = toc;

%% Construct summaries of posterior/class of posteriors.
% Compute posterior means and medians under single prior.
etaUnitMean = permute(mean(etaUnitDraws,1),[2 3 1]);
etaUnitMed = permute(median(etaUnitDraws,1),[2 3 1]);

% Compute equi-tailed credible intervals under single prior.
etaUnitCredlb = permute(prctile(etaUnitDraws,100*(1-opt.aalpha)/2,1),[2 3 1]);
etaUnitCredub = permute(prctile(etaUnitDraws,100*(1+opt.aalpha)/2,1),[2 3 1]);

% Compute sets of posterior means.
etaMeanlb = permute(mean(etalb,1),[2 3 1]);
etaMeanub = permute(mean(etaub,1),[2 3 1]);
etaUnitMeanlb = permute(mean(etaUnitlb,1),[2 3 1]);
etaUnitMeanub = permute(mean(etaUnitub,1),[2 3 1]);

% Compute sets of posterior medians.
etaMedlb = permute(median(etalb,1),[2 3 1]);
etaMedub = permute(median(etaub,1),[2 3 1]);
etaUnitMedlb = permute(median(etaUnitlb,1),[2 3 1]);
etaUnitMedub = permute(median(etaUnitub,1),[2 3 1]);

% Compute robust credible intervals for unit impulse responses.
etaUnitRClb = squeeze(quantile(etaUnitlb,(1-opt.aalpha)/2,1));
etaUnitRCub = squeeze(quantile(etaUnitub,(1+opt.aalpha)/2,1));

% Compute posterior plausibility of restrictions (posterior probability
% that identified set is nonempty).
postPlaus = draw/phiDraw;

% Compute prior informativeness (ratio of widths of credible intervals).
priorInf = 1- (etaUnitCredub-etaUnitCredlb)./(etaUnitRCub-etaUnitRClb);