
print('Remember to hit ctrl + shift + F10 before each new run, to clear environment.')

options(warn=2)
options(warn=1)
options(error=recover)
options(error=NULL)



options("warnPartialMatchDollar"=TRUE)  
options(stringsAsFactors=FALSE)  



invisible(lapply(list.files('function_scripts'),
                 function(x) source(paste0('function_scripts/', x))))


### Load libraries
suppressWarnings(library(magrittr))  
suppressWarnings(library(data.table)) 
suppressWarnings(library(readxl))
suppressWarnings(library(odbc))  
suppressWarnings(library(DBI))  



### Generate all the default settings using the default_settings function. 
pmtrs <- default_settings_F()$pmtrs
CLM_coeffs <- default_settings_F()$CLM_coeffs
income_shocks <- default_settings_F()$income_shocks
# Set the date for the model run

###======================================================================================

###======================================================================================
### Import files required for model run. Same files for every model run.
date_key <- read.csv("String_to_numeric_date_key.csv")
SAFFI_queries <- read.csv("List_of_SAFFI_queries.csv", 
                          header=TRUE, stringsAsFactors=FALSE)
SAFFI_queries_complex <- read.csv("List_of_SAFFI_queries_complex.csv", header = TRUE, 
                                  stringsAsFactors = FALSE)
variable_key <- read.csv('Variable_definitions_for_ST_model.csv', 
                         stringsAsFactors=FALSE)
industry_multipliers <- read.csv("industry_multipliers.csv", header = TRUE, 
                                 stringsAsFactors = FALSE)
bankname_key <- read.csv('bankname_key.csv') %>% data.table
sec_query <- readLines('query_current_sec_data.dsql') #file not provided 
mort_pd_lgd_correls <- read.csv("mort_lvr_multipliers_for_pd_correls.csv", header=T)
AC_losses_fxd <- NA


##
#####
#########
##############
####################
#========================================================================================
pmtrs$ST_date_C <- "2019-12-31"
pmtrs$proj_window <- 9
pmtrs$RWA_growth <- TRUE
pmtrs$asset_grth_floor <- -Inf 
pmtrs$no_dividend_payments <- FALSE
pmtrs$credit_line_drawdown <- FALSE
pmtrs <- format_dates_F(pmtrs, date_key)
ST_start_values <- 
  import_and_format_SAFFI_data_F(date_key, SAFFI_queries, 
                                 SAFFI_queries_complex, 
                                 variable_key, pmtrs,
                                 LVR_data_L, SAFFI_update=FALSE)
LVR_data_L <- generate_LVR_inputs_F(ST_start_values, pmtrs, sec_query, bankname_key, 
                                    mort_pd_lgd_correls, secdata_update=FALSE, 
                                    show_comparison=FALSE)
LVR_data_bus_L <- as.data.table(list(fully_secured_cp = 
                                       runif(n = 100000, min = 0.35, max = 0.65), 
                                     fully_secured_hp = 
                                       runif(n = 100000, min = 0.60, max = 0.8)))
macro_data <- read.csv('macro_scenarios/test.csv')


macro_inputs <- CLM_coeffs
macro_inputs$macro_data <- format_macro_inputs_F(macro_data, ST_start_data, pmtrs)


# Run stress test projections
model_output <- 
  proj_multi_period_F(pmtrs, 
                      AC_losses_fxd,
                      income_shocks,
                      data_start_L=ST_start_values, 
                      LVR_data_L=LVR_data_L,
                      macro_inputs, 
                      multipliers = industry_multipliers, 
                      LVR_dist_bus_L = LVR_data_bus_L)





























      
