% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{load_ags_yields_intraday_hist}
\alias{load_ags_yields_intraday_hist}
\title{Load historical intraday yields for AGS}
\usage{
load_ags_yields_intraday_hist(dates, value_types = c("Mid"))
}
\arguments{
\item{dates}{A vector of the dates for which you need the yields, e.g. dates = c("2020-03-19", "2020-11-03").}

\item{value_types}{(Default = mid yield.) Change this if you need to see bids and/or offers.}
}
\description{
This function loads historical yields for nominal and inflation-linked AGS on a 5-minutely intraday frequency from Findur. Source: Yieldbroker (via Refinitiv). Table: USER_DM_YLD_IntradayBonds.
}
\seealso{
Other functions that load data: 
\code{\link{load_ags_semis_metadata}()},
\code{\link{load_ags_yields_close}()},
\code{\link{load_ags_yields_intraday}()},
\code{\link{load_ags_yields_open}()},
\code{\link{load_cash_rate_target_changes}()},
\code{\link{load_ois_rates_intraday}()},
\code{\link{load_semis_yields_close}()},
\code{\link{load_semis_yields_intraday_hist}()},
\code{\link{load_semis_yields_intraday}()},
\code{\link{load_semis_yields_open}()}
}
\concept{functions that load data}
