% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{load_ags_yields_close}
\alias{load_ags_yields_close}
\title{Load closing yields for AGS}
\usage{
load_ags_yields_close(
  metadata_required = TRUE,
  calc_types = "RBA",
  value_types = c("Mid")
)
}
\arguments{
\item{metadata_required}{(Default = true.) Change this if you do not want instruments lacking metadata to be filtered out. For example, metadata are not readily available for TBs prior to TB110.}

\item{calc_types}{(Default = RBA.) Change this if you want to see data other than those published in F16. 'Average' is an alternative setting with a longer time series.}

\item{value_types}{(Default = mid yield.) Change this if you need to see bids and/or offers, though these are unavailable for the 'RBA' calc type.}
}
\description{
This function loads closing yields for nominal and inflation-linked AGS from Findur, as published in F16. Sources: from 20 May 2013, Yieldbroker (via Refinitiv); prior to then, RBA (via a survey of bond dealers). Table: USER_DM_YLD_SurveyCGS.
}
\seealso{
Other functions that load data: 
\code{\link{load_ags_semis_metadata}()},
\code{\link{load_ags_yields_intraday_hist}()},
\code{\link{load_ags_yields_intraday}()},
\code{\link{load_ags_yields_open}()},
\code{\link{load_cash_rate_target_changes}()},
\code{\link{load_ois_rates_intraday}()},
\code{\link{load_semis_yields_close}()},
\code{\link{load_semis_yields_intraday_hist}()},
\code{\link{load_semis_yields_intraday}()},
\code{\link{load_semis_yields_open}()}
}
\concept{functions that load data}
