'========================================================
'									Banking Sector
'========================================================
' Theoretical and calibration work done in Brassil, Major and Rickards (2022)

'Banking model consists of:
'0) User options
'1) Parameter setup
'2) Debt funding costs  
'3) Losses
'4) Risk weights
'5) Return on assets
'6) Capital ratio
'7) Lending rates


'0 User options
'======================================================================================

' Sets whether you want the banking sector active in the model
' 0 = not on, 1 = on
!bankon = 1

' Sets whether credit supply is adjusted via 'all loans' or 'new loans only'. Default is 'all loans'.
' 0 = all loans, 1 = new loans only
!loantype = 0

' Sets how long the banking system is unable to access external capital markets following a crisis
' (value is in quarters)
scalar T = 4

' User-defined dates for required initialisations. All analyses must be run after these dates.
string startsetdate="2018Q1"
string endsetdate="2019Q1"
' Housing price gap set to zero at endsetdate (i.e. the stochastic trend is initialised to equal housing prices at this date). 
' Capital shortfall set to zero for the period between startsetdate and endsetdate.


' 1) Parameters
'======================================================================================

smpl @all
' Time-varying Beta parameter B_m (impact of mortgage rate on credit growth)
{modelname}.append beta_m = eq_nhc.@coef(6) - eq_nhc.@coef(2) * eq_nhc.@coef(3) * ptm(-4)/ptm
series beta_m = eq_nhc.@coef(6) - eq_nhc.@coef(2) * eq_nhc.@coef(3) * ptm(-4)/ptm

' Time-varying BX function (all the other factors affecting household credit)
{modelname}.append BX_m = eq_nhc.@coef(1) + eq_nhc.@coef(2) * ( log(nhc) - log(ph) - log(kid(-1)) - 100 * eq_nhc.@coef(3) * ( ptm(-4)/ptm - 1 ) ) + eq_nhc.@coef(4) * d(log(nhc)) + eq_nhc.@coef(5) * d(log(ph)) + ( 1 - eq_nhc.@coef(4) ) * d(log(kid(-1))) - eq_nhc.@coef(6) * nmr(-1) + ( 1 - eq_nhc.@coef(4) - eq_nhc.@coef(5) ) / 400 * pi_e

series BX_m = eq_nhc.@coef(1) + eq_nhc.@coef(2) * ( log(nhc) - log(ph) - log(kid(-1)) - 100 * eq_nhc.@coef(3) * ( ptm(-4)/ptm - 1 ) ) + eq_nhc.@coef(4) * d(log(nhc)) + eq_nhc.@coef(5) * d(log(ph)) + ( 1 - eq_nhc.@coef(4) ) * d(log(kid(-1))) - eq_nhc.@coef(6) * nmr(-1) + ( 1 - eq_nhc.@coef(4) - eq_nhc.@coef(5) ) / 400 * pi_e

smpl @all

scalar rw_ss = 0.4 'steady state of risk weights. 
scalar cap_ss = 0.11 'steady-state capital ratio
scalar Loss_ss = 0.00025 'steady state loss percentage of assets

'speed at which banks recover their capital ratios. Set somewhere between 0 and 1.
if !bankon = 0 then
scalar lambda_l = 0 
else
if !loantype = 0 then
scalar lambda_l = 0.15
else
scalar lambda_l = 0.05
endif
endif 

scalar theta_h = 0.67 'housing share of bank loans
scalar alpha_h = 0.00025 'steady state household loan loss percentage of assets. Set equal to Loss_ss until business loan losses equation is incorporated.
scalar alpha_w = 0.32 'this is the speed of adjustment back to the steady-state risk weight
scalar gamma = 14.1 'this is the multiplier for the amount that risk weights increase due to losses
scalar tao_alpha_e = -0.0032 'Interpreted as after-tax net non-interest income share of assets. Calibrated such that the model broadly matches 5-year capital shortfall in APRA stress tests.

series tao_tax = 0.7 ' One minus corporate tax rate.

scalar alpha_L = 1.1 ' Micro-simulation loss multiplier such that modelled losses are broadly consistent with APRA stress tests.

scalar psi_d = 10 ' Response of debt funding costs to capital shortfall


' Define parameters required for housing price stochastic trend as scalars
scalar psi_ph = -eq_ph.@coef(1)/eq_ph.@coef(2)

smpl {endsetdate} {endsetdate}
scalar ph_lr_ch = pi_target/400
smpl @all

'======================================================================================

' 2) Debt funding cost equation
'======================================================================================

scalar sum_phi_d = 0.5 ' Maximum share of deposits with a zero lower bound (equals sum of the deposit bucket weights)

' Spread on debt funding sources without lower bound is a random walk
{modelname}.append ndr_sp = ndr_sp(-1)

' Deposit rate lower bound
scalar ndr_elb = 0.05

'Debt funding cost equation
{modelname}.append bucket_max = 0.02*@pmax( ( 1 - 1 )/4 - 1.5 + ncr,ndr_elb) + 0.02*@pmax( ( 2 - 1 )/4 - 1.5 + ncr,ndr_elb) + 0.06*@pmax( ( 3 - 1 )/4 - 1.5 + ncr,ndr_elb) + 0.07*@pmax( ( 4 - 1 )/4 - 1.5 + ncr,ndr_elb) + 0.03*@pmax( ( 5 - 1 )/4 - 1.5 + ncr,ndr_elb) + 0.04*@pmax( ( 6 - 1 )/4 - 1.5 + ncr,ndr_elb) + 0.06*@pmax( ( 7 - 1 )/4 - 1.5 + ncr,ndr_elb) + 0.06*@pmax( ( 8 - 1 )/4 - 1.5 + ncr,ndr_elb) + 0.07*@pmax( ( 9 - 1 )/4 - 1.5 + ncr,ndr_elb) + 0.07*@pmax( ( 10 - 1 )/4 - 1.5 + ncr,ndr_elb) 

series bucket_max = 0.02*@pmax( ( 1 - 1 )/4 - 1.5 + ncr,ndr_elb) + 0.02*@pmax( ( 2 - 1 )/4 - 1.5 + ncr,ndr_elb) + 0.06*@pmax( ( 3 - 1 )/4 - 1.5 + ncr,ndr_elb) + 0.07*@pmax( ( 4 - 1 )/4 - 1.5 + ncr,ndr_elb) + 0.03*@pmax( ( 5 - 1 )/4 - 1.5 + ncr,ndr_elb) + 0.04*@pmax( ( 6 - 1 )/4 - 1.5 + ncr,ndr_elb) + 0.06*@pmax( ( 7 - 1 )/4 - 1.5 + ncr,ndr_elb) + 0.06*@pmax( ( 8 - 1 )/4 - 1.5 + ncr,ndr_elb) + 0.07*@pmax( ( 9 - 1 )/4 - 1.5 + ncr,ndr_elb) + 0.07*@pmax( ( 10 - 1 )/4 - 1.5 + ncr,ndr_elb) 

if !bankon=1 then 
{modelname}.append ndr = ( 1 - 0.65 * sum_phi_d ) * ( ndr_sp + ncr ) + 0.65 * bucket_max + psi_d*z(-1)
else
' How debt funding costs evolve when the banking sector is turned off (i.e. no deposit lower bound or risk premium changes)
{modelname}.append ndr = (0.675 * ndr_sp) - 0.0585 + ncr
endif

' 3) Losses equations
'======================================================================================

' Housing price gap
' MARTIN log housing price cointegrating relationship
{modelname}.append log(ph_cross) = psi_ph + log(prt) + eq_ph.@coef(3) * rmr

' Assign zero housing price gap at user-defined date
smpl {endsetdate} {endsetdate}
series log(ph_cross) = log(ph)
smpl @all

{modelname}.append log(ph_star) = log(ph_star(-1)) + -0.024 * ( log(ph_star(-1)) - log(ph_cross(-1)) ) + ph_lr_ch 

' Assign zero housing price gap at user-defined date
smpl {endsetdate} {endsetdate}
series log(ph_star) = log(ph)
smpl @all

'generate series and equation since no real-world data
{modelname}.append log(ph_hat) = log(ph) - log(ph_star)
series log(ph_hat) = log(ph) - log(ph_star) 

''''''''''
' Mortgage rate effect on losses

if !loantype = 0 then

' all loans
{modelname}.append nmr_ba_hat = nmr_ba - (rstar + pi_e + nmr_sp_ba+0.675*ndr_sp-0.0585)
series nmr_ba_hat = nmr_ba - (rstar + pi_e + nmr_sp_ba+0.675*ndr_sp-0.0585)

else

' new loans only
{modelname}.append nmr_ba_hat = (nmr_sp_ba) + ndr - ( rstar + pi_e + nmr_sp_ba +0.675*ndr_sp-0.0585 ) 
series nmr_ba_hat = (nmr_sp_ba) + ndr - ( rstar + pi_e + nmr_sp_ba + 0.675*ndr_sp-0.0585 ) 

endif

' ==================================================
''' Loss function
' ==================================================

' log(loss_h_star) equation
{modelname}.append log(loss_h_star) = alpha_L + -4.4 + (0.031718*((lurgap(-1))^1)) + (0.0021333*((lurgap(-1))^2)) + (-0.0001718*((lurgap(-1))^3)) + (0.12899*((nmr_ba_hat(-1))^1)) + (-0.00282522*((nmr_ba_hat(-1))^1)*((lurgap(-1))^1)) + (-0.000036678*((nmr_ba_hat(-1))^1)*((lurgap(-1))^2)) + (-0.0057204*((nmr_ba_hat(-1))^2)) + (0.000077577*((nmr_ba_hat(-1))^2)*((lurgap(-1))^1)) + (0.00019305*((nmr_ba_hat(-1))^3)) + (6.4921*(exp((log(ph_hat(-1))*1)))) + (-0.036611*(exp((log(ph_hat(-1))*1)))*((lurgap(-1))^1)) + (0.00072769*(exp((log(ph_hat(-1))*1)))*((lurgap(-1))^2)) + (0.11112*(exp((log(ph_hat(-1))*1)))*((nmr_ba_hat(-1))^1)) + (0.00095606*(exp((log(ph_hat(-1))*1)))*((nmr_ba_hat(-1))^1)*((lurgap(-1))^1)) + (0.0041623*(exp((log(ph_hat(-1))*1)))*((nmr_ba_hat(-1))^2)) + (-14.264*(exp((log(ph_hat(-1))*2)))) + (0.044*(exp((log(ph_hat(-1))*2)))*((lurgap(-1))^1)) + (-0.15181*(exp((log(ph_hat(-1))*2)))*((nmr_ba_hat(-1))^1)) + (6.1094*(exp((log(ph_hat(-1))*3))))

series log(loss_h_star) = alpha_L + -4.4 + (0.031718*((lurgap(-1))^1)) + (0.0021333*((lurgap(-1))^2)) + (-0.0001718*((lurgap(-1))^3)) + (0.12899*((nmr_ba_hat(-1))^1)) + (-0.00282522*((nmr_ba_hat(-1))^1)*((lurgap(-1))^1)) + (-0.000036678*((nmr_ba_hat(-1))^1)*((lurgap(-1))^2)) + (-0.0057204*((nmr_ba_hat(-1))^2)) + (0.000077577*((nmr_ba_hat(-1))^2)*((lurgap(-1))^1)) + (0.00019305*((nmr_ba_hat(-1))^3)) + (6.4921*(exp((log(ph_hat(-1))*1)))) + (-0.036611*(exp((log(ph_hat(-1))*1)))*((lurgap(-1))^1)) + (0.00072769*(exp((log(ph_hat(-1))*1)))*((lurgap(-1))^2)) + (0.11112*(exp((log(ph_hat(-1))*1)))*((nmr_ba_hat(-1))^1)) + (0.00095606*(exp((log(ph_hat(-1))*1)))*((nmr_ba_hat(-1))^1)*((lurgap(-1))^1)) + (0.0041623*(exp((log(ph_hat(-1))*1)))*((nmr_ba_hat(-1))^2)) + (-14.264*(exp((log(ph_hat(-1))*2)))) + (0.044*(exp((log(ph_hat(-1))*2)))*((lurgap(-1))^1)) + (-0.15181*(exp((log(ph_hat(-1))*2)))*((nmr_ba_hat(-1))^1)) + (6.1094*(exp((log(ph_hat(-1))*3))))

{modelname}.append loss_h = alpha_h + @pmax( loss_h_star - loss_h_star(-1) , 0 )

' Sets business loan losses equal to household loan losses (until business loan losses equation is constructed)
series loss_b = loss_h

' Total loan losses equation
series loss_t = theta_h*loss_h + (1-theta_h)*loss_b

{modelname}.append loss_b = loss_h
{modelname}.append loss_t = theta_h * loss_h + ( 1 - theta_h ) * loss_b
'======================================================================================

' 4) Risk weight
'======================================================================================
{modelname}.append rw = rw_ss + ( 1 - alpha_w ) * ( rw(-1) - rw_ss ) + gamma * ( loss_t - loss_ss ) * rw(-1)
'======================================================================================

' 5) Return on assets
'======================================================================================

'sets an initial value for the variable z
smpl {startsetdate} {endsetdate}
series z = 0

' Set initial value for variable T*
series t_star = 0
 smpl @all

' Dummy to determine when banks are unable to raise equity externally (1 = unable, 0 = able)
series I_dum = 0 'sets the series to be equal to 0 in the past

{modelname}.append t_dash = T * @sign(z(-1)) * ( 1 - @sign(z(-2)) )
series t_dash = T * @sign(z(-1)) * ( 1 - @sign(z(-2)) )

{modelname}.append t_star = @pmax(t_dash,t_star(-1) - 1 ) 

{modelname}.append I_dum = @pmin(t_star,1)
series I_dum = @pmin(t_star,1)

smpl @all

' Change in capital adequacy ratio when banks are unable to access external equity markets
{modelname}.append prof_s = (tao_alpha_e+((tao_tax-(400*rw*cap*beta_m))/400)*(theta_h*(nmr_sp_ba)+(1-theta_h)*(nbr_sp_ba))+((tao_tax*rw(-1)-400*rw*beta_m)/400)*cap*ndr-tao_tax*loss_t-(rw*cap*BX_m)-cap*(rw-rw(-1) ) )*(1/rw)

' Change in capital adequacy ratio when banks can access external equity markets
{modelname}.append prof_N = (1 / rw) * (tao_alpha_e + (tao_tax / 400) * (theta_h * (nmr_sp_ba)+(1-theta_h)*(nbr_sp_ba)) + (tao_tax/400) * rw(-1) * cap * ndr - tao_tax * loss_t - cap*(rw-rw(-1)))

'Porfitability per asset depending on constrained state
{modelname}.append prof = I_dum * prof_s + (1 - I_dum) * prof_N

'======================================================================================
' 6) Capital ratio
'======================================================================================
{modelname}.append z = @pmax(cap_ss-prof-cap,0)

{modelname}.append cap = cap_ss - ( 1 - lambda_l ) * z(-1)

'======================================================================================
' 7) Lending rates
'======================================================================================

' Mortgage rate spread is random walk
smpl 1993Q1 {edest}
c=0
equation eq_nmr_sp_ba.ls(cov=white) nmr_sp_ba = c(1)*nmr_sp_ba(-1)
scalar nmr_sp_ba_se = eq_nmr_sp_ba.@se

{modelname}.append nmr_sp_ba = nmr_sp_ba(-1) 
{modelname}.innov nmr_sp_ba {nmr_sp_ba_se}

' Business rate spread is random walk
smpl 1993Q1 {edest}
c=0
equation eq_nbr_sp_ba.ls(cov=white) nbr_sp_ba = c(1)*nbr_sp_ba(-1)
scalar nbr_sp_ba_se = eq_nbr_sp_ba.@se

{modelname}.append nbr_sp_ba = nbr_sp_ba(-1) 
{modelname}.innov nbr_sp_ba {nbr_sp_ba_se}

' Function to determine lending rates
if !loantype = 0 then

' All loans
{modelname}.append nmr_ba = nmr_sp_ba + ndr + (400 * lambda_l * rw * z)/(tao_tax-400*rw*cap*beta_m)
{modelname}.append nbr_ba = nbr_sp_ba + ndr + (400 * lambda_l * rw * z)/(tao_tax-400*rw*cap*beta_m)

else

' New loans only
{modelname}.append nmr_ba = nmr_sp_ba  + ndr + ( (-lambda_l*z) / (beta_m * cap) )
{modelname}.append nbr_ba = nbr_sp_ba + ndr +  ( (-lambda_l*z) / (beta_m * cap) )

endif

'======================================================================================


