/*******************************************************************************

	9_regressions.do
	
	This program runs the regressions using the preferred local labour markets
	
	Last edited: 19 August 2021 

*******************************************************************************/	

clear 

cd "$dir_out"

use master_c_pr980_11c, clear

/*******************************************************************************
	1 - Table 1: Linear Model
*******************************************************************************/

* A) no time effects

qui xtabond2 ws_gr L1_ws_gr urate [weight=wgt] if ws_no>=100, gmm(L1_ws_gr, equation(diff)) iv(urate, equation(diff)) robust
estimates store A

* B) time effects

qui xtabond2 ws_gr L1_ws_gr urate i.finyear [weight=wgt] if ws_no>=100, gmm(L1_ws_gr, equation(diff)) iv(urate i.finyear, equation(diff)) robust
estimates store B

* C) region-specific time trends

qui xtabond2 ws_gr L1_ws_gr urate i.finyear c.finyear#i.llm [weight=wgt] if ws_no>=100, gmm(L1_ws_gr, equation(diff)) iv(urate i.finyear c.finyear#i.llm, equation(diff)) robust
estimates store C

* D) allow for change in slope after 2012

gen post2012 = finyear>=2012
gen double urate_post2012    = urate*post2012

qui xtabond2 ws_gr L1_ws_gr urate urate_post2012 i.finyear [weight=wgt] if ws_no>=100, gmm(L1_ws_gr, equation(diff)) iv(urate urate_post2012 i.finyear, equation(diff)) robust
estimates store D

* Table 1:

estout A B C D, cells(b(star fmt(3)) se(par fmt(3))) legend label varlabels(_cons constant) stats(N , fmt(0)) starlevels(* 0.10 ** 0.05 *** 0.01) noomitted keep(urate urate_post2012 L1_ws_gr)  order(urate L1_ws_gr urate_post2012)

/*******************************************************************************
	2 - Table 2: Kinked Models
*******************************************************************************/

* Linear spline (B)

qui xtabond2 ws_gr L1_ws_gr urate1 urate2 i.finyear [weight=wgt] if ws_no>=100, gmm(L1_ws_gr, equation(diff)) iv(urate1 urate2 i.finyear, equation(diff)) robust
estimates store B1

test (urate1 + urate2 = 0)

* Cubic spline (B)

qui xtabond2 ws_gr L1_ws_gr urate1 spline2 i.finyear [weight=wgt] if ws_no>=100, gmm(L1_ws_gr, equation(diff)) iv(urate1 spline2 i.finyear, equation(diff)) robust
estimates store B2

* Linear spline (C)

qui xtabond2 ws_gr L1_ws_gr urate1 urate2 i.finyear c.finyear#i.llm [weight=wgt] if ws_no>=100, gmm(L1_ws_gr, equation(diff)) iv(urate1 urate2 i.finyear c.finyear#i.llm, equation(diff)) robust
estimates store C1

* Cubic spline (C)

qui xtabond2 ws_gr L1_ws_gr urate1 spline2 i.finyear c.finyear#i.llm [weight=wgt] if ws_no>=100, gmm(L1_ws_gr, equation(diff)) iv(urate1 spline2 i.finyear c.finyear#i.llm, equation(diff)) robust
estimates store C2

* Linear spline (D)

foreach i in urate1 urate2 spline2 {
gen double `i'_post2012    = `i'*post2012
}

qui xtabond2 ws_gr L1_ws_gr urate1 urate2 urate1_post2012 urate2_post2012 i.finyear [weight=wgt] if ws_no>=100, gmm(L1_ws_gr, equation(diff)) iv(urate1 urate2 urate1_post2012 urate2_post2012 i.finyear, equation(diff)) robust
estimates store D1

* Cubic spline (D)

qui xtabond2 ws_gr L1_ws_gr urate1 spline2 urate1_post2012 spline2_post2012 i.finyear [weight=wgt] if ws_no>=100, gmm(L1_ws_gr, equation(diff)) iv(urate1 spline2 urate1_post2012 spline2_post201 i.finyear, equation(diff)) robust
estimates store D2

* Table 2:

estout  B1 C1 D1 B2 C2 D2, cells(b(star fmt(3)) se(par fmt(3))) legend label varlabels(_cons constant) stats(r2 r2_a r2_within r2_a_within N , fmt(2 2 2 2 0)) starlevels(* 0.10 ** 0.05 *** 0.01) noomitted keep(urate1 urate2 spline2 L1_ws_gr urate1_post2012 urate2_post2012 spline2_post2012)  order(urate1 urate2 spline2 L1_ws_gr urate1_post2012 urate2_post2012 spline2_post2012)


/*******************************************************************************
	3 - Figure 7: Linear spline with 3 kinks
*******************************************************************************/

xtabond2 ws_gr L1_ws_gr u1 u2 u3 u4 i.finyear [weight=wgt] if ws_no>=100, gmm(L1_ws_gr, equation(diff)) iv(u1 u2 u3 u4 i.finyear, equation(diff)) robust

* Tests of null that PC is flat within each unemployment range 

test (u1 + u2 = 0)
test (u1 + u2 + u3 = 0)
test (u1 + u2 + u3 + u4 = 0)

* Generate Figure 7

margins, at(finyear==2016 L1_ws_gr==0) over(urate_100) vsquish post
matrix full_sample = r(table)'

preserve

clear
svmat2 full_sample, names(col) rnames(urate)

keep b ll ul urate

drop if  strpos(urate, "bn.urat") 
replace  urate = subinstr(urate, ".urate_100", "",.) 
destring urate, replace

tsset  urate
tsfill
foreach i in b ll ul {
ipolate `i' urate, generate(`i'_ipolate)
drop `i'
rename `i'_ipolate `i'
}

drop if urate<100

replace  urate = urate/10
keep if mod(urate ,1)==0
replace  urate = urate/10

* shift the curve vertically such that wages growth = 2.2% when u/e = 4.5% 

qui sum b if urate>=4.495 & urate<=4.505 
gen scaling = 2.2-r(mean)
foreach i in b ll ul {
replace `i' = `i'+scaling
}

drop scaling

export excel using Fig_data.xlsx, sheet(Fig_7, replace) firstrow(variables) 

restore

/*******************************************************************************
	4 - Figure 8: Restricted cubic spline with 3 kinks
*******************************************************************************/

xtabond2 ws_gr L1_ws_gr urate1 spline2 i.finyear [weight=wgt] if ws_no>=100, gmm(L1_ws_gr, equation(diff)) iv(urate1 spline2 i.finyear, equation(diff)) robust

margins, at(finyear==2016 L1_ws_gr==0) over(urate_100) vsquish post
matrix full_sample = r(table)'

clear
svmat2 full_sample, names(col) rnames(urate)

keep b ll ul urate

drop if  strpos(urate, "bn.urat") 
replace  urate = subinstr(urate, ".urate_100", "",.) 
destring urate, replace

tsset  urate
tsfill
foreach i in b ll ul {
ipolate `i' urate, generate(`i'_ipolate)
drop `i'
rename `i'_ipolate `i'
}

drop if urate<100

replace  urate = urate/10
keep if mod(urate ,1)==0
replace  urate = urate/10

* shift the curve vertically such that wages growth = 2.2% when u/e = 4.5% 

qui sum b if urate>=4.495 & urate<=4.505 
gen scaling = 2.2-r(mean)
foreach i in b ll ul {
replace `i' = `i'+scaling
}

export excel using Fig_data.xlsx, sheet(Fig_8, replace) firstrow(variables)  

clear

/*******************************************************************************
	5 - Table C1
*******************************************************************************/

* Create matrix to hold the fraction of region-year observations with unemployment ≤4%

matrix low_u = J(7,1,.)
matrix colnames low_u = below45
matrix rownames low_u = pr980 pr980_16 sa4 ferco ferpc gccsa state

* loop over the different geographic classifications

local k = 1 

foreach clus in pr980_11c pr980_16c sa4_16c ferco_11c ferpc_11c gccsa_16c state_16c  {

use master_c_`clus', clear

* estimate linear spline with single kink at 4%

qui xtabond2 ws_gr L1_ws_gr urate1 urate2 i.finyear [weight=wgt] if ws_no>=100, gmm(L1_ws_gr, equation(diff)) iv(urate1 urate2 i.finyear, equation(diff)) robust
estimates store `clus'

* (weighted) share of sample with urate ≤4%

gen samp=e(sample)

gen below_4 = urate<=4 if samp==1 

qui sum below_4 [weight=wgt]

matrix low_u[`k',1] =r(mean)

local k = `k'+1
}

* Table C1

estout pr980_11c pr980_16c sa4_16c ferco_11c ferpc_11c gccsa_16c state_16c, cells(b(star fmt(3)) se(par fmt(3))) legend label mlabel(pr980 pr980_16 sa4 ferco ferpc gccsa state) varlabels(_cons constant) stats(N , fmt(0)) starlevels(* 0.10 ** 0.05 *** 0.01) noomitted keep(urate1 urate2 L1_ws_gr)  order(urate1 urate2 L1_ws_gr)

disp "fraction of region-year observations with unemployment ≤4%"
matlist low_u, format(%5.2g)


/*******************************************************************************
	6 - Robustness to composition effects (comparison to WPI at state level)
*******************************************************************************/

use    master_c_state_16c, clear

merge 1:1 llm finyear using wpi_state , nogen

sort llm finyear

* estimate over common sample

gen mis = ws_gr==. | wpi_gr==. 

drop L1_ws_gr

foreach i in ws wpi {
    replace `i'_gr=. if mis==1
	gen double L1_`i'_gr = L1.`i'_gr
}

* Linear specification

foreach i in ws wpi {
    xtabond2 `i'_gr  L1_`i'_gr urate i.finyear [weight=wgt] if ws_no>=100, gmm(L1_`i'_gr , equation(diff)) iv(urate i.finyear, equation(diff)) robust
}

* Single kink at 4%

foreach i in ws wpi  {
    xtabond2 `i'_gr  L1_`i'_gr urate1 urate2 i.finyear [weight=wgt] if ws_no>=100, gmm(L1_`i'_gr , equation(diff)) iv(urate1 urate2 i.finyear, equation(diff)) robust
}

/*******************************************************************************
	7 - Table 3
*******************************************************************************/

use master_c_pr980_11c, clear

gen double durate1  = urate1  - L1.urate1 
gen double durate2  = urate2  - L1.urate2 
gen double dspline2 = spline2 - L1.spline2 

* Linear baseline

qui xtabond2 ws_gr L1_ws_gr urate1 i.finyear [weight=wgt] if ws_no>=100, gmm(L1_ws_gr, equation(diff)) iv(urate1 i.finyear, equation(diff)) robust
estimates store L_base

* linear speed limit

qui xtabond2 ws_gr L1_ws_gr urate1 durate1 i.finyear [weight=wgt] if ws_no>=100, gmm(L1_ws_gr, equation(diff)) iv(urate1 durate1 i.finyear, equation(diff)) robust
estimates store L_speed

* cubic spline baseline

qui xtabond2 ws_gr L1_ws_gr urate1 spline2 i.finyear [weight=wgt] if ws_no>=100, gmm(L1_ws_gr, equation(diff)) iv(urate1 spline2 i.finyear, equation(diff)) robust
estimates store C_base

* cubic spline speed limit

qui xtabond2 ws_gr L1_ws_gr urate1 spline2 durate1 dspline2 i.finyear [weight=wgt] if ws_no>=100, gmm(L1_ws_gr, equation(diff)) iv(urate1 spline2 durate1 dspline2  i.finyear, equation(diff)) robust
estimates store C_speed

* Table 3:

estout L_base L_speed C_base C_speed, cells(b(star fmt(3)) se(par fmt(3))) legend label varlabels(_cons constant) stats(r2 r2_a r2_within r2_a_within N , fmt(2 2 2 2 0)) starlevels(* 0.10 ** 0.05 *** 0.01) noomitted keep(urate1 durate1 spline2 dspline2 L1_ws_gr)  order(urate1 durate1 spline2 dspline2 L1_ws_gr)


/*******************************************************************************
	8 - Appendix D (persistence of unemployment fluctuations)
*******************************************************************************/

* Present discounted value of unemployment 

gen double Furate = urate*1 + (F1.urate)*(0.99) + (F2.urate)*(0.99^2) + (F3.urate)*(0.99^3) + (F4.urate)*(0.99^4) + (F5.urate)*(0.99^5)

* Hazell et al. specification

ivregress 2sls ws_gr i.finyear i.llm (Furate=L1.urate) [weight=wgt] if ws_no>=100, first cluster(llm)

/*******************************************************************************
	8 - Interaction with 'award share' proxy
*******************************************************************************/

use master_c_pr980_11c, clear

replace awdreliant = awdreliant*100

sum awdreliant, detail

gen double awdreliant_urate = awdreliant*urate

xtabond2 ws_gr L1_ws_gr urate awdreliant_urate i.finyear [weight=wgt] if ws_no>=100, gmm(L1_ws_gr, equation(diff)) iv(urate awdreliant_urate i.finyear, equation(diff)) robust

* end of do file