/*******************************************************************************

	8_Figures_5and6.do
	
	This program generates the data for Figures 5 and 6.
	
	Last edited: 19 August 2021 

*******************************************************************************/	

clear 

cd "$dir_out"

/*******************************************************************************
	1 - Figure 5 
*******************************************************************************/	

* national unemployment rate, seasonally adjusted, LFS

import excel "$dir_in\6202001.xls", sheet(Data1) cellrange(A11:BN526) clear

keep A BN

rename (A BN) (date urate_sa)

gen surveyq=yq(year(date),quarter(date))

format surveyq %tq

* convert from monthly to quarterly frequency

collapse (mean) urate_sa, by(surveyq)

keep if surveyq>=tq(1998q3) & surveyq<=tq(2018q2)

twoway__histogram_gen urate_sa, generate(density_ag bin_centre) start(0) width(1)

replace bin_centre = 12.5 if bin_centre>=12.5

collapse (sum) density_ag, by(bin_centre)

replace density_ag = density_ag*100

save density_ag, replace

* Local labour markets

use master_c_pr980_11c, clear

twoway__histogram_gen urate [fweight=wgt] if finyear>=1999 & finyear<=2018, generate(density_llm bin_centre) start(0) width(1)

keep bin_centre density_llm

replace bin_centre = 12.5 if bin_centre>=12.5

collapse (sum) density_llm, by(bin_centre)

replace density_llm = density_llm*100

merge 1:1 bin_centre using density_ag, nogen

erase density_ag.dta

drop if bin_centre==0

replace density_llm=0 if density_llm==.
replace density_ag =0 if density_ag ==.

gen bin_low  = bin_centre-0.5
gen bin_high = bin_centre+0.5

tostring bin_low bin_high, replace

gen bin_range = bin_low + "-" + bin_high

keep  bin_range density_llm density_ag
order bin_range density_llm density_ag

replace bin_range="12+" if bin_range=="12-13"

export excel using Fig_data.xlsx, sheet(Fig_5)  firstrow(variables) replace

/*******************************************************************************
	2 - Figure 6
*******************************************************************************/	

use master_c_pr980_11c, clear

keep if finyear>=1999 & finyear<=2018 & urate!=. & ws_gr!=. 

* Discretise unemployment rate in bins of 0.1ppts and bottom code at 1 per cent

egen urate_ = cut(urate), at(0(0.1)10)

drop if urate_==.

replace urate_=1 if urate<=1

collapse (mean) ws_gr (sum) wgt, by(urate_)

* Split observations into quantiles of the wgt distribution 
* (determines the 'bubble' size on the Figure)

xtile wgtq = wgt, nquantiles(4)  

tabstat wgt, by(wgtq)

drop wgt

reshape wide ws_gr, i(urate_) j(wgtq)

replace urate_=round(urate_, 0.1)

export excel using Fig_data.xlsx, sheet(Fig_6, replace) firstrow(variables) 

* end of do file