/*******************************************************************************

	4_award_share.do
	
	This program constructs the proxy for 'award share' at the SA2 level (Section 7.2.1)

	Last edited: 19 August 2021 

*******************************************************************************/	

clear 

cd "$dir_out"

/*******************************************************************************
	1 - Share of non-managerial employees paid by Award only, by industry
		*Source: https://www.abs.gov.au/articles/guide-understanding-employee-earnings-and-hours-statistics, Table 1
		*2012, 2014, 2016 and 2018
*******************************************************************************/	

import delimited "$dir_in\EEH.csv", clear

keep v1-v5

keep if _n>=12 & _n<=29

forvalues i=2(1)5 {
	replace v`i' = subinstr(v`i', "%", "",.) 
    destring v`i', replace
	replace  v`i'= v`i'/100
}

* Calculate average share across 2012, 2014, 2016 and 2018

egen awd = rowmean(v2-v5)

gen ind = "_" + lower(substr(v1, 1, 3))

keep ind awd

gen i=1

reshape wide awd, j(ind) i(i) string

* for agriculture, use mean of all other industries 

egen awd_agr = rowmean(awd*)

save awd_share, replace

/*******************************************************************************
	2 - Census industry shares by SA2
		*Source: ABS 2016 Census timeseries profile, Table 34
*******************************************************************************/	

import delimited "$dir_in\2016Census_T34_AUS_SA2.csv", clear

drop *_m *_f

rename *_p *
rename *_cen *
rename *_cens *

reshape long ag_forest_fish_c mining_c manuf_c ele_gas_wat_was_ser_ constr_c whlesale_tde_c retail_tde_c accom_food_s_c tpt_post_ware_c inf_medi_tele_c finan_insu_s_c rent_hir_re_est_s_ prof_scie_tech_s_ admin_supp_s_c pub_admin_safet_c educ_trn_c hea_car_soc_assist_ arts_rec_s_c oth_services_c inad_descr_ns_c tot_c, i(sa2_maincode_2016) j(year) string

destring year, replace
replace  year = year + 2000

keep if year==2011 | year==2016

rename *_c *
rename *_ *

foreach v of var * {
	local new = substr("`v'", 1, 3)
	rename `v' `new'
}

rename (sa2 yea ag_) (sa2_2016 year agr)

sort  sa2_2016 year

drop ina tot

* Calculate average industry shares across 2011 and 2016

egen    tot = rowtotal(agr-oth)

foreach var of varlist agr-oth {

replace `var'=`var' / tot

}

collapse (mean) agr-oth, by(sa2_2016)

gen i=1

merge m:1 i using awd_share

drop i

rename (whl tpt) (who tra)

foreach i in agr min man ele con who ret acc tra inf fin ren pro adm pub edu hea art oth {
    
	gen double `i'_cont = awd_`i' * `i'

}

egen double awdreliant= rowtotal(*_cont), missing

keep sa2_2016 awdreliant

save awd_share, replace

clear

*end of do file