/*******************************************************************************

	1_geography.do
	
	This program compiles the geographic classifications, boundaries and correspondences 

	Last edited: 19 August 2021 

*******************************************************************************/	

clear

/*******************************************************************************
	1 - Convert ABS shapefiles to Stata format (2011 and 2016 ASGS)
*******************************************************************************/	

cd "$dir_in"

foreach y in 2011 2016 {

unzipfile `y'_SA2_shape.zip

spshape2dta SA2_`y'_AUST, replace

use   SA2_`y'_AUST, clear
save  "$dir_out\SA2_`y'_AUST", replace

use   SA2_`y'_AUST_shp, clear
save  "$dir_out\SA2_`y'_AUST_shp", replace

foreach i in dbf prj shp shx dta {
erase SA2_`y'_AUST.`i'
}
erase SA2_`y'_AUST_shp.dta
}
erase "Metadata for Digital Boundary Files ABS Structure.pdf"
erase SA2_2016_AUST.cpg
erase 2016_asgs_metadata.md

/*******************************************************************************
	2 - Convert geographic correspondences to Stata format
*******************************************************************************/	

cd "$dir_out"

* SA2 (ASGS 2011) to SA2 (ASGS 2016)

forvalues i=3(1)5 {
import excel using "$dir_in\CG_SA2_2011_SA2_2016.xls", sheet(Table `i') cellrange(A8) clear
rename A sa2_2011
rename C sa2_2016
rename E ratio_2011_2016
keep sa2_2011 sa2_2016 ratio_2011_2016
save T`i', replace
}
clear
forvalues i=3(1)5 {
append using T`i'
erase T`i'.dta
}
drop if real(sa2_2011)==. & sa2_2016==.
destring sa2_2011, replace

format sa2_2011  %12.0g
format sa2_2016  %12.0g

sort sa2_2011 sa2_2016

save sa2_2011_2016, replace
clear

* Create a duplicate of the ASGS 2011 to ASGS 2016 correspondence for each financial year 

forvalues i = 1996(1)2012 {
	use  sa2_2011_2016, clear
	gen  finyear=`i'
	save sa2_2011_2016_`i', replace
	clear
	} 
clear
forvalues i = 1996(1)2012 {
	append using sa2_2011_2016_`i'
	erase sa2_2011_2016_`i'.dta
	}

save sa2_2011_2016_finyear, replace

clear

* SLA to SA2 (ASGS 2011)
   
foreach i in 1996 2001 2002 2003 2004 2005 2006 2008 {

import excel "$dir_in\CG_SLA_`i'_SA2_2011.xlsx", clear sheet("Table 3") cellrange(A6) firstrow

keep *CODE* SA2_MAINCODE_2011 RATIO

drop if SA2_MAINCODE_2011==.

compress 

rename *, lower
rename sla_*code_`i' sla_code_`i'

replace sla_code_`i' = substr(sla_code_`i',1,1)+substr(sla_code_`i',-4,.)

save CG_SLA_`i'_SA2_2011, replace 
}


/*******************************************************************************
	3 - Convert SA2 descriptors to Stata format
*******************************************************************************/	

* ASGS 2011

import delimited using "$dir_in\SA2_2011_AUST.csv", clear

keep sa2_maincode_2011 gccsa_code_2011 state_code_2011

rename sa2_maincode_2011 sa2_2011

save sa2_descriptors_2011, replace

* ASGS 2016

import delimited using "$dir_in\SA2_2016_AUST.csv", clear

keep sa2_maincode_2016 gccsa_code_2016 state_code_2016

rename sa2_maincode_2016 sa2_2016

save sa2_descriptors_2016, replace

clear

* end of do file