/*******************************************************************************

	0_master.do
	
	This program executes all other .do files in the correct order.

	Last edited: 19 August 2021

*******************************************************************************/	

* Install user-written ado files

foreach i in nearstat mat2txt estout xtabond2 svmat2 {
	ssc install `i'
}

clear all

* set directory e.g. "C:\Users\JamesB\Documents"
local directory "<add directory here>"

local  dir_do  "`directory'\rdp-2021-09-supplementary-information\programs"  
global dir_in  "`directory'\rdp-2021-09-supplementary-information\data"      
global dir_out "`directory'\rdp-2021-09-supplementary-information\output"    

* compile geographic classifications, boundaries and correspondences 
do "`dir_do'\1_geography.do"

* compile wages data
do "`dir_do'\2_wages.do"

* compile unemployment data
do "`dir_do'\3_unemp.do"

* construct proxy for 'award share'
do "`dir_do'\4_award_share.do"

* construct classifications of local labour markets
do "`dir_do'\5_labour_markets.do"

* create Appendex B, Table B1
do "`dir_do'\6_table_b1.do"

* combines the data into a 'master' file
do "`dir_do'\7_combined.do"

* generate the data for Figures 5 and 6
do "`dir_do'\8_figures_5and6.do"

* perform the regression analysis
do "`dir_do'\9_regressions.do"

clear all

* end of do file