** Appendix output
cd "<place directory here>\excel"
use "<place directory here>\data\long-file-cleaned.dta", clear

** Table A1

** Table A2
	
** Figure A1

	tempname figurea1
	postfile `figurea1' t coeff lower upper using figurea1.dta, replace
	forval x = 1(1)7 {
		qui xtreg firedprob fired`x' i.wave if head==1, fe cluster(xwaveid)
		post `figurea1' (4-`x') (`=_b[fired]') (`=_b[fired]'-`=_se[fired]'*1.96) (`=_se[fired]'*1.96+`=_b[fired]')
	}
	postclose `figurea1'
	
	preserve
	clear
	use "figurea1"
	twoway line  coeff lower upper t, title("Expectations before and after event") subtitle("years relative to unemployment")
	table t, c(mean coeff mean lower mean upper)
	sort t
	export excel using "figurea1", sheetreplace
	restore
	
** Figure B1

	tempname figureb1
	postfile `figureb1' t coeff lower upper using figureb1.dta, replace
		qui xtreg lnconsall unemp4 rpersons i.wave if l.head==1, fe cluster(xwaveid)
		post `figureb1' (1) (`=_b[unemp4]') (`=_b[unemp4]'-`=_se[unemp4]'*1.96) (`=_se[unemp4]'*1.96+`=_b[unemp4]')
		qui xtreg lnconsall unemp4 age rpersons i.wave if l.head==1, fe cluster(xwaveid)
		post `figureb1' (2) (`=_b[unemp4]') (`=_b[unemp4]'-`=_se[unemp4]'*1.96) (`=_se[unemp4]'*1.96+`=_b[unemp4]')
		qui xtreg lnconsall unemp4 age l.i.contract rpersons i.wave if l.head==1, fe cluster(xwaveid)
		post `figureb1' (3) (`=_b[unemp4]') (`=_b[unemp4]'-`=_se[unemp4]'*1.96) (`=_se[unemp4]'*1.96+`=_b[unemp4]')
		qui xtreg lnconsall unemp4 age l.i.contract rpersons uni i.wave if l.head==1, fe cluster(xwaveid)
		post `figureb1' (4) (`=_b[unemp4]') (`=_b[unemp4]'-`=_se[unemp4]'*1.96) (`=_se[unemp4]'*1.96+`=_b[unemp4]')
		qui xtreg lnconsall unemp4 age l.i.contract l.i.industry rpersons uni i.wave if l.head==1, fe cluster(xwaveid)
		post `figureb1' (5) (`=_b[unemp4]') (`=_b[unemp4]'-`=_se[unemp4]'*1.96) (`=_se[unemp4]'*1.96+`=_b[unemp4]')
	postclose `figureb1'

	preserve
	use "figureb1.dta", clear
	sort t
	foreach x in coeff lower upper {
		replace `x'=`x'*100	
	}
	table t, c(mean coeff mean lower mean upper)
	export excel using "figureb1", sheetreplace
	restore
	
** Table B1

	xtreg lngroci rpersons unemp##c.l.firedprob1 i.wave, fe cluster(xwaveid)
	outreg2 using tableb1, ctitle("Groceries") dec(2) excel replace
	xtreg aeatout rpersons unemp##c.l.firedprob1 i.wave, fe cluster(xwaveid)
	outreg2 using tableb1, ctitle("Meals eaten out") dec(2) excel append 
	xtreg lnconsall rpersons unemp##c.l.firedprob1 i.wave, fe cluster(xwaveid)
	outreg2 using tableb1, ctitle("Total Expenditure") dec(2)  excel append 