#' Scale Principal Component
#'
#' @param df Dataframe containing both the series you want to scale, and the series to scale it to
#' @param pc the column to be scaled (default = "PC1")
#' @param scale the column to scale `pc` to  (default = "ois_1m")
#'
#' @return returns `df` with an extra column called `pc`_scaled. 
#' @export
mp_surprise_scale <- function(df, pc = "PC1", scale = "ois_1m"){
  
  if (length(pc) != 1 | length(scale) != 1) {stop("Argument `pc` and `scale` must of a length 1.")}
  
  scale_reg  <- lm( as.formula(paste0(scale, "~ ",  pc  ) ), data = df )$coefficients
  
  scale_factors <- {df[pc]*scale_reg[pc]}  %>% set_names( stringr::str_to_lower( paste0(pc, "_scaled")))
  
  output <- bind_cols(df, scale_factors)
  
  return(output)
  
}
