################################################################################
# RDP: Financial Conditions and Downside Risk to Economic Activity in Australia
################################################################################
# Luke Hartigan, 08-03-2021
################################################################################

# Clear the workspace
graphics.off()
rm(list = ls(all = TRUE))
gc()
cat("\014")

rdp_name <- "Financial Conditions and Downside Risk to Economic Activity in Australia"

# What are we doing?
cat(sprintf("Replication files for RDP 2021-03: \n\'%s\'...\n\n", rdp_name))

# Transform data
source("Code/Transform_Data.R")
cat('\n')

# Determine some DFM estimation options
source("Code/Determine_DFM_Estimation_Options.R")
cat('\n')

# Log-likelihood test for lags in DFM
source("Code/DFM_Loglike_Ratio_Test.R")
cat('\n')

# Estimate the FCI
source("Code/Estimate_FCI.R")
cat('\n')

# Compare measures of activity and the FCI
source("Code/Activity_and_Financial_Conditions.R")
cat('\n')

# Growth-at-Risk analysis
source("Code/Growth_at_Risk.R")
cat('\n')

cat("...replication completed!\n\n")

# EOF
