clear
set more off
* (This file takes a few minutes to run)

local kolor gs10 // Set color for stata histograms

* Generating the baseline histogram data for the main and subsamples
********************************************************************
use "Data/Final/final_stars_supp", clear

* This first one is a central bank version that does not filter out the data-driven model selection or exploratory research
preserve

twoway__histogram_gen t_stat_sm if t_stat_sm < 20.0 & D_cb == 1, start(0) width(0.1) gen(obs_cb x) 
drop if x == .
keep x obs_cb 
save "Data/Temp/tmp1_cb", replace

restore

* These versions do filter out the data-driven model selection or exploratory research
foreach var of varlist D_noExpData_cb D_rba D_rbnz D_minn D_pub_cb D_noPub_cb D_eye_cb D_noEye_cb{

preserve

local a =  regexr("`var'","D_","")
display "`a'"
twoway__histogram_gen t_stat_sm if t_stat_sm < 20.0 & `var' == 1 & D_noExpData_cb == 1, start(0) width(0.1) gen(obs_`a' x)
drop if x == .
keep x obs_`a' 
save "Data/Temp/tmp1_`a'", replace

restore
}

* Now one for the controls
preserve

twoway__histogram_gen t_stat_sm if t_stat_sm < 20.0 & D_control == 1, start(0) width(0.1) gen(obs_control x) 
drop if x == .
keep x obs_control 
save "Data/Temp/tmp1_control", replace

restore

use "Data/Temp/tmp1_cb"
drop obs_cb
local files : dir "Data/Temp" files "tmp1_*"
foreach file in `files'{
merge 1:1 x using "Data/Temp/`file'"
drop _merge
erase "Data/Temp/`file'"
}

save tmp1, replace



* Generating the inputs data
****************************
use "Data/Final/final_stars_supp", clear
generate x = . //For this example need to generate all x's because will be used as a counterfactual distribution (one of the "inputs") later
forvalues i = 1(1)200{
capture : replace x = -0.05 + _n/10 if _n == `i'
}
kdens t_stat_sm if t_stat_sm < 20.0 & t_stat_sm > 0.0 & D_control == 1, kernel(epanechnikov) ll(0) ul(20.0) bw(0.4) gen(cSmooth) at(x) nograph
drop if x == .
keep x cSmooth
sort x
merge 1:1 x using tmp1, nogenerate
sort x
save tmp1, replace

foreach k in "wdi" "qog" "vhlss" "psid"{
use "Data/Source/inputs/simu_`k'", clear
twoway__histogram_gen t if t < 20.0, start(0) width(0.1) gen(`k' x)
drop if x == .
keep x `k'
merge 1:1 x using tmp1, nogenerate
save tmp1, replace
}

erase tmp1.dta

generate norm = (1-normal(x))*2
generate student_1 = (tden(1,x))*2
generate student_2 = (tden(2,x))*2
generate student_5 = (tden(5,x))*2
generate student_10 = (tden(10,x))*2
generate student_50 = (tden(50,x))*2
generate student_100 = (tden(100,x))*2

generate cauchy_2 = 2/_pi*2/(x^2+2^2)
generate cauchy_15 = 2/_pi*1.5/(x^2+1.5^2)
generate cauchy_05 = 2/_pi*0.5/(x^2+0.5^2)



* Label the variables so that you can automate legends
******************************************************
foreach var of varlist obs*{
label variable `var' "Observed freq."
}

*label variable norm "Normal"

label variable student_1 "Student(1)"
label variable student_2 "Student(2)"
label variable student_5 "Student(5)"
label variable student_10 "Student(10)"
label variable student_50 "Student(50)"
label variable student_100 "Student(100)"

label variable cauchy_2 "Cauchy(2)"
label variable cauchy_15 "Cauchy(1.5)"
label variable cauchy_05 "Cauchy(0.5)"

label variable cSmooth "Controls"

label variable wdi "WDI"
label variable qog "QOG"
label variable vhlss "VHLSS"
label variable psid "PSID"



foreach var of varlist obs*{

* Plotting the charts with student inputs
*****************************************
local a =  regexr("`var'","obs_","")
twoway bar `var' x if x < 10, barwidth(0.1) color($kolor) fintensity(inten100) || ///
line student_100 x if x < 10 & student_100 < 0.4, lcolor(lime) lwidth(medthick) || ///
line student_1 x if x < 10 & student_1 < 0.4, lcolor(magenta) lwidth(medthick) ///
ylabel(0(0.1)0.4, angle(0) nogrid) ///
ytitle("Density") xtitle("|z-score|") ///
xlabel(0 "0" 1.96 "1.96" 10 "10") ///
scale(1.5) ///
bgcolor("white") graphregion(color(white)) plotregion(margin(zero)) //
graph export "Figures\sm_dist_`a'_student.eps", replace
graph export "Figures\sm_dist_`a'_student.png", replace

twoway bar `var' x if inrange(x,5,20), barwidth(0.1) color($kolor) fintensity(inten100) || ///
line student_100 x if inrange(x,5,20), lcolor(lime) lwidth(medthick) || ///
line student_1 x if inrange(x,5,20), lcolor(magenta) lwidth(medthick) ///
ytitle("Density") xtitle("|z-score|") ///
xlabel(5 "5"  10 "10" 15 "15" 20 "20") ///
ylabel(0(0.01)0.05, angle(0) nogrid) ///
scale(1.5) ///
bgcolor("white") graphregion(color(white)) plotregion(margin(zero)) //
graph export "Figures\sm_dist_`a'_student_tail.eps", replace
graph export "Figures\sm_dist_`a'_student_tail.png", replace



* Plotting the charts with Cauchy inputs
****************************************
twoway bar `var' x if x < 10, barwidth(0.1) color($kolor) fintensity(inten100) || ///
line cauchy_2 x if x < 10 & cauchy_2 < 0.4, lcolor(blue) || ///
line cauchy_15 x if x < 10 & cauchy_15 < 0.4, lcolor(lime) || ///
line cauchy_05 x if x < 10 & cauchy_05 < 0.4, lcolor(magenta) ///
ylabel(0(0.1)0.4, angle(0) nogrid) ///
ytitle("Density") xtitle("|z-score|") ///
xlabel(0 "0" 1.96 "1.96" 10 "10") ///
scale(1.5) ///
bgcolor("white") graphregion(color(white)) plotregion(margin(zero)) //
graph export "Figures\sm_dist_`a'_cauchy.eps", replace
graph export "Figures\sm_dist_`a'_cauchy.png", replace

twoway bar `var' x if inrange(x,5,20), barwidth(0.1) color($kolor) fintensity(inten100) || ///
line cauchy_2 x if inrange(x,5,20), lcolor(blue) lwidth(medthick)  || ///
line cauchy_15 x if inrange(x,5,20), lcolor(lime) lwidth(medthick) || ///
line cauchy_05 x if inrange(x,5,20), lcolor(magenta) lwidth(medthick) ///
ytitle("Density") xtitle("|z-score|") ///
xlabel(5 "5"  10 "10" 15 "15" 20 "20") ///
ylabel(0(0.01)0.05, angle(0) nogrid) ///
scale(1.5) ///
bgcolor("white") graphregion(color(white)) plotregion(margin(zero)) //
graph export "Figures\sm_dist_`a'_cauchy_tail.eps", replace
graph export "Figures\sm_dist_`a'_cauchy_tail.png", replace


* Plotting the charts with control input
****************************************
twoway bar `var' x if x < 10, barwidth(0.1) color($kolor) fintensity(inten100) || ///
line cSmooth x if x < 10, lcolor(black) lwidth(medthick) || ///
, legend(rows(2)) ///
ylabel(0(0.1)0.4, angle(0) nogrid) ///
ytitle("Density") xtitle("|z-score|") ///
xlabel(0 "0" 1.96 "1.96" 10 "10") ///
scale(1.5) ///
bgcolor("white") graphregion(color(white)) plotregion(margin(zero)) //
graph export "Figures\sm_dist_`a'_control.eps", replace
graph export "Figures\sm_dist_`a'_control.png", replace

twoway bar `var' x if inrange(x,5,20), barwidth(0.1) color($kolor) fintensity(inten100) || ///
line cSmooth x if inrange(x,5,20), lcolor(black) lwidth(medthick) || ///
, legend(rows(2)) ///
ytitle("Density") xtitle("|z-score|") ///
xlabel(5 "5"  10 "10" 15 "15" 20 "20") ///
ylabel(0(0.01)0.05, angle(0) nogrid) ///
scale(1.5) ///
bgcolor("white") graphregion(color(white)) plotregion(margin(zero)) //
graph export "Figures\sm_dist_`a'_control_tail.eps", replace
graph export "Figures\sm_dist_`a'_control_tail.png", replace


* Plotting the charts with empirical inputs
*******************************************
twoway bar `var' x if x < 10, barwidth(0.1) color($kolor) fintensity(inten100) || ///
line wdi x if x < 10 & wdi < 0.4, lcolor(blue) || ///
line vhlss x if x < 10 & vhlss < 0.4, lcolor(lime) || ///
line psid x if x < 10 & psid < 0.4, lcolor(magenta) || ///
line qog x if x < 10 & qog < 0.4, lcolor(cyan) ///
ylabel(0(0.1)0.4, angle(0) nogrid) ///
ytitle("Density") xtitle("|z-score|") ///
xlabel(0 "0" 1.96 "1.96" 10 "10") ///
scale(1.5) ///
bgcolor("white") graphregion(color(white)) plotregion(margin(zero)) //
graph export "Figures\sm_dist_`a'_empirical.eps", replace
graph export "Figures\sm_dist_`a'_empirical.png", replace

twoway bar `var' x if inrange(x,5,20), barwidth(0.1) color($kolor) fintensity(inten100) || ///
line wdi x if inrange(x,5,20), lcolor(blue) lwidth(medthick) || ///
line vhlss x if inrange(x,5,20), lcolor(lime) lwidth(medthick) || ///
line psid x if inrange(x,5,20), lcolor(magenta) lwidth(medthick) || ///
line qog x if inrange(x,5,20), lcolor(cyan) lwidth(medthick) ///
ytitle("Density") xtitle("|z-score|") ///
xlabel(5 "5"  10 "10" 15 "15" 20 "20") ///
ylabel(0(0.01)0.05, angle(0) nogrid) ///
scale(1.5) ///
bgcolor("white") graphregion(color(white)) plotregion(margin(zero)) //
graph export "Figures\sm_dist_`a'_empirical_tail.eps", replace
graph export "Figures\sm_dist_`a'_empirical_tail.png", replace
}


* Plotting the charts with preferred inputs
*******************************************
twoway bar obs_cb x if x < 10, barwidth(0.1) color($kolor) fintensity(inten100) || ///
line cauchy_15 x if x < 10 & cauchy_15 < 0.4, lcolor(magenta) || ///
line wdi x if x < 10 & wdi < 0.4, lcolor(blue) || ///
line vhlss x if x < 10 & vhlss < 0.4, lcolor(lime) || ///
line qog x if x < 10 & qog < 0.4, lcolor(cyan) ///
ylabel(0(0.1)0.4, angle(0) nogrid) ///
ytitle("Density") xtitle("|z-score|") ///
xlabel(0 "0" 1.96 "1.96" 10 "10") ///
scale(1.5) ///
bgcolor("white") graphregion(color(white)) plotregion(margin(zero)) //
graph export "Figures\sm_dist_cb_best.eps", replace
graph export "Figures\sm_dist_cb_best.png", replace

twoway bar obs_cb x if inrange(x,5,20), barwidth(0.1) color($kolor) fintensity(inten100) || ///
line cauchy_15 x if inrange(x,5,20), lcolor(magenta) lwidth(medthick) || ///
line wdi x if inrange(x,5,20), lcolor(blue) lwidth(medthick) || ///
line vhlss x if inrange(x,5,20), lcolor(lime) lwidth(medthick) || ///
line qog x if inrange(x,5,20), lcolor(cyan) lwidth(medthick) ///
ytitle("Density") xtitle("|z-score|") ///
xlabel(5 "5"  10 "10" 15 "15" 20 "20") ///
ylabel(0(0.01)0.05, angle(0) nogrid) ///
scale(1.5) ///
bgcolor("white") graphregion(color(white)) plotregion(margin(zero)) //
graph export "Figures\sm_dist_cb_best_tail.eps", replace
graph export "Figures\sm_dist_cb_best_tail.png", replace

twoway bar obs_rba x if x < 10, barwidth(0.1) color($kolor) fintensity(inten100) || ///
line cauchy_15 x if x < 10 & cauchy_15 < 0.4, lcolor(magenta) || ///
line student_1 x if x < 10 & student_1 < 0.4, lcolor(green) || ///
line wdi x if x < 10 & wdi < 0.4, lcolor(blue) || ///
line vhlss x if x < 10 & vhlss < 0.4, lcolor(lime) || ///
line qog x if x < 10 & qog < 0.4, lcolor(cyan) ///
ylabel(0(0.1)0.4, angle(0) nogrid) ///
ytitle("Density") xtitle("|z-score|") ///
xlabel(0 "0" 1.96 "1.96" 10 "10") ///
scale(1.5) ///
bgcolor("white") graphregion(color(white)) plotregion(margin(zero)) //
graph export "Figures\sm_dist_rba_best.eps", replace
graph export "Figures\sm_dist_rba_best.png", replace

twoway bar obs_rba x if inrange(x,5,20), barwidth(0.1) color($kolor) fintensity(inten100) || ///
line cauchy_15 x if inrange(x,5,20), lcolor(magenta) lwidth(medthick) || ///
line student_1 x if inrange(x,5,20), lcolor(green) lwidth(medthick)|| ///
line wdi x if inrange(x,5,20), lcolor(blue) lwidth(medthick) || ///
line vhlss x if inrange(x,5,20), lcolor(lime) lwidth(medthick) || ///
line qog x if inrange(x,5,20), lcolor(cyan) lwidth(medthick) ///
ytitle("Density") xtitle("|z-score|") ///
xlabel(5 "5"  10 "10" 15 "15" 20 "20") ///
ylabel(0(0.01)0.05, angle(0) nogrid) ///
scale(1.5) ///
bgcolor("white") graphregion(color(white)) plotregion(margin(zero)) //
graph export "Figures\sm_dist_rba_best_tail.eps", replace
graph export "Figures\sm_dist_rba_best_tail.png", replace

twoway bar obs_rbnz x if x < 10, barwidth(0.1) color($kolor) fintensity(inten100) || ///
line cauchy_15 x if x < 10 & cauchy_15 < 0.4, lcolor(magenta) || ///
line student_1 x if x < 10 & student_1 < 0.4, lcolor(cyan) ///
ylabel(0(0.1)0.4, angle(0) nogrid) ///
ytitle("Density") xtitle("|z-score|") ///
xlabel(0 "0" 1.96 "1.96" 10 "10") ///
scale(1.5) ///
bgcolor("white") graphregion(color(white)) plotregion(margin(zero)) //
graph export "Figures\sm_dist_rbnz_best.eps", replace
graph export "Figures\sm_dist_rbnz_best.png", replace

twoway bar obs_rbnz x if inrange(x,5,20), barwidth(0.1) color($kolor) fintensity(inten100) || ///
line cauchy_15 x if inrange(x,5,20), lcolor(magenta) lwidth(medthick) || ///
line student_1 x if inrange(x,5,20), lcolor(cyan) lwidth(medthick) ///
ytitle("Density") xtitle("|z-score|") ///
xlabel(5 "5"  10 "10" 15 "15" 20 "20") ///
ylabel(0(0.01)0.05, angle(0) nogrid) ///
scale(1.5) ///
bgcolor("white") graphregion(color(white)) plotregion(margin(zero)) //
graph export "Figures\sm_dist_rbnz_best_tail.eps", replace
graph export "Figures\sm_dist_rbnz_best_tail.png", replace

twoway bar obs_minn x if x < 10, barwidth(0.1) color($kolor) fintensity(inten100) || ///
line cauchy_15 x if x < 10 & cauchy_15 < 0.4, lcolor(magenta) || ///
line cauchy_2 x if x < 10 & cauchy_2 < 0.4, lcolor(green) || ///
line wdi x if x < 10 & wdi < 0.4, lcolor(blue) || ///
line vhlss x if x < 10 & vhlss < 0.4, lcolor(lime) || ///
line qog x if x < 10 & qog < 0.4, lcolor(cyan) ///
ylabel(0(0.1)0.4, angle(0) nogrid) ///
ytitle("Density") xtitle("|z-score|") ///
xlabel(0 "0" 1.96 "1.96" 10 "10") ///
scale(1.5) ///
bgcolor("white") graphregion(color(white)) plotregion(margin(zero)) //
graph export "Figures\sm_dist_minn_best.eps", replace
graph export "Figures\sm_dist_minn_best.png", replace

twoway bar obs_minn x if inrange(x,5,20), barwidth(0.1) color($kolor) fintensity(inten100) || ///
line cauchy_15 x if inrange(x,5,20), lcolor(magenta) lwidth(medthick) || ///
line cauchy_2 x if inrange(x,5,20), lcolor(green) lwidth(medthick) || ///
line wdi x if inrange(x,5,20), lcolor(blue) lwidth(medthick) || ///
line vhlss x if inrange(x,5,20), lcolor(lime) lwidth(medthick) || ///
line qog x if inrange(x,5,20), lcolor(cyan) lwidth(medthick) ///
ytitle("Density") xtitle("|z-score|") ///
xlabel(5 "5"  10 "10" 15 "15" 20 "20") ///
ylabel(0(0.01)0.05, angle(0) nogrid) ///
scale(1.5) ///
bgcolor("white") graphregion(color(white)) plotregion(margin(zero)) //
graph export "Figures\sm_dist_minn_best_tail.eps", replace
graph export "Figures\sm_dist_minn_best_tail.png", replace

twoway bar obs_eye_cb x if x < 10, barwidth(0.1) color($kolor) fintensity(inten100) || ///
line cauchy_15 x if x < 10 & cauchy_15 < 0.4, lcolor(magenta) || ///
line wdi x if x < 10 & wdi < 0.4, lcolor(blue) || ///
line student_1 x if x < 10 & vhlss < 0.4, lcolor(lime) || ///
line qog x if x < 10 & qog < 0.4, lcolor(cyan) ///
ylabel(0(0.1)0.4, angle(0) nogrid) ///
ytitle("Density") xtitle("|z-score|") ///
xlabel(0 "0" 1.96 "1.96" 10 "10") ///
scale(1.5) ///
bgcolor("white") graphregion(color(white)) plotregion(margin(zero)) //
graph export "Figures\sm_dist_eye_cb_best.eps", replace
graph export "Figures\sm_dist_eye_cb_best.png", replace

twoway bar obs_eye_cb x if inrange(x,5,20), barwidth(0.1) color($kolor) fintensity(inten100) || ///
line cauchy_15 x if inrange(x,5,20), lcolor(magenta) lwidth(medthick) || ///
line wdi x if inrange(x,5,20), lcolor(blue) lwidth(medthick) || ///
line student_1 x if inrange(x,5,20), lcolor(lime) lwidth(medthick) || ///
line qog x if inrange(x,5,20), lcolor(cyan) lwidth(medthick) ///
ytitle("Density") xtitle("|z-score|") ///
xlabel(5 "5"  10 "10" 15 "15" 20 "20") ///
ylabel(0(0.01)0.05, angle(0) nogrid) ///
scale(1.5) ///
bgcolor("white") graphregion(color(white)) plotregion(margin(zero)) //
graph export "Figures\sm_dist_eye_cb_best_tail.eps", replace
graph export "Figures\sm_dist_eye_cb_best_tail.png", replace

twoway bar obs_noEye_cb x if x < 10, barwidth(0.1) color($kolor) fintensity(inten100) || ///
line cauchy_2 x if x < 10 & cauchy_2 < 0.4, lcolor(magenta) || ///
line wdi x if x < 10 & wdi < 0.4, lcolor(blue) || ///
line vhlss x if x < 10 & vhlss < 0.4, lcolor(lime) || ///
line qog x if x < 10 & qog < 0.4, lcolor(cyan) ///
ylabel(0(0.1)0.4, angle(0) nogrid) ///
ytitle("Density") xtitle("|z-score|") ///
xlabel(0 "0" 1.96 "1.96" 10 "10") ///
scale(1.5) ///
bgcolor("white") graphregion(color(white)) plotregion(margin(zero)) //
graph export "Figures\sm_dist_noEye_cb_best.eps", replace
graph export "Figures\sm_dist_noEye_cb_best.png", replace

twoway bar obs_noEye_cb x if inrange(x,5,20), barwidth(0.1) color($kolor) fintensity(inten100) || ///
line cauchy_2 x if inrange(x,5,20), lcolor(magenta) lwidth(medthick) || ///
line wdi x if inrange(x,5,20), lcolor(blue) lwidth(medthick) || ///
line vhlss x if inrange(x,5,20), lcolor(lime) lwidth(medthick) || ///
line qog x if inrange(x,5,20), lcolor(cyan) lwidth(medthick) ///
ytitle("Density") xtitle("|z-score|") ///
xlabel(5 "5"  10 "10" 15 "15" 20 "20") ///
ylabel(0(0.01)0.05, angle(0) nogrid) ///
scale(1.5) ///
bgcolor("white") graphregion(color(white)) plotregion(margin(zero)) //
graph export "Figures\sm_dist_noEye_cb_best_tail.eps", replace
graph export "Figures\sm_dist_noEye_cb_best_tail.png", replace

twoway bar obs_pub_cb x if x < 10, barwidth(0.1) color($kolor) fintensity(inten100) || ///
line student_1 x if x < 10 & student_1 < 0.4, lcolor(magenta) || ///
line cauchy_15 x if x < 10 & cauchy_15 < 0.4, lcolor(green) || ///
line wdi x if x < 10 & wdi < 0.4, lcolor(blue) || ///
line vhlss x if x < 10 & vhlss < 0.4, lcolor(lime) || ///
line qog x if x < 10 & qog < 0.4, lcolor(cyan) ///
ylabel(0(0.1)0.4, angle(0) nogrid) ///
ytitle("Density") xtitle("|z-score|") ///
xlabel(0 "0" 1.96 "1.96" 10 "10") ///
scale(1.5) ///
bgcolor("white") graphregion(color(white)) plotregion(margin(zero)) //
graph export "Figures\sm_dist_pub_cb_best.eps", replace
graph export "Figures\sm_dist_pub_cb_best.png", replace

twoway bar obs_pub_cb x if inrange(x,5,20), barwidth(0.1) color($kolor) fintensity(inten100) || ///
line student_1 x if inrange(x,5,20), lcolor(magenta) lwidth(medthick) || ///
line cauchy_15 x if inrange(x,5,20), lcolor(green) lwidth(medthick) || ///
line wdi x if inrange(x,5,20), lcolor(blue) lwidth(medthick) || ///
line vhlss x if inrange(x,5,20), lcolor(lime) lwidth(medthick) || ///
line qog x if inrange(x,5,20), lcolor(cyan) lwidth(medthick) ///
ytitle("Density") xtitle("|z-score|") ///
xlabel(5 "5"  10 "10" 15 "15" 20 "20") ///
ylabel(0(0.01)0.05, angle(0) nogrid) ///
scale(1.5) ///
bgcolor("white") graphregion(color(white)) plotregion(margin(zero)) //
graph export "Figures\sm_dist_pub_cb_best_tail.eps", replace
graph export "Figures\sm_dist_pub_cb_best_tail.png", replace

twoway bar obs_noPub_cb x if x < 10, barwidth(0.1) color($kolor) fintensity(inten100) || ///
line cauchy_2 x if x < 10 & cauchy_2 < 0.4, lcolor(magenta) || ///
line wdi x if x < 10 & wdi < 0.4, lcolor(blue) || ///
line vhlss x if x < 10 & vhlss < 0.4, lcolor(lime) || ///
line qog x if x < 10 & qog < 0.4, lcolor(cyan) ///
ylabel(0(0.1)0.4, angle(0) nogrid) ///
ytitle("Density") xtitle("|z-score|") ///
xlabel(0 "0" 1.96 "1.96" 10 "10") ///
scale(1.5) ///
bgcolor("white") graphregion(color(white)) plotregion(margin(zero)) //
graph export "Figures\sm_dist_noPub_cb_best.eps", replace
graph export "Figures\sm_dist_noPub_cb_best.png", replace

twoway bar obs_noPub_cb x if inrange(x,5,20), barwidth(0.1) color($kolor) fintensity(inten100) || ///
line cauchy_2 x if inrange(x,5,20), lcolor(magenta) lwidth(medthick) || ///
line wdi x if inrange(x,5,20), lcolor(blue) lwidth(medthick) || ///
line vhlss x if inrange(x,5,20), lcolor(lime) lwidth(medthick) || ///
line qog x if inrange(x,5,20), lcolor(cyan) lwidth(medthick) ///
ytitle("Density") xtitle("|z-score|") ///
xlabel(5 "5"  10 "10" 15 "15" 20 "20") ///
ylabel(0(0.01)0.05, angle(0) nogrid) ///
scale(1.5) ///
bgcolor("white") graphregion(color(white)) plotregion(margin(zero)) //
graph export "Figures\sm_dist_noPub_cb_best_tail.eps", replace
graph export "Figures\sm_dist_noPub_cb_best_tail.png", replace

twoway bar obs_noExpData_cb x if x < 10, barwidth(0.1) color($kolor) fintensity(inten100) || ///
line cauchy_15 x if x < 10 & cauchy_15 < 0.4, lcolor(magenta) || ///
line cauchy_2 x if x < 10 & cauchy_2 < 0.4, lcolor(green) || ///
line wdi x if x < 10 & wdi < 0.4, lcolor(blue) || ///
line vhlss x if x < 10 & vhlss < 0.4, lcolor(lime) || ///
line qog x if x < 10 & qog < 0.4, lcolor(cyan) ///
ylabel(0(0.1)0.4, angle(0) nogrid) ///
ytitle("Density") xtitle("|z-score|") ///
xlabel(0 "0" 1.96 "1.96" 10 "10") ///
scale(1.5) ///
bgcolor("white") graphregion(color(white)) plotregion(margin(zero)) //
graph export "Figures\sm_dist_noExpData_best.eps", replace
graph export "Figures\sm_dist_noExpData_best.png", replace

twoway bar obs_noExpData_cb x if inrange(x,5,20), barwidth(0.1) color($kolor) fintensity(inten100) || ///
line cauchy_15 x if inrange(x,5,20), lcolor(magenta) lwidth(medthick) || ///
line cauchy_2 x if inrange(x,5,20), lcolor(green) lwidth(medthick) || ///
line wdi x if inrange(x,5,20), lcolor(blue) lwidth(medthick) || ///
line vhlss x if inrange(x,5,20), lcolor(lime) lwidth(medthick) || ///
line qog x if inrange(x,5,20), lcolor(cyan) lwidth(medthick) ///
ytitle("Density") xtitle("|z-score|") ///
xlabel(5 "5"  10 "10" 15 "15" 20 "20") ///
ylabel(0(0.01)0.05, angle(0) nogrid) ///
scale(1.5) ///
bgcolor("white") graphregion(color(white)) plotregion(margin(zero)) //
graph export "Figures\sm_dist_noExpData_best_tail.eps", replace
graph export "Figures\sm_dist_noExpData_best_tail.png", replace

twoway bar obs_control x if x < 10, barwidth(0.1) color($kolor) fintensity(inten100) || ///
line cauchy_15 x if x < 10 & cauchy_15 < 0.4, lcolor(magenta) || ///
line cauchy_2 x if x < 10 & cauchy_2 < 0.4, lcolor(green) || ///
line wdi x if x < 10 & wdi < 0.4, lcolor(blue) || ///
line vhlss x if x < 10 & vhlss < 0.4, lcolor(lime) || ///
line qog x if x < 10 & qog < 0.4, lcolor(cyan) ///
ylabel(0(0.1)0.4, angle(0) nogrid) ///
ytitle("Density") xtitle("|z-score|") ///
xlabel(0 "0" 1.96 "1.96" 10 "10") ///
scale(1.5) ///
bgcolor("white") graphregion(color(white)) plotregion(margin(zero)) // 
graph export "Figures\sm_dist_control_best.eps", replace
graph export "Figures\sm_dist_control_best.png", replace

twoway bar obs_control x if inrange(x,5,20), barwidth(0.1) color($kolor) fintensity(inten100) || ///
line cauchy_15 x if inrange(x,5,20), lcolor(magenta) lwidth(medthick) || ///
line cauchy_2 x if inrange(x,5,20), lcolor(green) lwidth(medthick) || ///
line wdi x if inrange(x,5,20), lcolor(blue) lwidth(medthick) || ///
line vhlss x if inrange(x,5,20), lcolor(lime) lwidth(medthick) || ///
line qog x if inrange(x,5,20), lcolor(cyan) lwidth(medthick) ///
ytitle("Density") xtitle("|z-score|") ///
xlabel(5 "5"  10 "10" 15 "15" 20 "20") ///
ylabel(0(0.01)0.05, angle(0) nogrid) ///
scale(1.5) ///
bgcolor("white") graphregion(color(white)) plotregion(margin(zero)) //
graph export "Figures\sm_dist_control_best_tail.eps", replace
graph export "Figures\sm_dist_control_best_tail.png", replace
