clear
set more off

macro drop _all
global kolor gs10 // Set color for stata histograms


* Writing subroutine to plot subsample charts for all derounded and unweighted test statistics
**********************************************************************************************
capture : program drop graph_stars

program define graph_stars
twoway histogram t_stat_sm if t_stat_sm < 10.0 & t_stat_sm >= 0 & `1' == 1, bin(200) color($kolor) || ///
kdens t_stat_sm if t_stat_sm < 10.0 & t_stat_sm > 0.0 & `1' == 1, kernel(epanechnikov) ll(0) ul(10) bw(0.2) color(black)||, ///
xlabel(0 "0" 1.96 "1.96" 10 "10") ///
ylabel(0(0.1)0.4, angle(0) nogrid) ///
ytitle("Density") ///
scale(1.5) ///
xtitle("|z-score|") ///
bgcolor("white") graphregion(color(white) margin(l-3 r+1)) plotregion(margin(zero)) ///
legend(off)
local a =  regexr("`1'","D_","")
graph export "Figures\sm_dist_`a'.eps", replace
graph export "Figures\sm_dist_`a'.png", replace
end
* Note: graph_stars takes one argument, in string format, which is typically a subsample dummy variable that is called D_SOMETHING.


* Pulling data from 3_final.do and and plotting subsample charts for derounded and unweighted test statistics
*************************************************************************************************************
use "Data/Final/final_stars_supp", clear

foreach var of varlist D_cb D_topJ D_explore_cb D_dataDriven_cb D_noExpData_cb D_control{
graph_stars "`var'"
}


* Writing subroutine to plot subsample charts for derounded and unweighted test statistics that are not from exploratory or data-driven research
************************************************************************************************************************************************
capture : program drop graph_stars_noExpData

program define graph_stars_noExpData
twoway histogram t_stat_sm if t_stat_sm < 10.0 & t_stat_sm >= 0 & `1' == 1 & D_noExpData_cb == 1, bin(200) color($kolor) || ///
kdens t_stat_sm if t_stat_sm < 10.0 & t_stat_sm > 0.0 & `1' == 1 & D_noExpData_cb == 1, kernel(epanechnikov) ll(0) ul(10) bw(0.2) color(black)||, ///
xlabel(0 "0" 1.96 "1.96" 10 "10") ///
ylabel(0(0.1)0.4, angle(0) nogrid) ///
ytitle("Density") ///
scale(1.5) ///
xtitle("|z-score|") ///
bgcolor("white") graphregion(color(white) margin(l-3 r+1)) plotregion(margin(zero)) ///
legend(off)
local a =  regexr("`1'","D_","")
graph export "Figures\sm_dist_`a'.eps", replace
graph export "Figures\sm_dist_`a'.png", replace
end
* Note: graph_stars takes one argument, in string format, which is typically a subsample dummy variable that is called D_SOMETHING.
* Note: these are data for subgroup subsets, i.e. the ones that switch on the noExpData dummy


* Plotting subsample charts for derounded and unweighted test statistics that are not from exploratory or data-driven research
******************************************************************************************************************************
foreach var of varlist D_rba D_rbnz D_minn D_eye_cb D_noEye_cb D_pub_cb D_noPub_cb D_dataCode_cb{
graph_stars_noExpData "`var'"
}