clear
set more off


* Merge variables data with external author data and create new dummy variables for descriptive statistics
**********************************************************************************************************
use "Data/Final/final_stars_supp.dta", clear
merge m:1 issue using "Data/Temp/external_authors.dta"
keep journal_id year issue article_page num_authors data_availability codes_availability peer eye_catcher main exploratory data_driven t_stat_sm external_author

replace main = "no" if main=="No"
replace main = "yes" if main=="Yes"

egen paper_id = group(issue article_page)
bysort paper_id: egen count = seq() 

generate cb = 0
replace cb=1 if journal_id=="Minneapolis Fed Staff Report" | journal_id=="RBA Research Discussion Paper" |journal_id=="RBNZ Discussion Paper"

generate data_and_codes = "no"
replace data_and_codes = "yes" if data_availability=="yes" & codes_availability=="yes"

generate sig_05 = 0
replace sig_05 = 1 if t_stat_sm > 1.959964


* Calculate descriptive statistics
**********************************
tab journal_id if count==1
tab data_and_codes journal_id if count==1
tab external_author journal_id if count==1
tab peer journal_id if count==1
tab num_authors journal_id if count==1

tab journal_id if main!="control"
tab sig_05 journal_id if main!="control"
tab eye_catcher journal_id if main!="control"
tab exploratory journal_id if main!="control"
tab data_driven journal_id if main!="control"

tab journal_id if main=="control"

* Note: some descriptive statistics are converted to percentages in the file "Descriptive statistics.xlsx"