clear
set more off


* Collating the max cumulated residuals and associated statistics from each of the non-parametric estimations 
*************************************************************************************************************
use "Data/Temp/export_from_r", clear

local k = 0
foreach var of varlist yf_*{
local k = `k'+1
local a =  regexr("`var'","yf_","")
egen double tmp = max(S_`a') if xxx > 2
gen tmp1 = xxx if S_`a' == tmp
sort tmp1
local b = round(tmp1[1]*100)/100 //for presentational purposes
local c = round(tmp[1]*1000)/1000 //for presentational purposes
display "`a'"
display "`b'"
display "`c'"
drop tmp tmp1
preserve
	clear
	set obs 1
	gen sample = "`a'"
	gen t_max_nonparam = `b'
	gen S_max_nonparam = `c'
	save "Data/Temp/tmp`k'", replace
restore
}

use "Data/Temp/tmp1", clear
forvalues i = 2(1)`k'{
append using "Data/Temp/tmp`i'"
erase "Data/Temp/tmp`i'.dta"
}

sort sample
save "Data/Temp/non_param_summary", replace


* Collating the max cumlated residuals and associated statistics from each of the parametric estimations 
********************************************************************************************************
use "Data/Temp/parametric_estimation", clear

local k = 0
foreach var of varlist yf_*{
local k = `k'+1
local a =  regexr("`var'","yf_obs_","")
local b =  substr("`var'",-1,1)
	if "`b'" == "r"{
	local w = "real"
	local w1 = "eal"
	}
	if "`b'" == "v"{
	local w = "vhlss"
	local w1 = "hlss"
	}
	if "`b'" == "q"{
	local w = "qog"
	local w1 = "og"
	}
	if "`b'" == "p"{
	local w = "psid"
	local w1 = "sid"
	}
	if "`b'" == "s"{
	local w = "student"
	local w1 ="tudent"
	}
	if "`b'" == "c"{
	local w = "cauchy_15"
	local w1 ="auchy_15"
	}
	if "`b'" == "t"{
	local w = "cauchy_2"
	local w1 ="cauchy_2" //I change formats for this and the next one because these parts were a programatic afterthought
	}
	if "`b'" == "u"{
	local w = "cauchy_05"
	local w1 ="cauchy_05"
	}
	if "`b'" == "h"{
	local w = "cSmooth" 
	local w1 ="cSmooth"
	}
egen double tmp = max(S_obs_`a') if xxx > 2
gen tmp1 = xxx if S_obs_`a' == tmp
sort tmp1
local d = round(tmp1[1]*100)/100
local c = round(tmp[1]*1000)/1000
if "`b'" == "t" {
local a = substr("`a'",1,length("`a'")-1) //tidying up for the afterthought above
}
if "`b'" == "u" {
local a = substr("`a'",1,length("`a'")-1) 
}
if "`b'" == "h" {
local a = regexr("`a'","_h","_")
}
display "`a'`w1'"
display "`d'"
display "`c'"
drop tmp tmp1
preserve
	clear
	set obs 1
	gen sample = "`a'`w1'"
	gen t_max_param = `d'
	gen S_max_param = `c'
	save "Data/Temp/tmp`k'", replace
restore
}

use "Data/Temp/tmp1", clear
forvalues i = 2(1)`k'{
append using "Data/Temp/tmp`i'"
erase "Data/Temp/tmp`i'.dta"
}

erase "Data/Temp/tmp1.dta"

save "Data/Temp/param_summary", replace


* Merging the max cumulated residuals from both samples
*******************************************************
sort sample
merge 1:1 sample using "Data/Temp/non_param_summary"
drop _merge
format %9.3f S_max*
format %9.2f t_max*
save "Data/Final/summary_residuals", replace


* Dropping redundant files
**************************
erase "Data/Temp/param_summary.dta"
erase "Data/Temp/non_param_summary.dta"