clear
set more off


* Clean and standardise author affiliations data
************************************************
use "Data/Temp/author_x_article.dta", clear

drop article_page year author status status_1y status_2y status_3y editor editor_before

replace affiliation_1 = "Bank for International Settlements" if affiliation_1 == "Bank of International Settlements"
replace affiliation_1 = "Federal Reserve" if affiliation_1 == "Board of Governors of the Federal Reserve System" | affiliation_1 == "Federal Reserve Bank of Cleveland" | affiliation_1 == "Federal Reserve Bank of Kansas City" | affiliation_1 == "Federal Reserve Bank of Minneapolis" | affiliation_1 == "Federal Reserve Bank of Philadelphia" | affiliation_1 == "Federal Reserve Board"
replace affiliation_1 = "Columbia University" if affiliation_1 == "Columbia Graduate School of Business"
replace affiliation_1 = "Motu Economic and Public Policy Research" if affiliation_1 == "Motu"
replace affiliation_1 = "Reserve Bank of New Zealand" if affiliation_1 == "RBNZ"
replace affiliation_1 = "Victoria University of Wellington" if affiliation_1 == "School of Economics & Finance, Victoria University of Wellington"
replace affiliation_1 = "University of New South Wales" if affiliation_1 == "School of Economics, University of New South Wales"
replace affiliation_1 = "New York University" if affiliation_1 == "Stern School of Business, New York University"
replace affiliation_1 = "New Zealand Treasury" if affiliation_1 == "The Treasury"
replace affiliation_1 = "University of California" if affiliation_1 == "University of California, Los Angeles" | affiliation_1 == "University of California, San Diego"
replace affiliation_1 = "University of Chicago" if affiliation_1 == "University of Chicago Booth School of Business"
replace affiliation_1 = "University of North Carolina" if affiliation_1 == "University of North Carolina at Chapel Hill"
replace affiliation_1 = "University of British Columbia" if affiliation_1 == "Vancouver School of Economics"
replace affiliation_1 = "University of Minnesota" if affiliation_1 == "Humphrey School of Public Affairs"
replace affiliation_1 = "Massachusetts Institute of Technology" if affiliation_1 == "MIT"
replace affiliation_1 = "Centre for Monetary and Financial Studies" if affiliation_1 == "CEMFI"
replace affiliation_1 = "Centre for Reserach in Economics and Statistics" if affiliation_1 == "CREST-INSEE"
replace affiliation_1 = "International Monetary Fund" if affiliation_1 == "IMF"

split affiliation_2, p(", ")

replace affiliation_21 = "The Bureau for Research and Economic Analysis of Development" if affiliation_21 == "BREAD"
replace affiliation_21 = "Centre for Applied Macroeconomic Analysis" if affiliation_21 == "CAMA"
replace affiliation_21 = "Center for Economic Policy Research" if affiliation_21 == "CEPR"
replace affiliation_21 = "Federal Reserve" if affiliation_21 == "Federal Reserve Bank of Chicago" | affiliation_21 == "Federal Reserve Bank of Minneapolis"
replace affiliation_21 = "National Bureau of Economic Research" if affiliation_21 == "NBER"
replace affiliation_21 = "Victoria University of Wellington" if affiliation_21 == "School of Economics & Finance Victoria University of Wellington"

replace affiliation_22 = "The Bureau for Research and Economic Analysis of Development" if affiliation_22 == "BREAD"
replace affiliation_22 = "CAERP" if affiliation_22 == "CAERP" /* can't find english translation */
replace affiliation_22 = "Center for Economic Policy Research" if affiliation_22 == "CEPR"
replace affiliation_22 = "Federal Reserve" if affiliation_22 == "Federal Reserve Bank of Minneapolis"
replace affiliation_22 = "Innocenzo Gasparini Institute for Economic Research" if affiliation_22 == "IGIER"
replace affiliation_22 = "Institute of Labor Economics" if affiliation_22 == "IZA"
replace affiliation_22 = "National Bureau of Economic Research" if affiliation_22 == "NBER"

replace affiliation_23 = "Center for Economic Policy Research" if affiliation_23 == "CEPR" | affiliation_23 == " Centre for Economic Policy Research"
replace affiliation_23 = "National Bureau of Economic Research" if affiliation_23 == "NBER"

replace affiliation_24 = "Center for Economic Policy Research" if affiliation_24 == "CEPR"
replace affiliation_24 = "National Bureau of Economic Research" if affiliation_24 == "NBER"

drop affiliation_2


* Create variable that shows if author is external to the central bank that published the paper
***********************************************************************************************
generate external_author = 1

replace external_author = 0 if journal_id=="RBA Research Discussion Paper" & affiliation_1=="Reserve Bank of Australia"
replace external_author = 0 if journal_id=="RBA Research Discussion Paper" & affiliation_21=="Reserve Bank of Australia"
replace external_author = 0 if journal_id=="RBA Research Discussion Paper" & affiliation_22=="Reserve Bank of Australia"
replace external_author = 0 if journal_id=="RBA Research Discussion Paper" & affiliation_23=="Reserve Bank of Australia"
replace external_author = 0 if journal_id=="RBA Research Discussion Paper" & affiliation_24=="Reserve Bank of Australia"

replace external_author = 0 if journal_id=="RBNZ Discussion Paper" & affiliation_1=="Reserve Bank of New Zealand"
replace external_author = 0 if journal_id=="RBNZ Discussion Paper" & affiliation_21=="Reserve Bank of New Zealand"
replace external_author = 0 if journal_id=="RBNZ Discussion Paper" & affiliation_22=="Reserve Bank of New Zealand"
replace external_author = 0 if journal_id=="RBNZ Discussion Paper" & affiliation_23=="Reserve Bank of New Zealand"
replace external_author = 0 if journal_id=="RBNZ Discussion Paper" & affiliation_24=="Reserve Bank of New Zealand"

replace external_author = 0 if journal_id=="Minneapolis Fed Staff Report" & affiliation_1=="Federal Reserve"
replace external_author = 0 if journal_id=="Minneapolis Fed Staff Report" & affiliation_21=="Federal Reserve"
replace external_author = 0 if journal_id=="Minneapolis Fed Staff Report" & affiliation_22=="Federal Reserve"
replace external_author = 0 if journal_id=="Minneapolis Fed Staff Report" & affiliation_23=="Federal Reserve"
replace external_author = 0 if journal_id=="Minneapolis Fed Staff Report" & affiliation_24=="Federal Reserve"


* Reshape data to be external authors by paper and create dummy variable to show if paper has at least one external author
**************************************************************************************************************************
drop journal_id affiliation_1 affiliation_21 affiliation_22 affiliation_23 affiliation_24
bysort issue: egen count = seq() 
reshape wide external_author, i(issue) j(count)

generate external_author = 0
replace external_author = 1 if external_author1==1 | external_author2==1 | external_author3==1 | external_author4==1 | external_author5==1
drop external_author1 external_author2 external_author3 external_author4 external_author5

save "Data/Temp/external_authors", replace