theme_starwars <- function() {
   theme(text = element_text(colour = "black"),
           plot.title = element_text(size = rel(2.5), hjust = 0.5, face = "bold", margin = unit(c(0, 0, 0.1, 0), "cm")),
           plot.subtitle = element_text(size = rel(2), hjust = 0.5),
           plot.caption = element_text(size = rel(1.2), hjust = 0),
           legend.text = element_text(size = rel(1.5)),
           axis.title.x.bottom = element_text(size = rel(1.5), angle = 0, margin=unit(c(0,0,0,0), "mm")),
           axis.title.y = element_text(size = rel(1.5), angle = 0, vjust = 1, margin=unit(c(0,-3,0,0), "mm")), 
           axis.title.y.right = element_text(size = rel(1.1), angle = 0, vjust = 1, margin=unit(c(0,0,0,-3), "mm")),
           axis.line = element_line(colour = "black"),
           axis.ticks.y = element_blank(),
           axis.ticks.length = unit(-0.25, "cm"),
           axis.ticks.x.bottom = element_line(colour = "black"),
           axis.text = element_text(size = rel(1.4), colour = "black"),
           axis.text.x.bottom = element_text(size = rel(1.1), colour = "black", margin = unit(c(0,0,10,0), "mm"), vjust = -6),
           axis.text.y.left = element_text(size = rel(1.1), margin = unit(c(0,4,0,0), "mm")),
           axis.text.y.right = element_text(size = rel(1.1), margin = unit(c(0,0,0,4), "mm")),
           panel.border = element_rect(fill = NA, colour = "black", size = 0.5),
           panel.background = element_blank(),
           panel.grid.minor = element_blank(),
           panel.grid.major.x = element_blank(),
           panel.grid.major.y = element_line(colour = "gray", size = 0.5),
           panel.spacing = unit(0, "cm"),
           strip.background = element_blank(),
           strip.text = element_blank(),
           legend.title = element_blank(),
           legend.justification = c(1, 1),
           legend.position = c(1, 0.98),
           legend.direction = "vertical",
           legend.background = element_rect(colour = "transparent", fill = "transparent"),
           legend.key = element_rect(colour = "transparent", fill = "transparent"),
           legend.key.size = unit(0.75, "cm"),         
           legend.box.background = element_rect(colour = "transparent", fill = "transparent"),
           plot.margin = margin(0.5, 0.5, 0.25, 0.5, "cm"))
}

z4_breaks <- function(x) {
  facet_number <<- facet_number + 1L
  switch(
    facet_number,
    c(0, 1.96, 4),
    c(1.96, 4),
    c(1.96, 4),
    c(1.96, 4),
    c(1.96, 4),
    c(1.96, 4)
  )
}

z10_breaks <- function(x) {
  facet_number <<- facet_number + 1L
  switch(
    facet_number,
    c(0, 1.96, 10),
    c(1.96, 10),
    c(1.96, 10),
    c(1.96, 10),
    c(1.96, 10),
    c(1.96, 10)
  )
}

figure2_breaks <- function(x) {
  facet_number <<- facet_number + 1L
  switch(
    facet_number,
    c(0, 1, 2, 3, 4, 5),
    c(1, 2, 3, 4, 5),
    c(1, 2, 3, 4, 5),
    c(1, 2, 3, 4, 5),
    c(1, 2, 3, 4, 5),
    c(1, 2, 3, 4, 5)
  )
}

figure3_breaks <- function(x) {
  facet_number <<- facet_number + 1L
  switch(
    facet_number,
    c(0, 0.01, 0.02, 0.03, 0.04, 0.05),
    c(0.01, 0.02, 0.03, 0.04, 0.05),
    c(0.01, 0.02, 0.03, 0.04, 0.05),
    c(0.01, 0.02, 0.03, 0.04, 0.05),
    c(0.01, 0.02, 0.03, 0.04, 0.05),
    c(0.01, 0.02, 0.03, 0.04, 0.05)
  )
}

z10_labels <- function(x) {
  label_number <<- label_number + 1L
  switch(
    label_number,
    c("0", "1.96", "10"),
    c("1.96", "10"),
    c("1.96", "10"),
    c("1.96", "10"),
    c("1.96", "10"),
    c("1.96", "10")
  )
}

z4_labels <- function(x) {
  label_number <<- label_number + 1L
  switch(
    label_number,
    c("0", "1.96", "4"),
    c("1.96", "4"),
    c("1.96", "4"),
    c("1.96", "4"),
    c("1.96", "4"),
    c("1.96", "4")
  )
}