# Star Wars at Central Banks Script 01 - Selecting Input Data for P-curve Analysis
# Last Updated: 27 January 2021

library(tidyverse)
library(haven)

starwars_data <- read_dta("Data/Final/final_stars_supp.dta")

starwars_data <- starwars_data %>%
  mutate(paper_id = paste0(issue, "_", article_page, "_", first_author)) %>%      #creates unique paper id
  arrange(issue, article_page, first_author) %>%    # force the same order of rows to ensure the sampling below is perfectly reproducible
  filter(main == "yes" & t_stat_raw >= 1.96) %>%    # p-curves only applied to main results that are significant at the 5 per cent level
  select(paper_id, journal_id, eye_catcher, exploratory, data_driven, peer, data_availability, codes_availability, t_stat_raw)
  
full_brodeur_data <- starwars_data %>%
  filter(!journal_id %in% c("RBA Research Discussion Paper", "Minneapolis Fed Staff Report", "RBNZ Discussion Paper")) %>%
  group_by(paper_id) %>%
  sample_n(1) %>%
  ungroup()

full_cb_data <- starwars_data %>%
  filter(journal_id %in% c("RBA Research Discussion Paper", "Minneapolis Fed Staff Report", "RBNZ Discussion Paper")) %>%
  group_by(paper_id) %>%
  sample_n(1) %>% #Randomly sample one test score observation from each unique paper id
  ungroup()

exploratory_cb_data <- starwars_data %>%
  filter(journal_id %in% c("RBA Research Discussion Paper", "Minneapolis Fed Staff Report", "RBNZ Discussion Paper")
         & exploratory == "yes") %>%
  group_by(paper_id) %>%
  sample_n(1) %>%
  ungroup()

datadriven_cb_data <- starwars_data %>%
  filter(journal_id %in% c("RBA Research Discussion Paper", "Minneapolis Fed Staff Report", "RBNZ Discussion Paper")
         & data_driven == "yes") %>%
  group_by(paper_id) %>%
  sample_n(1) %>%
  ungroup()

total_cb_less_exp_and_dd <- starwars_data %>%
  filter(journal_id %in% c("RBA Research Discussion Paper", "Minneapolis Fed Staff Report", "RBNZ Discussion Paper")
         & data_driven == "no" & exploratory == "no") %>%
  group_by(paper_id) %>%
  sample_n(1) %>%
  ungroup()

