clear
set more off



* Writing the subroutine that populates rows for the main results table
***********************************************************************
capture : program drop summ_residuals
program define summ_residuals

local a = "`1'"
local input = "`2'"

preserve

keep if inlist(sample,"cb_`a'","topJ_`a'") 
sort sample
local a1 = S_max_nonparam[1] // cb
local a2 = S_max_nonparam[2] // topJ
local a3 = S_max_param[1]
local a4 = S_max_param[2]

restore

file write myfile "`input'" _tab %9.3f (`a1') _tab %9.3f (`a3') _tab %9.3f (`a2') _tab %9.3f (`a4') _newline

end



* Writing the subrouting that populates rows for the subsample results table
****************************************************************************

capture : program drop summ_residuals_sub
program define summ_residuals_sub

local subsample_title = "`1'"
local subsample = "`2'"
local input_title = "`3'"
local input = "`4'"

preserve

keep if sample == "`subsample'_`input'"
local a1 = S_max_nonparam[1]
local a2 = S_max_param[1]

restore

file write myfile "`subsample_title'" _tab "`input_title'" _tab %9.3f (`a1') _tab %9.3f (`a2')  _newline

end



* Populating the main results table
***********************************
use "Data/Final/summary_residuals", clear

capture : file close myfile
file open myfile using "Data/Final/summary_residuals.xls", write replace

file write myfile _newline ///
_tab "Maximum cumulated residuals" _newline ///
_tab "Our Sample" _tab _tab "Brodeur et al. (2016) sample" _newline ///
_tab "Non-parametric" _tab "Parametric"	_tab "Non-parametric" _tab "Parametric" _newline ///
_newline
	
summ_residuals "student" "Student(1)"
summ_residuals "cauchy_05" "Cauchy(0.5)"
summ_residuals "cauchy_15" "Cauchy(1.5)"
summ_residuals "real" "WDI"
summ_residuals "vhlss" "VHLSS"
summ_residuals "qog" "QOG"
summ_residuals "psid" "PSID"

file close myfile



* Populating the subsample results table
****************************************
use "Data/Final/summary_residuals", clear


capture : file close myfile
file open myfile using "Data/Final/summary_residuals_subsamples.xls", write replace

file write myfile _newline ///
_tab "input function used" _tab "Max. cumulated residuals" _tab "Max cumulated residuals" _newline ///
_tab _tab "using non-parametric" _tab "using parametric" _newline ///
_tab _tab "selection function" _tab "selection function" _newline ///
_newline


summ_residuals_sub "Do not come from data-driven model selection or exploratory research" "noExpData_cb" "Cauchy(1.5)" "cauchy_15"
summ_residuals_sub "" "noExpData_cb" "Cauchy(2)" "cauchy_2"
summ_residuals_sub "" "noExpData_cb" "WDI" "real"
summ_residuals_sub "" "noExpData_cb" "VHLSS" "vhlss"
summ_residuals_sub "" "noExpData_cb" "QOG" "qog"
summ_residuals_sub "Federal Reserve Bank of Minneapolis" "minn" "Cauchy(1.5)" "cauchy_15"
summ_residuals_sub "" "minn" "Cauchy(2)" "cauchy_2"
summ_residuals_sub "" "minn" "WDI" "real"
summ_residuals_sub "" "minn" "VHLSS" "vhlss"
summ_residuals_sub "" "minn" "QOG" "qog"
summ_residuals_sub "Reserve Bank of Australia" "rba" "Cauchy(1.5)" "cauchy_15"
summ_residuals_sub "" "rba" "Student(1)" "student"
summ_residuals_sub "" "rba" "WDI" "real"
summ_residuals_sub "" "rba" "VHLSS" "vhlss"
summ_residuals_sub "" "rba" "QOG" "qog"
summ_residuals_sub "Reserve Bank of New Zealand" "rbnz" "Cauchy(1.5)" "cauchy_15"
summ_residuals_sub "" "rbnz" "Student(1)" "student"
summ_residuals_sub "Published in a peer-reviewed journal" "pub_cb" "Cauchy(1.5)" "cauchy_15"
summ_residuals_sub "" "pub_cb" "Student(1)" "student"
summ_residuals_sub "" "pub_cb" "WDI" "real"
summ_residuals_sub "" "pub_cb" "VHLSS" "vhlss"
summ_residuals_sub "" "pub_cb" "QOG" "qog"
summ_residuals_sub "Not published in a peer-reviewed journal" "noPub_cb" "Cauchy(2)" "cauchy_2"
summ_residuals_sub "" "noPub_cb" "WDI" "real"
summ_residuals_sub "" "noPub_cb" "VHLSS" "vhlss"
summ_residuals_sub "" "noPub_cb" "QOG" "qog"
summ_residuals_sub "Uses eye-catchers" "eye_cb" "Cauchy(1.5)" "cauchy_15"
summ_residuals_sub "" "eye_cb" "Student(1)" "student"
summ_residuals_sub "" "eye_cb" "WDI" "real"
summ_residuals_sub "" "eye_cb" "VHLSS" "vhlss"
summ_residuals_sub "" "eye_cb" "QOG" "qog"
summ_residuals_sub "Does not use eye-catchers" "noEye_cb" "Cauchy(2)" "cauchy_2"
summ_residuals_sub "" "noEye_cb" "WDI" "real"
summ_residuals_sub "" "noEye_cb" "VHLSS" "vhlss"
summ_residuals_sub "" "noEye_cb" "QOG" "qog"
summ_residuals_sub "Placebo sample of tests on controls" "control" "Cauchy(1.5)" "cauchy_15"
summ_residuals_sub "" "control" "Cauchy(2)" "cauchy_2"
summ_residuals_sub "" "control" "WDI" "real"
summ_residuals_sub "" "control" "VHLSS" "vhlss"
summ_residuals_sub "" "control" "QOG" "qog"

file close myfile