clear
set more off


* Writing subroutine to plot selection functions and ratios of inputs to outputs for all derounded and unweighted test statistics
*********************************************************************************************************************************
capture : program drop graph_selfunction
program define graph_selfunction
local a =  regexr("`1'","yf_","")
local b =  substr("`1'",-1,1)
summ `1' if  x < 9
local c = round(r(max)) + 1
	if "`b'" == "l"{
	local w = "real"
	}
	if "`b'" == "t"{
	local w = "student"
	}
	if "`b'" == "5"{
	local w = "cauchy_15"
	}
	if "`b'" == "2"{
	local w = "cauchy_2"
	}
	if "`b'" == "d"{
	local w = "psid"
	}
	if "`b'" == "s"{
	local w = "vhlss"
	}
	if "`b'" == "g"{
	local w = "qog"
	}
	if "`b'" == "h"{
	local w = "cSmooth"
	}
#delimit ;
twoway scatter R_obs_`a' x [w=`w'] if x < 9  & R_obs_`a'<`c' , mlwidth(vvthin) mlcolor(black) msize(tiny) msymbol(smcircle_hollow) || ///
	   line `1' x if x < 9 , lcolor(black) || ///
	   line S_`a' x if x < 9 , yaxis(2) lcolor(black) lpattern(dash) lwidth(medthick)
xlabel(1.96 "1.96" 9 "9") 
scale(1.5)
ytitle("Scaled probability", axis(1))  
ytitle("Cum. excess probability", axis(2))  
ylabel(0(0.02)0.06, axis(2) nogrid angle(0))  
ylabel(0(1)`c', axis(1) nogrid angle(0))  
xtitle("|z-score|") 
bgcolor("white") graphregion(color(white))  
legend(col(1) order(2 "Shape of P[diss.|z] (LHS)" 3 "Unexplained P[z|diss.] (RHS)")) //pos(1) region(lstyle(none) lcolor(white))
;
#delimit cr
graph export "Figures\sel_`a'.eps", replace
graph export "Figures\sel_`a'.png", replace
end
*Notes: takes one argument, in string format, which is typically called yf_ETC


* Pulling data from 5_1_estimation_non_param.R and plotting the selection charts for all derounded and unweighted test statistics
*********************************************************************************************************************************
use "Data/Temp/export_from_r", clear

foreach var of varlist  yf_cb_cauchy_15 yf_cb_real yf_cb_vhlss yf_cb_qog yf_control_cauchy_15 yf_control_cauchy_2 yf_control_real yf_control_vhlss yf_control_qog {
graph_selfunction `var'
}


* Index selected dissemination bias series to chart together
************************************************************
use "Data/Temp/export_from_r", clear
capture : program drop index_series
program define index_series
generate i_`1' = `1'/`1'[196]*100
end

foreach var of varlist yf_cb_real yf_cb_vhlss yf_cb_qog yf_topJ_real yf_topJ_vhlss yf_topJ_qog {
index_series `var'
}


* Chart the dissemination bias series
*************************************
capture : program drop graph_dissemination
program define graph_dissemination
#delimit ;
twoway 	line `1' x if x < 4 , lcolor(black) || ///
		line `2' x if x < 4 , lcolor(black) lpattern(dash)
xlabel(1.96 "1.96" 4 "4")
scale(1.5)
ytitle("Indexed probability", axis(1)) 
ylabel(0(25)125, nogrid angle(0))
xtitle("|z-score|") 
bgcolor("white") graphregion(color(white)) 
legend(col(1) order(1 "Central banks" 2 "Top journals"))
;
#delimit cr
graph export "Figures\dissem_`1'.eps", replace
graph export "Figures\dissem_`1'.png", replace
end

graph_dissemination i_yf_cb_real i_yf_topJ_real
graph_dissemination i_yf_cb_vhlss i_yf_topJ_vhlss
graph_dissemination i_yf_cb_qog i_yf_topJ_qog