clear
set more off
* (This file takes a few minutes to run)


* Pulling data from 4_export.do and generating more explanatory variables
*************************************************************************
use "Data/Temp/export_param", clear

generate exp_x=exp(-x)
generate exp_x2=exp(-x)^2


* Generating ratios of output densities to input densities
**********************************************************
foreach var of varlist obs_*{
generate R_`var'_r = `var' / real
generate R_`var'_v = `var' / vhlss
generate R_`var'_p = `var' / psid
generate R_`var'_q = `var' / qog
generate R_`var'_s = `var' / student
generate R_`var'_c = `var' / cauchy_15
generate R_`var'_t = `var' / cauchy_2
generate R_`var'_u = `var' / cauchy_05
generate R_`var'_h = `var' / cSmooth
}


* Generating cumulative residuals
*********************************
foreach var of varlist R_*{
local a =  regexr("`var'","R","")
local b =  substr("`var'",-1,1)
	if "`b'" == "r"{
	local w = "real"
	}
	if "`b'" == "v"{
	local w = "vhlss"
	}
	if "`b'" == "q"{
	local w = "qog"
	}
	if "`b'" == "p"{
	local w = "psid"
	}
	if "`b'" == "c"{
	local w = "cauchy_15"
	}
	if "`b'" == "t"{
	local w = "cauchy_2"
	}
	if "`b'" == "u"{
	local w = "cauchy_05"
	}
	if "`b'" == "s"{
	local w = "student"
	}
	if "`b'" == "h"{
	local w = "cSmooth"
	}
quietly{
reg `var' exp_x exp_x2 [weight=`w']
predict yf`a'
gen res`a' = `var' - yf`a'
gen S`a' = 0
sort x
forvalues i = 1(1)1000{
generate ind = (_n <= `i')*(_n >= 0) // Generating triangular matrices of input functions to make series of cumulative residuals
egen sumtemp = sum(ind*`w'*res`a') 
replace S`a' = sumtemp if _n == `i'
drop sumtemp ind
}
egen sumtemp = sum(`w'*`var') // This is the last cumulative density for the observed z-scores (outputs)
replace S`a' = S`a'/sumtemp[1000] // Rescaling the residuals to read as a difference in densities
drop sumtemp
} // End of quietly
} // End of foreach var of varlist R_*{



* Calculating the cumulative density of the significant range for alternative statistics in the paper 
*****************************************************************************************************
generate ind200 = (_n <= 200)*(_n >= 0)
generate ind1000 = (_n <= 1000)*(_n >= 0)
egen sumtemp200 = sum(ind200*obs_cb)
egen sumtemp1000 = sum(ind1000*obs_cb)

display (sumtemp1000 - sumtemp200)/sumtemp1000
drop ind200 ind1000 sumtemp200 sumtemp1000


* Passing data to the graphing files
************************************
save "Data/Temp/parametric_estimation", replace