clear
set more off


* Uploading and combining the article meta data
*********************************************** 
generate journal_id = ""
save "Data/Temp/supp_data_article", replace

local files : dir "Data/Source/raw" files "DataCollection*.xlsx"
	foreach file in `files'{
	display "`file'"
	quietly{
	import excel using "Data/Source/raw/`file'", sheet(Article Variables) cellrange(B3) firstrow clear
	
	tostring  *, replace
	foreach var of varlist *{
	replace `var' = "" if `var' == "."
	}
	drop if journal_id == ""
		
	append using "Data/Temp/supp_data_article"
	save "Data/Temp/supp_data_article", replace
	} // end of quietly
	}

	
* Cleaning and passing the data to 3_final.do
*********************************************
foreach var of varlist *{
replace `var' = "yes" if `var' == "Yes"
replace `var' = "no" if `var' == "No"
}

drop ras thanks field field_2 negative_result // Didn't collect

sort journal_id issue article_page

save "Data/Temp/supp_data_article", replace