clear
clear matrix
set more off


* Uploading and combining the raw test variables data
***************************************************** 
generate year = ""
save "Data/Temp/stars_raw", replace

local files : dir "Data/Source/raw" files "DataCollection*.xlsx"
	foreach file in `files'{
	display "`file'"
	quietly{
	import excel using "Data/Source/raw/`file'", sheet(Test Variables) cellrange(B3) firstrow clear
	
	tostring  *, replace
	foreach var of varlist *{
	replace `var' = "" if `var' == "."
	}
	drop if year == ""
	order year article_page
	
	append using "Data/Temp/stars_raw"
	save "Data/Temp/stars_raw", replace
	} // end of quietly
	}

duplicates report journal_id issue article_page table_panel row column


* Cleaning and passing the data to 3_final.do
*********************************************
drop page jel starslevel second_author model type type_emp // Didn't collect 
drop general_specific_indicator exploratory_indicator notes // Won't be useful

rename tstat2 t_stat_2
rename tstat3 t_stat_3
rename standard_deviation2 standard_deviation_2
rename standard_deviation3 standard_deviation_3
rename general_specific data_driven
rename stars eye_catcher

destring num_authors year, force replace

save "Data/Temp/stars_raw", replace