/*
# robustness_VAR.do
# This program uses VAR to estimate impulse responses of economic activity to NSI and NUI shocks
# Robustness results in Section () and Appendix ()
*/


set matsize 11000
set more off

/* Import Stata file */

use "monthly_data.dta", clear
tset monthyear


/* VAR with news indicators ordered last */

var dunempr capexinvestsd buscondsd nsisd, lags(1/2) dfk small
vargranger
irf set var1, replace
irf create order1, step(12) replace
asdoc irf table oirf, impulse(nsisd) response(dunempr) level(90) save(irf_nsi_dunempr.doc) replace 
asdoc irf table oirf, impulse(nsisd) response(capexinvestsd) level(90) save(irf_nsi_capex.doc) replace 
asdoc irf table oirf, impulse(nsisd) response(buscondsd) level(90) save(irf_nsi_bci.doc) replace 

var dunempr capexinvestsd buscondsd nuisd, lags(1/2) dfk small
vargranger
irf set var1, replace
irf create order1, step(12) replace
asdoc irf table oirf, impulse(nuisd) response(dunempr) level(90) save(irf_nui_dunempr.doc) replace 
asdoc irf table oirf, impulse(nuisd) response(capexinvestsd) level(90) save(irf_nui_capex.doc) replace 
asdoc irf table oirf, impulse(nuisd) response(buscondsd) level(90) save(irf_nui_bci.doc) replace 


/* VAR with news indicators ordered first */

var nsisd dunempr capexinvestsd buscondsd, lags(1/2) dfk small
vargranger
irf set var1, replace
irf create order1, step(12) replace
asdoc irf table oirf, impulse(nsisd) response(dunempr) level(90) save(apx_irf_nsi_dunempr.doc) replace 
asdoc irf table oirf, impulse(nsisd) response(capexinvestsd) level(90) save(apx_irf_nsi_capex.doc) replace 
asdoc irf table oirf, impulse(nsisd) response(buscondsd) level(90) save(apx_irf_nsi_bci.doc) replace 

var nuisd dunempr capexinvestsd buscondsd, lags(1/2) dfk small
vargranger
irf set var1, replace
irf create order1, step(12) replace
asdoc irf table oirf, impulse(nuisd) response(dunempr) level(90) save(apx_irf_nui_dunempr.doc) replace 
asdoc irf table oirf, impulse(nuisd) response(capexinvestsd) level(90) save(apx_irf_nui_capex.doc) replace 
asdoc irf table oirf, impulse(nuisd) response(buscondsd) level(90) save(apx_irf_nui_bci.doc) replace 
