###################################################################
# main_LP.R
# This program uses Local Projections and Smooth Local Projections
# to estimate impulse responses of consumer sentiment 
# and economic activity to NSI, NUI, BCI, and Housing NSI shocks
# Main results in the paper
####################################################################

### SET UP

# Environment
rm(list=ls())
setwd("~/NSI RDP/Codes/R")
library(lubridate)
library(tfplot)
library(plyr)
library(dplyr)

# Bring in the LP and SLP function
source("lproj.R")

#### PART 1: Response of Consumer Sentiment to NSI shock

## Weekly

# Load the data
data = read.csv("nsi_csi_weekly.csv") # read csv file 

P <- 4 # number of lags of rhs variables
h1<- 0 # Set to 0 to have the shock hit in period 0, 1 to have the shock hit in period 1
H <- 12 # Number of horizons

# Response of weekly ANZ-RM CSI to NSI shock
y  <- data$rm_csisd # Response variable
x  <- data$nsisd # Endogenous variable related to the shock
# Other RHS variables (used to instrument for the impulse variable)
w  <- cbind(data$rm_csisd, 
            lagmatrix( cbind(data$rm_csisd, data$nsisd) , P ) ) 
# Create lambda options
lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# Remove NA rows due to lags
LPdata <- cbind(y,x,w)
LPdata <- na.omit(LPdata)
w <- LPdata[,3:ncol(LPdata)]
y <- LPdata[,1]
x <- LPdata[,2]
# Run a regular local projection (Jorda 2005).
ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# Run a smooth local projection
ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# Add confidence intervals to the smooth local projections and plot the impulse response functions
ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# Combine the estimates in one single dataframe
csi_nsi_w <- as.data.frame(cbind(ir.regular$ir,ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
colnames(csi_nsi_w) <- c('csi_nsi_w_r','csi_nsi_w', 'csi_nsi_w_l','csi_nsi_w_u')

## Monthly

# Load the data
data <- read.csv("monthly_data.csv") # read csv file 
data$date <- as.Date(data$date) 

#set up parameters
P <- 2 # number of lags of rhs variables
h1<- 0 # Set to 0 to have the shock hit in period 0, 1 to have the shock hit in period 1
H <- 12 # Number of horizons

# Response of monthly ANZ-RM CSI to NSI shock

y  <- data$rm_csisd # Response variable
x  <- data$nsisd # Endogenous variable related to the shock
# Other RHS variables (used to instrument for the impulse variable)
w  <- cbind(data$rm_csisd,
            lagmatrix( cbind(data$nsisd,data$rm_csisd) , P ) ) 
# Create lambda options
lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# Remove NA rows due to lags
LPdata <- cbind(y,x,w)
LPdata <- na.omit(LPdata)
w <- LPdata[,3:ncol(LPdata)]
y <- LPdata[,1]
x <- LPdata[,2]
# Run a regular local projection (Jorda 2005).
ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# Run a smooth local projection
ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# Add confidence intervals to the smooth local projections and plot the impulse response functions
ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# Combine the estimates in one single dataframe
csi_nsi_m <- as.data.frame(cbind(ir.regular$ir, ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
colnames(csi_nsi_m) <- c('csi_nsi_m_r','csi_nsi_m', 'csi_nsi_m_l','csi_nsi_m_u')


#### PART 2: Response of Economic Activity to NSI shock

# Response of NAB capital expenditure

y  <- data$capexinvestsd 
x  <- data$nsisd 
w  <- cbind(data$capexinvestsd,data$buscondsd, data$dunempr, 
            lagmatrix( cbind(data$nsisd, data$capexinvestsd, data$dunempr, data$buscondsd) , P ) ) 
# Create lambda options
lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# Remove NA rows due to lags
LPdata <- cbind(y,x,w)
LPdata <- na.omit(LPdata)
w <- LPdata[,3:ncol(LPdata)]
y <- LPdata[,1]
x <- LPdata[,2]
# Run a regular local projection (Jorda 2005).
ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# Run a smooth local projection
ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# Add confidence intervals to the smooth local projections and plot the impulse response functions
ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# Combine the estimates in one single dataframe
capex_nsi <- as.data.frame(cbind(ir.regular$ir, ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
colnames(capex_nsi) <- c('capex_nsi_r','capex_nsi', 'capex_nsi_l','capex_nsi_u')

# Response of change in unemployment rate

y  <- data$dunempr# Response variable
x  <- data$nsisd # Endogenous variable related to the shock
w  <- cbind(data$capexinvestsd, data$dunempr, data$buscondsd,
            lagmatrix( cbind(data$nsisd, data$capexinvestsd, data$dunempr,data$buscondsd) , P ) ) 
# Create lambda options
lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# Remove NA rows due to lags
LPdata <- cbind(y,x,w)
LPdata <- na.omit(LPdata)
w <- LPdata[,3:ncol(LPdata)]
y <- LPdata[,1]
x <- LPdata[,2]
# Run a regular local projection (Jorda 2005).
ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# Run a smooth local projection
ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# Add confidence intervals to the smooth local projections and plot the impulse response functions
ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# Combine the estimates in one single dataframe
dunempr_nsi <- as.data.frame(cbind(ir.regular$ir, ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
colnames(dunempr_nsi) <- c('dunempr_nsi_r','dunempr_nsi', 'dunempr_nsi_l','dunempr_nsi_u')


# Response of Business Condition Index

y  <- data$buscondsd # Response variable
x  <- data$nsisd # Endogenous variable related to the shock
w  <- cbind(data$capexinvestsd, data$buscondsd, data$dunempr,
            lagmatrix( cbind(data$nsisd, data$buscondsd,data$capexinvestsd, data$dunempr) , P ) ) 
# Create lambda options
lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# Remove NA rows due to lags
LPdata <- cbind(y,x,w)
LPdata <- na.omit(LPdata)
w <- LPdata[,3:ncol(LPdata)]
y <- LPdata[,1]
x <- LPdata[,2]
# Run a regular local projection (Jorda 2005).
ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# Run a smooth local projection
ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# Add confidence intervals to the smooth local projections and plot the impulse response functions
ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# Combine the estimates in one single dataframe
bci_nsi <- as.data.frame(cbind(ir.regular$ir, ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
colnames(bci_nsi) <- c('bci_nsi_r','bci_nsi', 'bci_nsi_l','bci_nsi_u')


#### PART 3: Response of Economic Activity to BCI shock

# Response of NAB capital expenditure

y  <- data$capexinvestsd# Response variable
x  <- data$buscondsd # Endogenous variable related to the shock
w  <- cbind(data$capexinvestsd, data$nsisd, data$dunempr,
            lagmatrix( cbind(data$nsisd, data$buscondsd,data$capexinvestsd, data$dunempr) , P ) ) 
# Create lambda options
lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# Remove NA rows due to lags
LPdata <- cbind(y,x,w)
LPdata <- na.omit(LPdata)
w <- LPdata[,3:ncol(LPdata)]
y <- LPdata[,1]
x <- LPdata[,2]
# Run a regular local projection (Jorda 2005).
ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# Run a smooth local projection
ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# Add confidence intervals to the smooth local projections and plot the impulse response functions
ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# Combine the estimates in one single dataframe
capex_bci <- as.data.frame(cbind(ir.regular$ir, ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
colnames(capex_bci) <- c('capex_bci_r','capex_bci', 'capex_bci_l','capex_bci_u')

# Response of change in unemployment rate

y  <- data$dunempr# Response variable
x  <- data$buscondsd # Endogenous variable related to the shock
w  <- cbind(data$capexinvestsd, data$nsisd, data$dunempr,
            lagmatrix( cbind(data$nsisd, data$buscondsd,data$capexinvestsd, data$dunempr) , P ) ) 
# Create lambda options
lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# Remove NA rows due to lags
LPdata <- cbind(y,x,w)
LPdata <- na.omit(LPdata)
w <- LPdata[,3:ncol(LPdata)]
y <- LPdata[,1]
x <- LPdata[,2]
# Run a regular local projection (Jorda 2005).
ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# Run a smooth local projection
ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# Add confidence intervals to the smooth local projections and plot the impulse response functions
ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# Combine the estimates in one single dataframe
dunempr_bci <- as.data.frame(cbind(ir.regular$ir, ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
colnames(dunempr_bci) <- c('dunempr_bci_r','dunempr_bci', 'dunempr_bci_l','dunempr_bci_u')



#### PART 4: Response of Economic Activity to NUI shock

# Response of NAB capital expenditure

y  <- data$capexinvestsd# Response variable
x  <- data$nuisd # Endogenous variable related to the shock
w  <- cbind(data$capexinvestsd, data$buscondsd, data$dunempr, data$nsisd, 
            lagmatrix( cbind(data$nuisd, data$buscondsd,data$capexinvestsd, data$dunempr, data$nsisd) , P ) ) 
# Create lambda options
lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# Remove NA rows due to lags
LPdata <- cbind(y,x,w)
LPdata <- na.omit(LPdata)
w <- LPdata[,3:ncol(LPdata)]
y <- LPdata[,1]
x <- LPdata[,2]
# Run a regular local projection (Jorda 2005).
ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# Run a smooth local projection
ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# Add confidence intervals to the smooth local projections and plot the impulse response functions
ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# Combine the estimates in one single dataframe
capex_nui <- as.data.frame(cbind(ir.regular$ir, ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
colnames(capex_nui ) <- c('capex_nui_r','capex_nui', 'capex_nui_l','capex_nui_u')


# Response of change in unemployment rate

y  <- data$dunempr# Response variable
x  <- data$nuisd # Endogenous variable related to the shock
w  <- cbind(data$capexinvestsd, data$buscondsd, data$dunempr, data$nsisd, 
            lagmatrix( cbind(data$nuisd, data$buscondsd,data$capexinvestsd, data$dunempr, data$nsisd) , P ) ) 
# Create lambda options
lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# Remove NA rows due to lags
LPdata <- cbind(y,x,w)
LPdata <- na.omit(LPdata)
w <- LPdata[,3:ncol(LPdata)]
y <- LPdata[,1]
x <- LPdata[,2]
# Run a regular local projection (Jorda 2005).
ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# Run a smooth local projection
ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# Add confidence intervals to the smooth local projections and plot the impulse response functions
ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# Combine the estimates in one single dataframe
dunempr_nui <- as.data.frame(cbind(ir.regular$ir, ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
colnames(dunempr_nui) <- c('dunempr_nui_r','dunempr_nui', 'dunempr_nui_l','dunempr_nui_u')

# Response of Business Condition Index

y  <- data$buscondsd # Response variable
x  <- data$nuisd # Endogenous variable related to the shock
w  <- cbind(data$capexinvestsd, data$buscondsd, data$dunempr, data$nsisd,
            lagmatrix( cbind(data$nuisd, data$buscondsd,data$capexinvestsd, data$dunempr, data$nsisd) , P ) ) 
# Create lambda options
lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# Remove NA rows due to lags
LPdata <- cbind(y,x,w)
LPdata <- na.omit(LPdata)
w <- LPdata[,3:ncol(LPdata)]
y <- LPdata[,1]
x <- LPdata[,2]
# Run a regular local projection (Jorda 2005).
ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# Run a smooth local projection
ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# Add confidence intervals to the smooth local projections and plot the impulse response functions
ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# Combine the estimates in one single dataframe
bci_nui <- as.data.frame(cbind(ir.regular$ir, ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
colnames(bci_nui) <- c('bci_nui_r','bci_nui', 'bci_nui_l','bci_nui_u')


#### PART 4: Response of Housing Price Growth to H-NSI shock

# Sydney

y  <- data$sydney_hpg # Response variable
x  <- data$sydney_hnsisd # Endogenous variable related to the shock
w  <- cbind(data$sydney_hpg,
            lagmatrix( cbind(data$sydney_hpg,data$sydney_hnsisd ) , P ) ) 
# Create lambda options
lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# Remove NA rows due to lags
LPdata <- cbind(y,x,w)
LPdata <- na.omit(LPdata)
w <- LPdata[,3:ncol(LPdata)]
y <- LPdata[,1]
x <- LPdata[,2]
# Run a regular local projection (Jorda 2005).
ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# Run a smooth local projection
ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# Add confidence intervals to the smooth local projections and plot the impulse response functions
ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# Combine the estimates in one single dataframe
sydney_hpg_hnsi <- as.data.frame(cbind(ir.regular$ir, ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
colnames(sydney_hpg_hnsi) <- c('sydney_hpg_hnsi_r','sydney_hpg_hnsi', 'sydney_hpg_hnsi_l','sydney_hpg_hnsi_u')

# Melbourne

y  <- data$melb_hpg # Response variable
x  <- data$melb_hnsisd # Endogenous variable related to the shock
w  <- cbind(data$melb_hpg,
            lagmatrix( cbind(data$melb_hpg,data$melb_hnsisd ) , P ) ) 
# Create lambda options
lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# Remove NA rows due to lags
LPdata <- cbind(y,x,w)
LPdata <- na.omit(LPdata)
w <- LPdata[,3:ncol(LPdata)]
y <- LPdata[,1]
x <- LPdata[,2]
# Run a regular local projection (Jorda 2005).
ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# Run a smooth local projection
ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# Add confidence intervals to the smooth local projections and plot the impulse response functions
ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# Combine the estimates in one single dataframe
melb_hpg_hnsi <- as.data.frame(cbind(ir.regular$ir, ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
colnames(melb_hpg_hnsi) <- c('melb_hpg_hnsi_r','melb_hpg_hnsi', 'melb_hpg_hnsi_l','melb_hpg_hnsi_u')
