###################################################################
# robustness_LP.R
# This program uses Local Projections and Smooth Local Projections
# to estimate impulse responses of consumer sentiment 
# and economic activity to NSI and NUI shocks
# Robustness results in the Appendix
####################################################################

### SET UP

# Environment
rm(list=ls())
setwd("~/NSI RDP/Codes/R")
library(lubridate)
library(tfplot)
library(plyr)
library(dplyr)

# Bring in the LP and SLP function
source("lproj.R")


# capex, dunempr, buscond controlling for NUI/NSI and AVIX
# capex and dunempr to NSI and NUI controlling for business confidence 
# and consumer sentiment separately

# Load the data
data <- read.csv("monthly_data.csv") # read csv file 
data$date <- as.Date(data$date) 

# Merge with A VIX data
avix <- read.csv("avix.csv")
avix$date <- floor_date(ymd(avix$date), 'month')
data_avix <- merge(data, avix, by='date') 

#set up parameters
P <- 2 # number of lags of rhs variables
h1<- 0 # Set to 0 to have the shock hit in period 0, 1 to have the shock hit in period 1
H <- 12 # Number of horizons

## Robustness of responses to NSI shock

# # Response of NAB capital expenditure
# # controlling for A VIX and NUI
# 
# y  <- data_avix$capexinvestsd 
# x  <- data_avix$nsisd 
# w  <- cbind(data_avix$capexinvestsd, data_avix$buscondsd, data_avix$dunempr, data_avix$avixsd, data_avix$nuisd,
#             lagmatrix( cbind(data_avix$nsisd, data_avix$capexinvestsd, data_avix$dunempr, data_avix$buscondsd, data_avix$avixsd, data_avix$nuisd) , P ) ) 
# # Create lambda options
# lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# # Remove NA rows due to lags
# LPdata <- cbind(y,x,w)
# LPdata <- na.omit(LPdata)
# w <- LPdata[,3:ncol(LPdata)]
# y <- LPdata[,1]
# x <- LPdata[,2]
# # Run a regular local projection (Jorda 2005).
# ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# # Run a smooth local projection
# ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
# ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# # Add confidence intervals to the smooth local projections and plot the impulse response functions
# ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# # Combine the estimates in one single dataframe
# capex_nsi <- as.data.frame(cbind(ir.regular$ir, ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
# colnames(capex_nsi) <- c('capex_nsi_r','capex_nsi', 'capex_nsi_l','capex_nsi_u')
# 
# # Response of change in unemployment rate
# # controlling for A VIX and NUI
# 
# y  <- data_avix$dunempr# Response variable
# x  <- data_avix$nsisd # Endogenous variable related to the shock
# w  <- cbind(data_avix$capexinvestsd, data_avix$buscondsd, data_avix$dunempr, data_avix$avixsd, data_avix$nuisd,
#             lagmatrix( cbind(data_avix$nsisd, data_avix$buscondsd,data_avix$capexinvestsd, data_avix$dunempr, data_avix$avixsd, data_avix$nuisd) , P ) ) 
# # Create lambda options
# lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# # Remove NA rows due to lags
# LPdata_avix <- cbind(y,x,w)
# LPdata_avix <- na.omit(LPdata_avix)
# w <- LPdata_avix[,3:ncol(LPdata_avix)]
# y <- LPdata_avix[,1]
# x <- LPdata_avix[,2]
# # Run a regular local projection (Jorda 2005).
# ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# # Run a smooth local projection
# ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
# ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# # Add confidence intervals to the smooth local projections and plot the impulse response functions
# ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# # Combine the estimates in one single data_avixframe
# dunempr_nsi <- as.data.frame(cbind(ir.regular$ir, ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
# colnames(dunempr_nsi) <- c('dunempr_nsi_r','dunempr_nsi', 'dunempr_nsi_l','dunempr_nsi_u')
# 
# 
# # Response of Business Condition Index
# # controlling for A VIX and NUI
# 
# y  <- data_avix$buscondsd # Response variable
# x  <- data_avix$nsisd # Endogenous variable related to the shock
# w  <- cbind(data_avix$capexinvestsd, data_avix$buscondsd, data_avix$dunempr,data_avix$avix,data_avix$nuisd,
#             lagmatrix( cbind(data_avix$nsisd, data_avix$buscondsd,data_avix$capexinvestsd, data_avix$dunempr,data_avix$avix,data_avix$nuisd) , P ) ) 
# # Create lambda options
# lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# # Remove NA rows due to lags
# LPdata_avix <- cbind(y,x,w)
# LPdata_avix <- na.omit(LPdata_avix)
# w <- LPdata_avix[,3:ncol(LPdata_avix)]
# y <- LPdata_avix[,1]
# x <- LPdata_avix[,2]
# # Run a regular local projection (Jorda 2005).
# ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# # Run a smooth local projection
# ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
# ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# # Add confidence intervals to the smooth local projections and plot the impulse response functions
# ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# # Combine the estimates in one single data_avixframe
# bci_nsi <- as.data.frame(cbind(ir.regular$ir, ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
# colnames(bci_nsi) <- c('bci_nsi_r','bci_nsi', 'bci_nsi_l','bci_nsi_u')
# 
# nsishocks_avixnui <- cbind(dunempr_nsi,capex_nsi,bci_nsi)
# write.csv(nsishocks_avixnui, "nsishocks_avixnui.csv")

# Response of NAB capital expenditure
# controlling for A VIX and NUI

y  <- data$capexinvestsd 
x  <- data$nsisd 
w  <- cbind(data$capexinvestsd, data$buscondsd, data$dunempr,  data$nuisd,
            lagmatrix( cbind(data$nsisd, data$capexinvestsd, data$dunempr, data$buscondsd,  data$nuisd) , P ) ) 
# Create lambda options
lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# Remove NA rows due to lags
LPdata <- cbind(y,x,w)
LPdata <- na.omit(LPdata)
w <- LPdata[,3:ncol(LPdata)]
y <- LPdata[,1]
x <- LPdata[,2]
# Run a regular local projection (Jorda 2005).
ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# Run a smooth local projection
ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# Add confidence intervals to the smooth local projections and plot the impulse response functions
ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# Combine the estimates in one single dataframe
capex_nsi <- as.data.frame(cbind(ir.regular$ir, ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
colnames(capex_nsi) <- c('capex_nsi_r','capex_nsi', 'capex_nsi_l','capex_nsi_u')

# Response of change in unemployment rate
# controlling for A VIX and NUI

y  <- data$dunempr# Response variable
x  <- data$nsisd # Endogenous variable related to the shock
w  <- cbind(data$capexinvestsd, data$buscondsd, data$dunempr,  data$nuisd,
            lagmatrix( cbind(data$nsisd, data$buscondsd,data$capexinvestsd, data$dunempr,  data$nuisd) , P ) ) 
# Create lambda options
lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# Remove NA rows due to lags
LPdata <- cbind(y,x,w)
LPdata <- na.omit(LPdata)
w <- LPdata[,3:ncol(LPdata)]
y <- LPdata[,1]
x <- LPdata[,2]
# Run a regular local projection (Jorda 2005).
ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# Run a smooth local projection
ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# Add confidence intervals to the smooth local projections and plot the impulse response functions
ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# Combine the estimates in one single dataframe
dunempr_nsi <- as.data.frame(cbind(ir.regular$ir, ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
colnames(dunempr_nsi) <- c('dunempr_nsi_r','dunempr_nsi', 'dunempr_nsi_l','dunempr_nsi_u')


# Response of Business Condition Index
# controlling for A VIX and NUI

y  <- data$buscondsd # Response variable
x  <- data$nsisd # Endogenous variable related to the shock
w  <- cbind(data$capexinvestsd, data$buscondsd, data$dunempr,data$nuisd,
            lagmatrix( cbind(data$nsisd, data$buscondsd,data$capexinvestsd, data$dunempr,data$nuisd) , P ) ) 
# Create lambda options
lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# Remove NA rows due to lags
LPdata <- cbind(y,x,w)
LPdata <- na.omit(LPdata)
w <- LPdata[,3:ncol(LPdata)]
y <- LPdata[,1]
x <- LPdata[,2]
# Run a regular local projection (Jorda 2005).
ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# Run a smooth local projection
ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# Add confidence intervals to the smooth local projections and plot the impulse response functions
ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# Combine the estimates in one single dataframe
bci_nsi <- as.data.frame(cbind(ir.regular$ir, ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
colnames(bci_nsi) <- c('bci_nsi_r','bci_nsi', 'bci_nsi_l','bci_nsi_u')

nsishocks_nui <- cbind(dunempr_nsi,capex_nsi,bci_nsi)
write.csv(nsishocks_nui, "nsishocks_nui.csv")


# Response of NAB capital expenditure
# controlling for NAB business confidence index

y  <- data$capexinvestsd 
x  <- data$nsisd 
w  <- cbind(data$capexinvestsd, data$buscondsd, data$dunempr, data$busconfsd,
            lagmatrix( cbind(data$nsisd, data$buscondsd, data$capexinvestsd, data$dunempr, data$busconfsd) , P ) ) 
# Create lambda options
lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# Remove NA rows due to lags
LPdata <- cbind(y,x,w)
LPdata <- na.omit(LPdata)
w <- LPdata[,3:ncol(LPdata)]
y <- LPdata[,1]
x <- LPdata[,2]
# Run a regular local projection (Jorda 2005).
ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# Run a smooth local projection
ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# Add confidence intervals to the smooth local projections and plot the impulse response functions
ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# Combine the estimates in one single dataframe
capex_nsi <- as.data.frame(cbind(ir.regular$ir, ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
colnames(capex_nsi) <- c('capex_nsi_r','capex_nsi', 'capex_nsi_l','capex_nsi_u')

# Response of change in unemployment rate
# controlling for NAB business confidence index

y  <- data$dunempr# Response variable
x  <- data$nsisd # Endogenous variable related to the shock
w  <- cbind(data$capexinvestsd, data$buscondsd, data$dunempr, data$busconfsd,
            lagmatrix( cbind(data$nsisd, data$buscondsd,data$capexinvestsd, data$dunempr, data$busconfsd) , P ) ) 
# Create lambda options
lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# Remove NA rows due to lags
LPdata <- cbind(y,x,w)
LPdata <- na.omit(LPdata)
w <- LPdata[,3:ncol(LPdata)]
y <- LPdata[,1]
x <- LPdata[,2]
# Run a regular local projection (Jorda 2005).
ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# Run a smooth local projection
ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# Add confidence intervals to the smooth local projections and plot the impulse response functions
ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# Combine the estimates in one single dataframe
dunempr_nsi <- as.data.frame(cbind(ir.regular$ir, ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
colnames(dunempr_nsi) <- c('dunempr_nsi_r','dunempr_nsi', 'dunempr_nsi_l','dunempr_nsi_u')


# Response of Business Condition Index
# controlling for NAB business confidence index

y  <- data$buscondsd # Response variable
x  <- data$nsisd # Endogenous variable related to the shock
w  <- cbind(data$capexinvestsd, data$buscondsd, data$dunempr,data$busconfsd,
            lagmatrix( cbind(data$nsisd, data$buscondsd,data$capexinvestsd, data$dunempr,data$busconfsd) , P ) ) 
# Create lambda options
lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# Remove NA rows due to lags
LPdata <- cbind(y,x,w)
LPdata <- na.omit(LPdata)
w <- LPdata[,3:ncol(LPdata)]
y <- LPdata[,1]
x <- LPdata[,2]
# Run a regular local projection (Jorda 2005).
ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# Run a smooth local projection
ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# Add confidence intervals to the smooth local projections and plot the impulse response functions
ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# Combine the estimates in one single dataframe
bci_nsi <- as.data.frame(cbind(ir.regular$ir, ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
colnames(bci_nsi) <- c('bci_nsi_r','bci_nsi', 'bci_nsi_l','bci_nsi_u')

nsishocks_conf <- cbind(dunempr_nsi,capex_nsi,bci_nsi)
write.csv(nsishocks_conf , "nsishocks_conf.csv")

# Response of NAB capital expenditure
# controlling for ANZ RM consumer sentiment index

y  <- data$capexinvestsd 
x  <- data$nsisd 
w  <- cbind(data$capexinvestsd, data$buscondsd, data$dunempr, data$csisd,
            lagmatrix( cbind(data$nsisd, data$capexinvestsd, data$buscondsd, data$dunempr, data$csisd) , P ) ) 
# Create lambda options
lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# Remove NA rows due to lags
LPdata <- cbind(y,x,w)
LPdata <- na.omit(LPdata)
w <- LPdata[,3:ncol(LPdata)]
y <- LPdata[,1]
x <- LPdata[,2]
# Run a regular local projection (Jorda 2005).
ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# Run a smooth local projection
ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# Add confidence intervals to the smooth local projections and plot the impulse response functions
ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# Combine the estimates in one single dataframe
capex_nsi <- as.data.frame(cbind(ir.regular$ir, ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
colnames(capex_nsi) <- c('capex_nsi_r','capex_nsi', 'capex_nsi_l','capex_nsi_u')

# Response of change in unemployment rate
# controlling for ANZ RM consumer sentiment index

y  <- data$dunempr# Response variable
x  <- data$nsisd # Endogenous variable related to the shock
w  <- cbind(data$capexinvestsd, data$buscondsd, data$dunempr, data$csisd,
            lagmatrix( cbind(data$nsisd, data$buscondsd, data$capexinvestsd, data$dunempr, data$csisd) , P ) ) 
# Create lambda options
lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# Remove NA rows due to lags
LPdata <- cbind(y,x,w)
LPdata <- na.omit(LPdata)
w <- LPdata[,3:ncol(LPdata)]
y <- LPdata[,1]
x <- LPdata[,2]
# Run a regular local projection (Jorda 2005).
ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# Run a smooth local projection
ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# Add confidence intervals to the smooth local projections and plot the impulse response functions
ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# Combine the estimates in one single dataframe
dunempr_nsi <- as.data.frame(cbind(ir.regular$ir, ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
colnames(dunempr_nsi) <- c('dunempr_nsi_r','dunempr_nsi', 'dunempr_nsi_l','dunempr_nsi_u')


# Response of Business Condition Index
# controlling for ANZ RM consumer sentiment index

y  <- data$buscondsd # Response variable
x  <- data$nsisd # Endogenous variable related to the shock
w  <- cbind(data$capexinvestsd, data$buscondsd, data$dunempr,data$csisd,
            lagmatrix( cbind(data$nsisd, data$buscondsd,data$capexinvestsd, data$dunempr,data$csisd) , P ) ) 
# Create lambda options
lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# Remove NA rows due to lags
LPdata <- cbind(y,x,w)
LPdata <- na.omit(LPdata)
w <- LPdata[,3:ncol(LPdata)]
y <- LPdata[,1]
x <- LPdata[,2]
# Run a regular local projection (Jorda 2005).
ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# Run a smooth local projection
ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# Add confidence intervals to the smooth local projections and plot the impulse response functions
ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# Combine the estimates in one single dataframe
bci_nsi <- as.data.frame(cbind(ir.regular$ir, ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
colnames(bci_nsi) <- c('bci_nsi_r','bci_nsi', 'bci_nsi_l','bci_nsi_u')

nsishocks_csi <- cbind(dunempr_nsi,capex_nsi,bci_nsi)
write.csv(nsishocks_csi, "nsishocks_csi.csv")

## Robustness of responses to NUI shock

# Response of NAB capital expenditure
# controlling for A VIX and NSI

y  <- data$capexinvestsd 
x  <- data$nuisd 
w  <- cbind(data$capexinvestsd, data$buscondsd, data$dunempr, data$avixsd, data$nsisd,
            lagmatrix( cbind(data$nuisd, data$capexinvestsd, data$dunempr, data$buscondsd, data$avixsd, data$nsisd) , P ) ) 
# Create lambda options
lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# Remove NA rows due to lags
LPdata <- cbind(y,x,w)
LPdata <- na.omit(LPdata)
w <- LPdata[,3:ncol(LPdata)]
y <- LPdata[,1]
x <- LPdata[,2]
# Run a regular local projection (Jorda 2005).
ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# Run a smooth local projection
ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# Add confidence intervals to the smooth local projections and plot the impulse response functions
ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# Combine the estimates in one single dataframe
capex_nui <- as.data.frame(cbind(ir.regular$ir, ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
colnames(capex_nui) <- c('capex_nui_r','capex_nui', 'capex_nui_l','capex_nui_u')

# Response of change in unemployment rate
# controlling for A VIX and NSI

y  <- data$dunempr# Response variable
x  <- data$nuisd # Endogenous variable related to the shock
w  <- cbind(data$capexinvestsd, data$buscondsd, data$dunempr, data$avixsd, data$nsisd,
            lagmatrix( cbind(data$nuisd, data$buscondsd,data$capexinvestsd, data$dunempr, data$avixsd, data$nsisd) , P ) ) 
# Create lambda options
lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# Remove NA rows due to lags
LPdata <- cbind(y,x,w)
LPdata <- na.omit(LPdata)
w <- LPdata[,3:ncol(LPdata)]
y <- LPdata[,1]
x <- LPdata[,2]
# Run a regular local projection (Jorda 2005).
ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# Run a smooth local projection
ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# Add confidence intervals to the smooth local projections and plot the impulse response functions
ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# Combine the estimates in one single dataframe
dunempr_nui <- as.data.frame(cbind(ir.regular$ir, ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
colnames(dunempr_nui) <- c('dunempr_nui_r','dunempr_nui', 'dunempr_nui_l','dunempr_nui_u')


# Response of Business Condition Index
# controlling for A VIX and NSI

y  <- data$buscondsd # Response variable
x  <- data$nuisd # Endogenous variable related to the shock
w  <- cbind(data$capexinvestsd, data$buscondsd, data$dunempr,data$avix,data$nsisd,
            lagmatrix( cbind(data$nuisd, data$buscondsd,data$capexinvestsd, data$dunempr,data$avix,data$nsisd) , P ) ) 
# Create lambda options
lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# Remove NA rows due to lags
LPdata <- cbind(y,x,w)
LPdata <- na.omit(LPdata)
w <- LPdata[,3:ncol(LPdata)]
y <- LPdata[,1]
x <- LPdata[,2]
# Run a regular local projection (Jorda 2005).
ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# Run a smooth local projection
ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# Add confidence intervals to the smooth local projections and plot the impulse response functions
ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# Combine the estimates in one single dataframe
bci_nui <- as.data.frame(cbind(ir.regular$ir, ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
colnames(bci_nui) <- c('bci_nui_r','bci_nui', 'bci_nui_l','bci_nui_u')

nuishocks_nsi <- cbind(dunempr_nui,capex_nui,bci_nui)
write.csv(nuishocks_nsi, "nuishocks_nsi.csv")


# Response of NAB capital expenditure
# controlling for NAB business confidence index

y  <- data$capexinvestsd 
x  <- data$nuisd 
w  <- cbind(data$capexinvestsd, data$buscondsd, data$dunempr, data$busconfsd,
            lagmatrix( cbind(data$nuisd, data$capexinvestsd, data$buscondsd, data$dunempr, data$busconfsd) , P ) ) 
# Create lambda options
lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# Remove NA rows due to lags
LPdata <- cbind(y,x,w)
LPdata <- na.omit(LPdata)
w <- LPdata[,3:ncol(LPdata)]
y <- LPdata[,1]
x <- LPdata[,2]
# Run a regular local projection (Jorda 2005).
ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# Run a smooth local projection
ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# Add confidence intervals to the smooth local projections and plot the impulse response functions
ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# Combine the estimates in one single dataframe
capex_nui <- as.data.frame(cbind(ir.regular$ir, ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
colnames(capex_nui) <- c('capex_nui_r','capex_nui', 'capex_nui_l','capex_nui_u')

# Response of change in unemployment rate
# controlling for NAB business confidence index

y  <- data$dunempr# Response variable
x  <- data$nuisd # Endogenous variable related to the shock
w  <- cbind(data$capexinvestsd, data$buscondsd, data$dunempr, data$busconfsd,
            lagmatrix( cbind(data$nuisd,data$buscondsd, data$capexinvestsd, data$dunempr, data$busconfsd) , P ) ) 
# Create lambda options
lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# Remove NA rows due to lags
LPdata <- cbind(y,x,w)
LPdata <- na.omit(LPdata)
w <- LPdata[,3:ncol(LPdata)]
y <- LPdata[,1]
x <- LPdata[,2]
# Run a regular local projection (Jorda 2005).
ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# Run a smooth local projection
ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# Add confidence intervals to the smooth local projections and plot the impulse response functions
ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# Combine the estimates in one single dataframe
dunempr_nui <- as.data.frame(cbind(ir.regular$ir, ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
colnames(dunempr_nui) <- c('dunempr_nui_r','dunempr_nui', 'dunempr_nui_l','dunempr_nui_u')


# Response of Business Condition Index
# controlling for NAB business confidence index

y  <- data$buscondsd # Response variable
x  <- data$nuisd # Endogenous variable related to the shock
w  <- cbind(data$capexinvestsd, data$buscondsd, data$dunempr,data$busconfsd,
            lagmatrix( cbind(data$nuisd, data$buscondsd,data$capexinvestsd, data$dunempr,data$busconfsd) , P ) ) 
# Create lambda options
lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# Remove NA rows due to lags
LPdata <- cbind(y,x,w)
LPdata <- na.omit(LPdata)
w <- LPdata[,3:ncol(LPdata)]
y <- LPdata[,1]
x <- LPdata[,2]
# Run a regular local projection (Jorda 2005).
ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# Run a smooth local projection
ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# Add confidence intervals to the smooth local projections and plot the impulse response functions
ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# Combine the estimates in one single dataframe
bci_nui <- as.data.frame(cbind(ir.regular$ir, ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
colnames(bci_nui) <- c('bci_nui_r','bci_nui', 'bci_nui_l','bci_nui_u')

nuishocks_conf <- cbind(dunempr_nui,capex_nui,bci_nui)
write.csv(nuishocks_conf, "nuishocks_conf.csv")

# Response of NAB capital expenditure
# controlling for ANZ RM consumer sentiment index

y  <- data$capexinvestsd 
x  <- data$nuisd 
w  <- cbind(data$capexinvestsd, data$buscondsd, data$dunempr, data$csisd,
            lagmatrix( cbind(data$nuisd, data$capexinvestsd, data$buscondsd, data$dunempr, data$csisd) , P ) ) 
# Create lambda options
lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# Remove NA rows due to lags
LPdata <- cbind(y,x,w)
LPdata <- na.omit(LPdata)
w <- LPdata[,3:ncol(LPdata)]
y <- LPdata[,1]
x <- LPdata[,2]
# Run a regular local projection (Jorda 2005).
ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# Run a smooth local projection
ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# Add confidence intervals to the smooth local projections and plot the impulse response functions
ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# Combine the estimates in one single dataframe
capex_nui <- as.data.frame(cbind(ir.regular$ir, ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
colnames(capex_nui) <- c('capex_nui_r','capex_nui', 'capex_nui_l','capex_nui_u')

# Response of change in unemployment rate
# controlling for ANZ RM consumer sentiment index

y  <- data$dunempr# Response variable
x  <- data$nuisd # Endogenous variable related to the shock
w  <- cbind(data$capexinvestsd, data$buscondsd, data$dunempr, data$csisd,
            lagmatrix( cbind(data$nuisd, data$buscondsd, data$capexinvestsd, data$dunempr, data$csisd) , P ) ) 
# Create lambda options
lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# Remove NA rows due to lags
LPdata <- cbind(y,x,w)
LPdata <- na.omit(LPdata)
w <- LPdata[,3:ncol(LPdata)]
y <- LPdata[,1]
x <- LPdata[,2]
# Run a regular local projection (Jorda 2005).
ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# Run a smooth local projection
ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# Add confidence intervals to the smooth local projections and plot the impulse response functions
ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# Combine the estimates in one single dataframe
dunempr_nui <- as.data.frame(cbind(ir.regular$ir, ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
colnames(dunempr_nui) <- c('dunempr_nui_r','dunempr_nui', 'dunempr_nui_l','dunempr_nui_u')


# Response of Business Condition Index
# controlling for ANZ RM consumer sentiment index

y  <- data$buscondsd # Response variable
x  <- data$nuisd # Endogenous variable related to the shock
w  <- cbind(data$capexinvestsd, data$buscondsd, data$dunempr,data$csisd,
            lagmatrix( cbind(data$nuisd, data$buscondsd,data$capexinvestsd, data$dunempr,data$csisd) , P ) ) 
# Create lambda options
lambda <- c(0.0001,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,9,10)/1000
# Remove NA rows due to lags
LPdata <- cbind(y,x,w)
LPdata <- na.omit(LPdata)
w <- LPdata[,3:ncol(LPdata)]
y <- LPdata[,1]
x <- LPdata[,2]
# Run a regular local projection (Jorda 2005).
ir.regular  <- lproj( y=y , x=x , w=w , const=TRUE , type='reg' , H=H , h1=h1 )
# Run a smooth local projection
ir.smooth   <- lproj( y=y , x=x , w=w , const=TRUE , type='smooth' , H=H , h1=h1 , r=2 , lambda=lambda )
ir.smooth   <- lproj.cv( ir.smooth , 5 ) # Pick the optimal coefficients as result of minimum RSS from choice of lambda
# Add confidence intervals to the smooth local projections and plot the impulse response functions
ir.smooth <- lproj.conf(ir.smooth, ir.smooth$idx.opt)
# Combine the estimates in one single dataframe
bci_nui <- as.data.frame(cbind(ir.regular$ir, ir.smooth$ir.opt, ir.smooth$irc[,1],ir.smooth$irc[,2]))
colnames(bci_nui) <- c('bci_nui_r','bci_nui', 'bci_nui_l','bci_nui_u')

nuishocks_csi <- cbind(dunempr_nui,capex_nui,bci_nui)
write.csv(nuishocks_csi, "nuishocks_csi.csv")