***************************** 2. IMPORT HH DATA *******************************
**************************** DATE: AUGUST 2020 ********************************
**************************** AUTHOR: MIKE MAJOR *******************************
*************** ADAPTED FROM BILSTON, JOHNSTON AND READ (2015) ****************

****************************************************************************
*Import loan-level data               
****************************************************************************
if ${year} == 2018 {
	use "${hes_location}SIH2017_18\sih17bl.dta", clear
	}
if ${year} == 2016 & ${hes} == 1 {
	use "${hes_location}SIH2015_16\hes15bl.dta", clear
	}
if ${year} == 2016 & ${hes} == 0 {
	use "${hes_location}SIH2015_16\sih15bl.dta", clear
	}
if ${year} == 2010 {
	use "${hes_location}SIH2009_10\hes10bl.dta", clear
	}
if ${year} == 2004 {
	use "${hes_location}2003_04\HES Data Files\hes03bl.dta", clear
	}
rename *, lower

*Construct Loan weights and HH ID
if ${hes} == 1 & ${year} != 2004 {
	g loanwt = heslnwt
	destring abshid , generate(new_abshid) ignore("HES" "B")
	}
if ${hes} == 1 & ${year} == 2004 {
	g loanwt = 1 // no loan weight
	destring abshid , generate(new_abshid) ignore("HES" "B")
	gen abslid = loannumb
	}	
if ${hes} == 0 {
	g loanwt = sihlnwt
	destring abshid , generate(new_abshid) ignore("SIH" "B")
	}
egen loanid= group(abslid)
destring abslid, replace
replace curintl=. if curintl==0

*Find loans for each loan type
egen loan_car = anymatch(mpurl), v(5)
egen loan_home = anymatch(mpurl), v(1/4)
egen loan_vac = anymatch(mpurl), v(6)
egen loan_oth = anymatch(mpurl), v(7)
egen loan_na = anymatch(mpurl), v(0)
egen sec_home = anymatch(lnsecln), v(1)
egen sec_oth = anymatch(lnsecln), v(2)
egen sec_none = anymatch(lnsecln), v(3)
gen sec_flag = (lnsecln==1 & mpurl>=5)

*Keep relevant variables
keep abshid new_abshid abslid amtbrln amtoln curintl mpurl lnsecln wkrepln yrrpmtl loanwt loanid loan_* sec_*

*Reshape to HH level
reshape wide loan_car loan_home loan_vac loan_oth loan_na sec_home sec_oth sec_none sec_flag abslid amtbrln amtoln curintl mpurl lnsecln wkrepln yrrpmtl, i(new_abshid) j(loanid)

*Number of loans by type of loan 
egen numloans = rowmax(abslid?*) 
egen num_car = rowtotal(loan_car?*)
egen num_home = rowtotal(loan_home?*)
egen num_oth = rowtotal(loan_oth?*)
egen num_vac = rowtotal(loan_vac?*)
egen num_na = rowtotal(loan_na?*)
egen num_tot = rowtotal(num_car num_home num_vac num_oth num_na)
egen sec_flag_tot = rowtotal(sec_flag?*) 
egen mostloans = max(numloans) 

*Balances and repayments of loans
egen amtbrtot = rowtotal(amtbrln?*), missing
egen amtowetot = rowtotal(amtoln?*), missing 
egen wkreptot = rowtotal(wkrepln?*), missing

*Sums of types of loans and repayment shares
local N = mostloans
foreach z in car home vac oth na {
  foreach type in br o {
    forvalues i=1/`N' {
      local x = "amt" + "`type'" + "ln" + "`i'"
      local y = "loan_" + "`z'" + "`i'"
      local xy = "amt" + "`type'" + "_" + "`z'" + "`i'"
      gen `xy' = `y' * `x' 
    }
  local tot = "tot" + "`type'" + "_" + "`z'"
  local comps = "amt" + "`type'" + "_" + "`z'"
  egen `tot' = rowtotal(`comps'?*), missing
 }
 local repay = "repshare_" + "`z'"
 local a = "toto_" + "`z'" 
 local b = "totbr_" + "`z'" 
 gen `repay' = `a' / `b' 
}
egen totbr_all = rowtotal(totbr_*), missing
egen toto_all = rowtotal(toto_*), missing
gen repshare_all = toto_all/totbr_all

*Sums of repayments by type of loan 
local N = mostloans
foreach z in car home vac oth na {
    forvalues i=1/`N' {
      local x = "wkrepln" + "`i'"
      local y = "loan_" + "`z'" + "`i'"
      local xy = "wkrepln" + "_" + "`z'" + "`i'"
      gen `xy' = `y' * `x' 
    }
  local totwkrep = "totwkrep" + "_" + "`z'"
  local comps = "wkrepln" + "_" + "`z'"
  egen `totwkrep' = rowtotal(`comps'?*), missing
}
egen totwkrep_all = rowtotal(totwkrep_*), missing

*CALCULATE AVERAGE INTEREST RATE FOR LOAN TYPE
**Sums of types of loans when av interest rate data is available
local N = mostloans
foreach z in car home vac oth na {
    forvalues i=1/`N' {
      local x = "amtbrln" + "`i'"
      local y = "loan_" + "`z'" + "`i'"
      local xy = "avrate_amtbr" + "_" + "`z'" + "`i'"
	  local f = "curintl" + "`i'"
      gen `xy' = `y' * `x' * `f' / `f'
    }
  local tot = "avrate_totbr" + "_" + "`z'"
  local comps = "avrate_amtbr" + "_" + "`z'"
  egen `tot' = rowtotal(`comps'?*), missing
 }
  egen avrate_totbr = rowtotal(avrate_totbr_*), missing
		
*Loan weights and average interest rates
local N = mostloans
forvalues i=1/`N' {
  local x = "amtbrln" + "`i'"
  local xy = "l" + "`i'" + "_weight"
  gen `xy' = `x' / avrate_totbr
  local a = "aveintr" + "`i'"
  local b = "curintl" + "`i'"
  gen `a' = `xy' * `b' 
  if `i' == `N' {
    egen aveintr_tot = rowtotal(aveintr?*), missing
	egen testsum = rowtotal(l?*_weight), missing
  }
}
	
*Loan weights and average interest rates by loan type
local N = mostloans
foreach z in car home vac oth na {
		forvalues i=1/`N' {
		local x = "amtbrln" + "`i'"
		local xy = "l" + "`z'" + "`i'" + "_weight"
		local y = "loan_" + "`z'" + "`i'"
		local a = "avrate_totbr_" + "`z'"
		gen `xy' = `x' / `a' * `y'
		local a = "aveintr" + "`z'" + "`i'"
		local b = "curintl" + "`i'"
		gen `a' = `xy' * `b' 
	}
	local aveintr = "aveintr" + "_" + "`z'"
	local comps = "aveintr" + "`z'"
	egen `aveintr' = rowtotal(`comps'?*), missing
}


*** CALCULATE YEAR LOANS COMMENCED
*Remove NA and implausibly old loans
forvalues i=1/`N' {
	local x = "yrrpmtl" + "`i'"
	replace `x' = . if `x' < 1950
	}
	
*Sums of types of loans when year commenced data is available
local N = mostloans
foreach z in car home vac oth na {
    forvalues i=1/`N' {
      local x = "amtbrln" + "`i'"
      local y = "loan_" + "`z'" + "`i'"
      local xy = "yrcomm_amtbr" + "_" + "`z'" + "`i'"
	  local f = "yrrpmtl" + "`i'"
      gen `xy' = `y' * `x' * `f' / `f'
    }
  local tot = "yrcomm_totbr" + "_" + "`z'"
  local comps = "yrcomm_amtbr" + "_" + "`z'"
  egen `tot' = rowtotal(`comps'?*), missing
 }

 egen yrcomm_totbr = rowtotal(yrcomm_totbr_*), missing
	
*Loan weights and average year repayments commenced
local N = mostloans
forvalues i=1/`N' {
  local x = "amtbrln" + "`i'" 
  local xy = "l_yr" + "`i'" + "_weight"
  local z = "yrrpmtl" + "`i'"
  gen `xy' = `x' / yrcomm_totbr * `z'/`z'
  local c = "yr_rp_start" + "`i'"
  local f = "yrrpmtl" + "`i'"
  gen `c' = `xy' * `f' 
  if `i' == `N' {
	egen yr_rp_start_tot = rowtotal(yr_rp_start?*), missing
	egen testsum_yr = rowtotal(l_yr?*_weight), missing
  }
}
*Loan weights and average year repayments commenced by loan type 
local N = mostloans
foreach z in car home vac oth na {
		forvalues i=1/`N' {
		local x = "amtbrln" + "`i'"
		local xy = "l_yr" + "`z'" + "`i'" + "_weight"
		local y = "loan_" + "`z'" + "`i'"
		local a = "yrcomm_totbr_" + "`z'"
		gen `xy' = `x' / `a' * `y'
		local a = "yr_rp_start" + "`z'" + "`i'"
		local b = "yrrpmtl" + "`i'"
		gen `a' = `xy' * `b' 
	}
	local yr_rp_start = "yr_rp_start" + "_" + "`z'"
	local comps = "yr_rp_start" + "`z'"
	egen `yr_rp_start' = rowtotal(`comps'?*), missing
}

*Keep relevant variables
keep abshid new_abshid abslid?* amtbrln?* amtoln?* curintl?* mpurl?* lnsecln?* wkrepln_* yrrpmtl?* loanwt loan_* repshare* tot*all *loans amt*tot wkreptot sec_flag?* tot*_* num_* totwkrep* aveintr_* yr_rp_start_*

save "Data\loans_${year}_${hes}.dta", replace

****************************************************************************
*Import superannuation from 2018 data (missing in SIH data)           
****************************************************************************
if ${year} == 2018 {
use "${hes_location}SIH2017_18\sih17bp.dta", clear
rename *, lower
destring abshid , generate(new_abshid) ignore("SIH" "B")
keep new_abshid vsuptot
collapse (sum) vsuptot, by(new_abshid)
save "Data\super${year}.dta", replace
}

****************************************************************************
*Import household level data       
****************************************************************************
if ${year} == 2018 {
	use "${hes_location}SIH2017_18\sih17bh.dta", clear
	}
if ${year} == 2016 & ${hes} == 1 {
	use "${hes_location}SIH2015_16\hes15bh.dta", clear
	}
if ${year} == 2016 & ${hes} == 0 {
	use "${hes_location}SIH2015_16\sih15bh.dta", clear
	}
if ${year} == 2010 {
	use "${hes_location}SIH2009_10\hes10bh.dta", clear
	}
if ${year} == 2004 {
	use "${hes_location}2003_04\data_third_edition\hes03bh.dta", clear
	}
rename *, lower

if ${hes} == 1 {
	g hwt = heshhwt
	destring abshid , generate(new_abshid) ignore("HES" "B")
	}
if ${hes} == 0 {
	g hwt = sihhhwt
	destring abshid , generate(new_abshid) ignore("SIH" "B")
	g exptl = .
	g extlcser = .
	}

*Recode variables across years for consistency
if ${year} == 2018 {
g state = statehec 
g age = agerhec
g capcity = aourbc 
g vtrtch = vprtch + vputch // combine private and public trusts
merge 1:1 new_abshid using "Data\super${year}.dta", nogenerate // obtain vsuptot
}
if ${year} == 2016 {
g state = statehec 
g age = agerhec
g capcity = gccsa11c
g vsuptot = vsupgch + vsupnch // combine gov and non-gov super
g vtrtch = vprtch + vputch // combine private and public trusts
}
if ${year} == 2010  {
g state = statehbc 
recode agerhbc (11 = 27) (12 = 32) (13=37) (14=42) (15=47) (16=52) (27=67) (28=72) (29=77) (30=85), gen(age)
replace age = agerhbc + 15 - 1 if agerhbc<11
replace age = agerhbc + 55 - 17 if agerhbc>16 & agerhbc<27
g capcity = methhc
g trpaych = trpay1ch + trpay2ch + trpay4ch
rename yrbuyhcf yrbuyhcb 
g vsuptot = vsupgch + vsupnch // combine gov and non-gov super
g voftch = 0 // assume no offset
g vtrtch = vprtch + vputch // combine private and public trusts
}
if ${year} == 2004  {
g state = statehbc 
recode agerhbc (11 = 27) (12 = 32) (13=37) (14=42) (15=47) (16=52) (27=67) (28=72) (29=77) (30=85), gen(age)
replace age = agerhbc + 15 - 1 if agerhbc<11
replace age = agerhbc + 55 - 17 if agerhbc>16 & agerhbc<27
g capcity = areahcf
g trpaych = trpay1ch + trpay2ch + trpay4ch
rename yrbuycf yrbuyhcb 
g vsuptot = vsupgch + vsupnch // combine gov and non-gov super
g voftch = 0 // assume no offset 
g vsipch = 0 // asssume no silent partnerships
replace votassch = votassch + vchassch // add children's assets to other assets
g dispsch8 = dispch
}

*Generate age categories
recode age (15/24 = 1) (25/34 = 2) (35/44 = 3) (45/54 = 4) (55/64 = 5) (65/100 = 6), gen(age_cat)
label define age_cat 1 "15-24" 2 "25-34" 3 "35-44" 4 "45-54" 5 "55-64" 6 "65+"
label value age_cat age_cat 
label variable age_cat "Age categories - "

*Keep relevant variables
keep abshid age age_cat capcity dcomph dep1524b dincst dispsch8 dnfamcf dpkidhbc equivh exptl extlcser famcomp grossir hvaluech hwt lfsrh liaccch liahecch liainvch liaotch liaopch liarpch liasdch liasfsch liavech lifecych netir new_abshid nocchh state tenurecf trpaych vcontch vdebch vfinch vibusch vinvotch vnrprch voftch votassch vplnch vtrtch vrprch vsharch vsipch vsuptot vubusch vvehich wealthh wkrentch yrbuyhcb

*Recode liabilities (assets recoded in main model because they depend on scenario)
g hdebt = liasdch 				// Principal outstanding on loans for selected dwelling
g hinvdebt = liarpch 			// Principal outstanding on rental property loans
g othpropdebt = liaopch 		// Principal outstanding on loans for other property (excl business and investment loans)

g ccdebt = liaccch 				// Amount of credit card debt
g mvdebt = liavech				// Principal outstanding on loans for vehicle purchases (excl business and investment loans)			
g invdebt = liainvch			// Principal outstanding on investment loans (excl business and rental property loans)
g othdebt = liaotch				// Principal outstanding on loans for other purposes (excl business and investment loans)

g studebt = liahecch+liasfsch	// Amount of HECS/HELP and Student Financial Supplement liability

g hhdebt = hdebt + hinvdebt + othpropdebt + ccdebt + mvdebt + invdebt + othdebt // exclude student loans

g propertydebt = hinvdebt + othpropdebt + hdebt
g nonpropbusccdebt = mvdebt + invdebt + othdebt
g nonhomepropertydebt = hinvdebt + othpropdebt

*Disposable income
g dincann = dispsch8*52 // Current weekly HH disposable income * 52

save "Data\bh_${year}_${hes}.dta", replace

****************************************************************************
*Combine databases
****************************************************************************
merge 1:1 new_abshid using "Data\loans_${year}_${hes}.dta" 
save "Data\hh_${year}_${hes}.dta", replace

erase "Data\bh_${year}_${hes}.dta"
erase "Data\loans_${year}_${hes}.dta" 
clear

