******************************** 1. MAIN PAGE *********************************
**************************** DATE: AUGUST 2020 ********************************
**************************** AUTHOR: MIKE MAJOR *******************************
*************** ADAPTED FROM BILSTON, JOHNSTON AND READ (2015) ****************

*Set working directories
cd "XXXX"
*Set location of SIH/HES files
global hes_location "XXXXX"

****************************************************************************
*Import variables from SIH/HES data                 
****************************************************************************

forvalues i = 2004(6)2016 {
	global year = `i'
	global hes = 1
	do "2_merge_datasets.do"
	}
forvalues i = 2016(2)2018 {
	global year = `i'
	global hes = 0
	do "2_merge_datasets.do"
	}

****************************************************************************
*Run unemployment model	for various shocks and survey years			                   
****************************************************************************

forvalues b = 0(1)8 {
	global batchUR = "rdp" + "`b'"		//name for unemployment model files
	global shock =  0.01*`b'			// employment fall shock (ppt)	
	global year = 2016
	global hes = 1
	do "3_unemployment.do"	
}

forvalues b = 6(2)8	{						
	global batchUR = "rdp" + "`b'"			
	global shock = 0.01*`b'	
forvalues i = 2004(6)2016 {
	global year = `i'
	global hes = 1
	do "3_unemployment.do"
	}
forvalues i = 2016(2)2018 {
	global year = `i'
	global hes = 0
	do "3_unemployment.do"
	}
}

****************************************************************************
*Import Henderson poverty line and HEM data             
****************************************************************************

import excel using "Data\bascon.xlsx", firstrow sheet(data) clear
save "Data\bascon.dta", replace

****************************************************************************
*Import interest rate changes since origination         
****************************************************************************

import excel using "rate_changes.xlsx", firstrow sheet(av_rate_differences) clear
save "Data\rate_changes.dta", replace

****************************************************************************
*Options                            	     
****************************************************************************
	pause on													
	global simtimes = 100				// number of simulations of unemployment model
	global loanterm = 30				// loan term in years
	global LMI_flag = 0					// 0 = LMI coverage, 1 = no LMI coverage
	global foreclosure = 0.1			// foreclosure costs as share of debt 
	global foreclosure_lvr = 90			// LVR when foreclosure costs start kicking in for bank 
	global opdebtprincipalrepay = 0.02	// share of principal paid off annually
	global ccprincipalrepay = 0.02		// share of principal paid off annually
	global min_share_for_io = 98		// min loan balance as % of orgination balance to qualify as interest only
	global max_share_for_io = 102		// max current balance as % of orgination balance to qualify as interest only
	global offsets_reduce_interest = 1	// allow offset accounts to reduce required repayment on interest-only loans, 0 = no, 1 = yes	
	
	global age_super_low = 40			// age where household consumption begins to be sensitive to super changes 
	global age_super_high = 60			// age where household consumption is fully sensitive to super changes 
	
	global htm_with_buffer = 1			// include offset/redraw in calculation of hand-to-mouth (see FBC RDP 2019)
	
	*Basic consumption
	global bascontype = 1				// 0 use Henderson poverty lines, 1 use HEM
	global fm_switch = 0				// households can access liquid assets to make repayments 0 = no , 1 = yes  
	global stress_length = 2			// number of years to distribute liquid assets for repayments		
	
****************************************************************************
*Macroeconomic scenario                    	   
****************************************************************************	

	*Employment shock
	global shock =  0.08			// employment fall shock (ppt)	
	global batchUR = "rdp" + "8"		
	*Shocks	(fall in asset values as a proportion of starting values)			 	
	global stress_equity = 0.5   
	global stress_trust = 0.3
	global stress_housing = 0.4
	global stress_nonres = 0.4
	global stress_other = 0.0	
	global stress_super = 0.3 / 0.44 // Amount to stress risky part of superannuation portfolio. Each household's super is shocked by this amount multiplied by (100-age). Dividing by 0.44 ensures average is achieved.  		
	global stress_invinc = 0.3 // fall in investment income 	
	global stress_cashrate_change = 0
	global hours_fall = 0 // rduction in hours worked for employed workers or fall in hours(%)
	global bonuscut = 0.5 // if 1 cut bonuses/overtime (% cut in bonuses)

****************************************************************************
*MPC settings for all scenarios        		   
****************************************************************************		
	global mpc_nonhs_multiplier = 2 // Multiple of mpcw from non-housing vs housing multiplier

	*Set up parameters for MPC loops (to esnure average MPCw and MPCy held constant)
	global sensitivity_w = 0.0001 // sensitivity of constant for MPCw for DTA versions
	global sensitivity_w_age = 0.001 // sensitivity of constant for MPCw for age
	global sensitivity_y = 0.001 // sensitivity of constant for MPCy	
	
	*Lowest constant to consider in MPC loops
	global mpcw_a_low = -0.3 
	global mpcw_age_a_low = -1 
	global mpcw_inc_a_low = -0.5 
	global mpcy_a_low = 0 
	global mpcy_a_htm_low = 0 
	
	*Highest constant to consider in MPC loops
	global mpcw_a_high = 0.1
	global mpcw_age_a_high = 1 
	global mpcw_inc_a_high = 0.5 			
	global mpcy_a_high = 1 
	global mpcy_a_htm_high = 1 
	
	*For DTI variation on MPCy based on Baker
	global mpcy_b =  0.062 		//Consumption to disposable income is 0.82 according to SIH data here, and coefficient is 0.75, which means 0.82*0.75=0.062
	
	*Minimum and maximise MPCy and MPCw
	global min_mpcy = 0 
	global max_mpcy = 1	
	global min_mpcw = 0
	global max_mpcw = 0.2	

	*For DTI variation on MPCw approach 
	global mpcw_dti_b = 0.002 // Coefficent on DTI for MPCw based on mpcw = a + b*DTI, if option 7 is chosen for mpcw_type
	
	*Age based MPCw formula
	global mpcw_age_b = 0.001
	
	*Income-based MPCw formula
	global mpcw_inc_b = -0.0000002
	
	*Hand-to-mouth MPCy formula	
	global mpcy_htm = 2	// double 
	global mpcw_htm = 2	 //double

****************************************************************************
*Scenarios                             		   
****************************************************************************	
	*First scenario needs iteration = 1
	global iteration = 1
	*No MRS variation - HEM
	global case = 1
	global batch = "Uniform MPC"	
	global year = 2016
	global hes = 1
	global distribution_results = 1
	global bascontype = 1				// 0 use Henderson poverty lines, 1 use HEM	
	global mpc_nonhs_multiplier = 2 	// Multiple of mpcw from non-housing vs housing multiplier
	global mpcw_type = 1				// Method for distributing MPC of wealth: 1 - uniform, 2 - DTA formula, 3 - age formula, 4 - HTM, 5 - DTI formula, 6 - income
	global mpcy_type = 1				// Method for distributing MPC of income: 1 - uniform, 2 - DTI formula, 4 - HTM
	global mpcy_av = 0.55 				// this is the average HH-weighted MPCy
	global mpcw_av = 0.03 				// this is the average HH-weighted MPCw
do "4_main_model.do"	

	*Default / MRS variation - HEM
	global year = 2016
	global case = 2	
	global batch = "Debt-varying MPC"  				
	global mpcw_type = 2				
	global mpcy_type = 2				
	global mpcw_b = 0.02				
do "4_main_model.do"
	global distribution_results = 0	
	
	*Default / MRS variation  - HPL
	global case = 3	
	global batch = "HPL" 	
	global bascontype = 0
 do"4_main_model.do"
	global bascontype = 1							

	*Default / MRS variation - Full SIH sample
	global case = 4	
	global batch = "SIH Sample 15/16" 	
	global hes = 0	
 do"4_main_model.do"
	
	*Default / MRS variation - Full SIH sample - no foreclosure
	global case = 5	
	global batch = "SIH Sample 15/16 (no foreclosure)" 	
	global foreclosure = 0				
do "4_main_model.do"	

	*Default / MRS variation - Full SIH sample - liquid assets
	global case = 6	
	global batch = "SIH Sample 15/16 (using liquids)" 	
	global fm_switch = 1			
do "4_main_model.do"			

	*Default / MRS variation - Full SIH sample - 150bps fall in cash rate
	global case = 7	
	global batch = "SIH Sample 15/16 (cash rate)" 	
	global stress_cashrate_change = -0.015 
do "4_main_model.do"	
	global stress_cashrate_change_change = 0
	global fm_switch = 0			
	
	*Default / MRS variation - Full SIH sample 2017/18
	global year = 2018
	global case = 8	
	global batch = "SIH Sample 17/18" 	
do "4_main_model.do"
	global year = 2016
	global hes = 1		
	
	*Yao variation
	global case = 9	
	global batch = "Debt-varying MPC (steeper)"   	
	global distribution_results = 1	
	global mpcw_b = 0.2			
do "4_main_model.do"
	global mpcw_b = 0.02		
	global distribution_results = 0
	
	*Higher MPCs
	global case = 10	
	global batch = "Larger MPCs" 
	global mpcy_av = 0.8 
	global mpcw_av = 0.05 
do "4_main_model.do"
	global mpcy_av = 0.55 					
	global mpcw_av = 0.03 				
	
	*Age distribution
	global case = 11	
	global batch = "Age-varying MPCw" 
	global mpcw_type = 3		
do "4_main_model.do"
	global mpcw_type = 2	
	
***Time comparison: no bonuses and HPL
		global bonuscut = 0
		global bascontype = 0		
	*Default with no bonuses and HPL for comparison with 2009/10 and 2003/04
		global case = 12	
		global batch = "15/16 comparison" 						
	do "4_main_model.do"

		*2009/10 constant MPCs & HPL
		global year = 2010
		global case = 13		
		global batch = "09/10 constant MPC"	
	do "4_main_model.do"

		*2009/10 constant elasticity & HPL
		global case = 14
		global batch = "09/10 constant elasticity"	 	
		global mpcy_av = 0.56849 
		global mpcw_av = 0.03077 
	do "4_main_model.do"
		global mpcy_av = 0.55 
		global mpcw_av = 0.03
		
		*2003/04 constant MPCs & HPL
		global year = 2004
		global case = 15
		global batch = "03/04 constant MPC"	
	do "4_main_model.do"

		*2003/04 constant elasticity & HPL
		global case = 16
		global batch = "03/04 constant elasticity"	
		global mpcy_av = 0.63449 
		global mpcw_av = 0.03416 
	do "4_main_model.do"

		*2003/04 constant elasticity & HPL & worse scenario 
		global case = 17		
		global batch = "03/04 constant elasticity (worse scenario)"	 	
		global moderator = 1.017
		*Shocks assumed for scenario*						 	
		global stress_equity = 0.5 * ${moderator}  
		global stress_trust = 0.3 * ${moderator}  
		global stress_super = 0.3 / 0.44 * ${moderator}  
		global stress_housing = 0.4 * ${moderator}  
		global stress_nonres = 0.4 * ${moderator}  
		global mpcy_av = 0.63449 
		global mpcw_av = 0.03416 
	do "4_main_model.do"
		global mpcy_av = 0.55 
		global mpcw_av = 0.03	
		global year = 2016
		global bonuscut = 0.5
		global bascontype = 1	
		global stress_equity = 0.5   
		global stress_trust = 0.3
		global stress_housing = 0.4
		global stress_nonres = 0.4
		global stress_super = 0.3 / 0.44 

	*Variation by DTI for MPCw
	global case = 18	
	global batch = "DTI-varying MPCw" 	
	global mpcw_type = 5		
do "4_main_model.do"
	global mpcw_type = 2
	
	*Relaxing super assumption: Default / MRS variation - HEM, 2.5x financial MPCw
	global age_super_low = 0	
	global age_super_high = 1				
	global case = 19	
	global batch = "No super sensitivity" 	
do "4_main_model.do"
	global age_super_low = 40					
	global age_super_high = 60						
		
	*MPCw  correlated with income
	global case = 20	
	global batch = "Income-varying MPCy" 	
	global mpcw_type = 6			
do "4_main_model.do"		
	global mpcw_type = 2
	
	*Hand-to-mouth
	global case = 21	
	global batch = "Hand-to-mouth (no buffer)" 	
	global htm_with_buffer = 0			
	global mpcw_type = 4		
	global mpcy_type = 4			
do "4_main_model.do"		

	*Hand-to-mouth with buffers
	global case = 22	
	global batch = "Hand-to-mouth" 	
	global htm_with_buffer = 1	
do "4_main_model.do"		
	global mpcw_type = 4		
	global mpcy_type = 4
	
	*Matrix of scenarios
forvalues a = 0(10)40 {
forvalues b = 1(1)8 {	
	global batchUR = "rdp" + "`b'"				
	global case = 0
	global batch = "Default" + "`a'" + "and" + "`b'" 
	global un_multiplier = `b'/8
	
	global year = 2016
	global mpcw_type = 2		
	global mpcy_type = 2		
	global mpcw_b = 0.02		
	global mpcy_av = 0.55 
	global mpcw_av = 0.03 
	
	global hours_fall = 0 * ${un_multiplier} 
	global bonuscut = 0.5 * ${un_multiplier} 	
	global asset_multiplier = `a'/40
	global stress_housing = 0.4 * ${asset_multiplier}
	global stress_nonres = 0.4 * ${asset_multiplier}
	global stress_equity = 0.5 * ${asset_multiplier}   
	global stress_trust = 0.3 * ${asset_multiplier}
	global stress_super = 0.3 / 0.44 * ${asset_multiplier} 
	global stress_other = 0.0 * ${asset_multiplier}
	global stress_invinc = 0.3 * ${asset_multiplier}
	do "4_main_model.do"
	}
	}

	*Bilston RDP comparison / HES
	global year = 2016
	global case = 23	
	global batch = "BJR (2015) scenario - HES" 
	global batchUR = "rdp" + "6"		
	global mpcw_type = 2		
	global mpcy_type = 2		
	global mpcw_b = 0.02		
	global mpcy_av = 0.55
	global mpcw_av = 0.03 
	*Shocks assumed for scenario *						 	
	global stress_equity = 0.25   
	global stress_trust = 0.25
	global stress_housing = 0.25
	global stress_nonres = 0.25
	global stress_other = 0.0
	global stress_super = 0.3 / 0.44  
	global stress_invinc = 0	
	global stress_cashrate_change = 0 
	global hours_fall = 0
	global foreclosure = 0 
	global bonuscut = 0 
do "4_main_model.do"

	*Bilston RDP comparison / SIH
	global hes = 0
	global case = 24	
	global batch = "BJR (2015) scenario - SIH" 	
do "4_main_model.do"

****************************************************************************
*Graph outputs                             		   
****************************************************************************
use "Results", clear
gen y_effect = -con_shock_y_t/gs_exp_ann_t*100
gen w_effect = -con_shock_w_t/gs_exp_ann_t*100	
gen all_effect = -con_shock_t/gs_exp_ann_t*100	
gen increase_share_at_hem = (subsist__t - subsist_t)*100
	
*Graph 8
list batch systemlossh systemlosslmih systemlossh_ systemlosslmih_ if batch=="SIH Sample 15/16" | batch == "SIH Sample 15/16 (using liquids)" 	

*Graph 9 
gen matrix_result = strpos(batch, "Default") > 0  
list batch all_effect if matrix_result == 1
	
*Graph 10
foreach x of new con_shock_w_age con_shock_y_emp_age con_shock_y_inv_age {
forval i = 1/6 {
gen `x'_`i'_share = -`x'_`i' / gs_exp_ann_age_`i' * 100 
}
}
gen inv_effect = -con_shock_y_inv_t/gs_exp_ann_t*100
gen emp_effect = -con_shock_y_emp_t/gs_exp_ann_t*100

list w_effect	emp_effect	inv_effect con_shock_w_age_1_share con_shock_y_emp_age_1_share	con_shock_y_inv_age_1_share con_shock_w_age_2_share con_shock_y_emp_age_2_share	con_shock_y_inv_age_2_share con_shock_w_age_3_share	con_shock_y_emp_age_3_share	con_shock_y_inv_age_3_share con_shock_w_age_4_share	con_shock_y_emp_age_4_share	con_shock_y_inv_age_4_share con_shock_w_age_5_share	con_shock_y_emp_age_5_share	con_shock_y_inv_age_5_share con_shock_w_age_6_share	con_shock_y_emp_age_6_share	con_shock_y_inv_age_6_share if batch == "Debt-varying MPC"

*Graph 11
forval i = 1/5 {
replace asset_to_linsup_DTA_`i' = asset_to_linsup_DTA_`i'/10^6
replace hhdebt_DTA_`i' = hhdebt_DTA_`i'/10^6
}

list age_DTA_1	asset_to_linsup_DTA_1	hhdebt_DTA_1 age_DTA_2	asset_to_linsup_DTA_2	hhdebt_DTA_2 age_DTA_3	asset_to_linsup_DTA_3	hhdebt_DTA_3 age_DTA_4	asset_to_linsup_DTA_4	hhdebt_DTA_4 age_DTA_5	asset_to_linsup_DTA_5	hhdebt_DTA_5 if batch == "Debt-varying MPC"

*Graph 12
forval i = 1/5 {
replace mpcw_DTA_`i' = mpcw_DTA_`i'*100
}

list batch mpcw_DTA_1 mpcw_DTA_2 mpcw_DTA_3 mpcw_DTA_4 mpcw_DTA_5 if batch == "Debt-varying MPC" | batch == "Uniform MPC"  | batch == "Debt-varying MPC (steeper)"

*Graph 13
list batch increase_share_at_hem w_effect y_effect if case == "1" | case == "2" | case == "9" | case == "10" | case == "11" | case == "21"

*Graph 15
list batch increase_share_at_hem w_effect y_effect if case == "12" | case == "14" | case == "16" 
	