# Title: Graph 4-6 and 8
# Creator: Calvin He
# Date Created: 04 November 2019


library(lfe)
library(rGertrude) # RBA package to access internal database
library(data.table)
library(zoo)
library(dummies)
library(rlang)
library(ggplot2)
library(broom)
library(lubridate)
library(tidyverse)

# Step 0: Import functions and data ---------------------------------------

# Import Functions
user.defined.functions<- c(list.files(path = "./R", pattern = ".R",  full.names= T) )
if (length(user.defined.functions)>0){invisible(lapply(user.defined.functions, source))}

# Import Data
corelogic_data_raw <- readRDS("./data/corelogic_data_raw.RDS")
monetary_policy_shocks_raw <- readRDS("./data/monetary_policy_shocks.RDS")
grouping_variables <- readRDS("./data/grouping_variables.RDS")



# Figure 4 --------------------------------------------
opts <- set_options(figure = 4) 

# run specification
output <- differential_response_run(corelogic_data_raw, monetary_policy_shocks_raw, grouping_variables, opts)
output$plot



# Figure 5 --------------------------------------------
opts <- set_options(figure = 6) 

# run specification
output <- differential_response_run(corelogic_data_raw, monetary_policy_shocks_raw, grouping_variables, opts)
output$plot


# Figure 8 --------------------------------------------
opts <- set_options(figure = 8) 

# run specification
output <- differential_response_run(corelogic_data_raw, monetary_policy_shocks_raw, grouping_variables, opts)
output$plot